/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server;

import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.DigitalTVServiceActivator;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.clientdevice.Download;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.clientdevice.DownloadService;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.clientdevice.MarriageTag;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.clientdevice.Messaging;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.clientdevice.MessagingService;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.clientdevice.ParentalControl;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.clientdevice.ParentalControlService;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.clientdevice.Recovery;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.clientdevice.RecoverySoap;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.clientdevice.SmartcardMarriage;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.clientdevice.SmartcardMarriageService;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.clientdevice.TextMode;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.clientdevice.Tuning;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.clientdevice.TuningService;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.entitlement.Entitlement;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.entitlement.EntitlementService;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.sector.ArrayOfString;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.sector.Sector;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.sector.SectorService;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.secureclient.CommandResultData;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.secureclient.Smartcard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.secureclient.SmartcardSoap;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class PisysServiceActivator
extends DigitalTVServiceActivator {
    private static final int RESULT_OK = 1028;
    private Map<Integer, Con> connections = new HashMap<Integer, Con>();

    public PisysServiceActivator(ParameterMap moduleSetup, Connection con, Connection conSlave, int mid, Calendar time) throws BGException {
        super(moduleSetup, con, conSlave, mid, time);
    }

    private Con getConnection(Integer id) throws BGException {
        Con result = this.connections.get(id);
        if (result == null) {
            ParameterMap moduleSetup = this.getModuleSetup(null);
            String host = moduleSetup.get("server." + id + ".host", null);
            int port = moduleSetup.getInt("server." + id + ".port", 80);
            if (Utils.isEmptyString((String)host) || port <= 0) {
                throw new BGException("Host and port for server " + id + " undefined!");
            }
            try {
                Con con = new Con();
                con.operatorTag = moduleSetup.get("server." + id + ".operatorTag", "");
                try {
                    con.textMode = TextMode.valueOf(moduleSetup.get("server." + id + ".textMode", "ANSI"));
                }
                catch (Exception e) {
                    con.textMode = TextMode.ANSI;
                }
                con.sector = new SectorService(new URL("http://" + host + ":" + port + "/pisys/sector/sector.asmx?WSDL"), new QName("http://irdeto.com/pisys/sector", "Sector")).getSector();
                con.entitlement = new EntitlementService(new URL("http://" + host + ":" + port + "/pisys/entitlement/entitlement.asmx?WSDL"), new QName("http://irdeto.com/pisys/entitlement", "Entitlement")).getEntitlement();
                con.messaging = new MessagingService(new URL("http://" + host + ":" + port + "/pisys/clientdevice/messaging.asmx?WSDL"), new QName("http://irdeto.com/pisys/clientdevice", "Messaging")).getMessaging();
                con.parentalControl = new ParentalControlService(new URL("http://" + host + ":" + port + "/pisys/clientdevice/parentalcontrol.asmx?WSDL"), new QName("http://irdeto.com/pisys/clientdevice", "ParentalControl")).getParentalControl();
                con.download = new DownloadService(new URL("http://" + host + ":" + port + "/pisys/clientdevice/download.asmx?WSDL"), new QName("http://irdeto.com/pisys/clientdevice", "Download")).getDownload();
                con.marriage = new SmartcardMarriageService(new URL("http://" + host + ":" + port + "/pisys/clientdevice/SmartcardMarriage.asmx?WSDL"), new QName("http://irdeto.com/pisys/clientdevice", "SmartcardMarriage")).getSmartcardMarriage();
                con.tuning = new TuningService(new URL("http://" + host + ":" + port + "/pisys/clientdevice/tuning.asmx?WSDL"), new QName("http://irdeto.com/pisys/clientdevice", "Tuning")).getTuning();
                con.recovery = new Recovery(new URL("http://" + host + ":" + port + "/pisys/clientdevice/Recovery.asmx?WSDL"), new QName("http://irdeto.com/pisys/clientdevice", "Recovery")).getRecoverySoap12();
                con.smartcard = new Smartcard(new URL("http://" + host + ":" + port + "/pisys/secureclient/SmartCard.asmx?WSDL"), new QName("http://irdeto.com/pisys/secureclient", "Smartcard")).getSmartcardSoap12();
                result = con;
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
            this.connections.put(id, result);
        }
        return result;
    }

    private static DigitalTVServiceActivator.ServiceActivationResult checkAnswer(ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.clientdevice.CommandResultData crd) {
        if (1028 == crd.getCode()) {
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        return new DigitalTVServiceActivator.ServiceActivationResult(false, crd.getCode() + ": " + crd.getMessage());
    }

    private static DigitalTVServiceActivator.ServiceActivationResult checkAnswer(CommandResultData crd) {
        if (1028 == crd.getCode()) {
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        return new DigitalTVServiceActivator.ServiceActivationResult(false, crd.getCode() + ": " + crd.getMessage());
    }

    private static DigitalTVServiceActivator.ServiceActivationResult checkAnswer(ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.entitlement.CommandResultData crd) {
        if (1028 == crd.getCode()) {
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        return new DigitalTVServiceActivator.ServiceActivationResult(false, crd.getCode() + ": " + crd.getMessage());
    }

    private static DigitalTVServiceActivator.ServiceActivationResult checkAnswer(ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.sector.CommandResultData crd) {
        if (1028 == crd.getCode()) {
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        return new DigitalTVServiceActivator.ServiceActivationResult(false, crd.getCode() + ": " + crd.getMessage());
    }

    private static void sendErrorAlarm(Con con, String exMessage, String methodName) {
        String key = "pisys.service.activator.error";
        AlarmSender.sendAlarm((String)key, (long)300000L, (String)"\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c!", (String)("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c Pisys: \"" + exMessage + "\"!" + (String)(con != null ? "\n\u041a\u043e\u0434 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: " + con.operatorTag + "\n\u0412\u0435\u0431-\u0441\u0435\u0440\u0432\u0438\u0441: " + con.sector : "\n\u041d\u0435\u0442 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f (con == null)!") + "\n\u0424\u0443\u043d\u043a\u0446\u0438\u044f: " + methodName));
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult activateImpl(long cardNumber, UserCard card, List<CardPacket> cardPacketList) throws BGException {
        Con con = null;
        try {
            if (card == null) {
                return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041a\u0430\u0440\u0442\u0430 \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u0430 \u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443, \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0435\u0442, \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043d\u0435\u0447\u0435\u0433\u043e", null);
            }
            Iterator<Map.Entry<Integer, List<String>>> iterator = this.getCardServerMaskMap(cardPacketList).entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<Integer, List<String>> e = iterator.next();
                ParameterMap moduleSetup = this.getModuleSetup(null);
                con = this.getConnection(e.getKey());
                ArrayOfString productTagList = new ArrayOfString();
                productTagList.getString().addAll((Collection<String>)e.getValue());
                return PisysServiceActivator.checkAnswer(con.sector.createSector(con.operatorTag, card.getNumber() / 10L, moduleSetup.get("server." + e.getKey() + ".nationality", "RUS"), moduleSetup.get("server." + e.getKey() + ".regionTag", "MO"), productTagList));
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Exception in modifyImpl", (Throwable)ex);
            PisysServiceActivator.sendErrorAlarm(con, ex.getMessage(), "createImpl");
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult modifyImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        Con con = null;
        try {
            Iterator<Map.Entry<Integer, List<String>>> iterator = this.getCardServerMaskMap(cardPacketList).entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<Integer, List<String>> e = iterator.next();
                con = this.getConnection(e.getKey());
                ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.entitlement.ArrayOfString productTagList = new ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys.com.irdeto.pisys.entitlement.ArrayOfString();
                productTagList.getString().addAll((Collection<String>)e.getValue());
                return PisysServiceActivator.checkAnswer(con.entitlement.overwriteEntitlements(con.operatorTag, card.getNumber() / 10L, productTagList));
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Exception in modifyImpl", (Throwable)ex);
            PisysServiceActivator.sendErrorAlarm(con, ex.getMessage(), "modifyImpl");
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(long cardNumber) throws BGException {
        Con con = null;
        try {
            for (int serverCode : this.serversManager.getServerCodes()) {
                con = this.getConnection(serverCode);
                PisysServiceActivator.checkAnswer(con.entitlement.deleteAllEntitlements(con.operatorTag, cardNumber / 10L));
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Exception in cancelImpl", (Throwable)ex);
            PisysServiceActivator.sendErrorAlarm(con, ex.getMessage(), "cancelImpl");
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        Con con = null;
        try {
            Iterator<Map.Entry<Integer, List<String>>> iterator = this.getCardServerMaskMap(cardPacketList).entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<Integer, List<String>> e = iterator.next();
                con = this.getConnection(e.getKey());
                return PisysServiceActivator.checkAnswer(con.entitlement.deleteAllEntitlements(con.operatorTag, card.getNumber() / 10L));
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Exception in cancelImpl [" + (con != null ? con.operatorTag : "") + " : " + card.getNumber() / 10L, (Throwable)ex);
            PisysServiceActivator.sendErrorAlarm(con, ex.getMessage(), "cancelImpl");
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult sendMessagesImpl(List<Long> cardNumbers, String title, String message, boolean ismail) {
        try {
            Con con = this.getConnection(0);
            if (cardNumbers == null) {
                if (ismail) {
                    return PisysServiceActivator.checkAnswer(con.messaging.sendMailGlobal(con.operatorTag, message, con.textMode, "", "", "", "", ""));
                }
                return PisysServiceActivator.checkAnswer(con.messaging.sendMessageGlobal(con.operatorTag, message, con.textMode, "", "", "", "", ""));
            }
            for (Long cardNumber : cardNumbers) {
                DigitalTVServiceActivator.ServiceActivationResult result = null;
                result = ismail ? PisysServiceActivator.checkAnswer(con.messaging.sendMail(con.operatorTag, cardNumber / 10L, message, con.textMode)) : PisysServiceActivator.checkAnswer(con.messaging.sendMessage(con.operatorTag, cardNumber / 10L, message, con.textMode));
                if (result == DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK) continue;
                return result;
            }
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        catch (Exception ex) {
            this.getLogger().error("Exception sendMessagesImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult parentalPinCodeImpl(long cardNumber, String pinCode) {
        try {
            Con con = this.getConnection(0);
            if (Utils.notBlankString((String)pinCode)) {
                return PisysServiceActivator.checkAnswer(con.parentalControl.createParentalPinCode(con.operatorTag, cardNumber / 10L, pinCode));
            }
            return PisysServiceActivator.checkAnswer(con.parentalControl.overwriteParentalPinCode(con.operatorTag, cardNumber / 10L));
        }
        catch (Exception ex) {
            this.getLogger().error("Exception", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    @Override
    public DigitalTVServiceActivator.ServiceActivationResult customCommandImpl(long cardNumber, String action, String[] params) throws BGException {
        switch (action) {
            case "downloadCode": {
                return this.downloadCodeImpl(cardNumber);
            }
            case "patchSmartCard": {
                return this.patchSmartCardImpl(cardNumber);
            }
            case "marrySmartcard_on": {
                return this.marrySmartcardImpl(cardNumber, true);
            }
            case "marrySmartcard_off": {
                return this.marrySmartcardImpl(cardNumber, false);
            }
            case "tune": {
                return this.tuneImpl(cardNumber, false, "");
            }
            case "recoverSectorDatecode": {
                UserCard userCard = this.userCardManager.getUserCard(cardNumber, new Date());
                short years = (short)this.getModuleSetup(userCard).getInt("sa.recover.years", 5);
                return this.recoverSectorDatecodeImpl(cardNumber, years);
            }
        }
        throw new UnsupportedOperationException();
    }

    protected DigitalTVServiceActivator.ServiceActivationResult downloadCodeImpl(long cardNumber) {
        try {
            Con con = this.getConnection(0);
            return PisysServiceActivator.checkAnswer(con.download.downloadCode(con.operatorTag, cardNumber / 10L));
        }
        catch (Exception ex) {
            this.getLogger().error("Exception", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    protected DigitalTVServiceActivator.ServiceActivationResult marrySmartcardImpl(long cardNumber, boolean marry) {
        try {
            Con con = this.getConnection(0);
            if (marry) {
                return PisysServiceActivator.checkAnswer(con.marriage.marrySmartcard(con.operatorTag, cardNumber / 10L, MarriageTag.MARRY));
            }
            return PisysServiceActivator.checkAnswer(con.marriage.divorceSmartcard(con.operatorTag, cardNumber / 10L));
        }
        catch (Exception ex) {
            this.getLogger().error("Exception", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    protected DigitalTVServiceActivator.ServiceActivationResult tuneImpl(long cardNumber, boolean emergency, String message) {
        try {
            Con con = this.getConnection(0);
            if (emergency) {
                ParameterMap moduleSetup = this.getModuleSetup(null);
                ParameterMap params = moduleSetup.sub("server.0.emergency");
                int networkId = params.getInt("networkId", 0);
                int transportId = params.getInt("transportId", 0);
                int serviceId = params.getInt("serviceId", 0);
                if (cardNumber == -1L) {
                    return PisysServiceActivator.checkAnswer(con.tuning.tuneToTargetedEmergencyServiceGlobal(con.operatorTag, "", networkId, transportId, serviceId));
                }
                return PisysServiceActivator.checkAnswer(con.tuning.tuneToEmergencyService(con.operatorTag, cardNumber / 10L, networkId, transportId, serviceId));
            }
            if (cardNumber == -1L) {
                return PisysServiceActivator.checkAnswer(con.recovery.rescanAllNetworksGlobal(con.operatorTag, ""));
            }
            return PisysServiceActivator.checkAnswer(con.recovery.rescanAllNetworks(con.operatorTag, cardNumber / 10L));
        }
        catch (Exception ex) {
            this.getLogger().error("Exception", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    protected DigitalTVServiceActivator.ServiceActivationResult patchSmartCardImpl(long cardNumber) throws BGException {
        try {
            Con con = this.getConnection(0);
            return PisysServiceActivator.checkAnswer(con.smartcard.patchSmartcard(con.operatorTag, cardNumber / 10L));
        }
        catch (Exception ex) {
            this.getLogger().error("Exception", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    protected DigitalTVServiceActivator.ServiceActivationResult recoverSectorDatecodeImpl(long cardNumber, short years) throws BGException {
        try {
            Con con = this.getConnection(0);
            return PisysServiceActivator.checkAnswer(con.sector.recoverSectorDatecode(con.operatorTag, cardNumber / 10L, years));
        }
        catch (Exception ex) {
            this.getLogger().error("Exception", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    public static void main(String[] args) {
        Object s = " 1000, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1012, 1013, 1028, 1036, 1038, 1040, 1041, 1086, 1087, 1088, 1094, 1095, 1132, 1155, 1180, 1213, 1243, 1265";
        s = (String)s + ",1000, 1001, 1007, 1013, 1020, 1028, 1036, 1243, 1244, 1245, 1256, 1265, 1267";
        s = (String)s + ",1000, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1012, 1013, 1028, 1036, 1038, 1040, 1041, 1086, 1087, 1088, 1094, 1095, 1132, 1155, 1180, 1213, 1243, 1265";
        s = (String)s + ",1000, 1001, 1003, 1004, 1005, 1006, 1007, 1012, 1013, 1020, 1028, 1033, 1034, 1036, 1038, 1039, 1086, 1087, 1088, 1094, 1095, 1155, 1180, 1243, 1265, 1267";
        s = (String)s + ", 1000, 1001, 1007, 1012, 1013, 1020, 1028, 1033, 1036, 1039, 1265, 1267";
        s = (String)s + ",  1000, 1028, 1036, 1234, 1265, 1267, 1268, 1324, 1325";
        s = (String)s + ",  1000, 1028, 1036, 1234, 1265, 1267, 1268, 1324, 1325";
        s = (String)s + ",  1000, 1001, 1028, 1036, 1234, 1265, 1267";
        s = (String)s + ",  1000, 1001, 1028, 1036, 1234, 1265, 1267";
        s = (String)s + ",  1000, 1001, 1028, 1036, 1098, 1180, 1265, 1267";
        s = (String)s + ",  1001, 1028, 1036, 1180, 1265, 1267";
        s = (String)s + ",  1000, 1001, 1027, 1028, 1265";
        s = (String)s + ",  1000, 1001, 1028, 1036, 1100, 1180, 1265, 1267, 1268";
        s = (String)s + ",  1000, 1001, 1028, 1036, 1100, 1180, 1265, 1267, 1268";
        s = (String)s + ",  1000, 1001, 1028, 1036, 1265";
        s = (String)s + ",  1000, 1001, 1028, 1036, 1265";
        s = (String)s + ",  1000, 1028, 1036, 1265, 1268, 1324, 1325";
        ArrayList ss = Utils.toList((String)s);
        HashSet set = new HashSet(ss);
        ss = new ArrayList(set);
        Collections.sort(ss);
        for (String c : ss) {
            System.out.println("pisys.result." + c + "=");
        }
    }

    private class Con {
        protected String operatorTag;
        protected TextMode textMode;
        protected Entitlement entitlement;
        protected Messaging messaging;
        protected ParentalControl parentalControl;
        protected Download download;
        protected SmartcardMarriage marriage;
        protected Tuning tuning;
        protected Sector sector;
        protected RecoverySoap recovery;
        protected SmartcardSoap smartcard;

        private Con() {
        }
    }
}

