/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.converter;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.modules.hd.common.bean.Zone;
import ru.bitel.bgbilling.modules.hd.server.bean.ZoneDAO;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class ConverterRecordsZone {
    private Connection con = null;
    private Setup setup = new Setup("data", "data");
    private ZoneDAO zoneDAO = null;

    public ConverterRecordsZone(int mid) {
        this.con = this.setup.getDBConnectionFromPool();
        this.zoneDAO = new ZoneDAO(this.con, mid);
    }

    public static void main(String[] args) {
        int mid = Integer.valueOf(args[0]);
        ConverterRecordsZone conv = new ConverterRecordsZone(mid);
        conv.Run();
    }

    public void Run() {
        List<Zone> zonelist = this.zoneDAO.getZoneList();
        for (Zone zone : zonelist) {
            Map map = zone.getParamsMap();
            String res = null;
            String r = (String)map.get("record");
            if (!Utils.notBlankString((String)r)) {
                String data = zone.getData();
                if (Utils.notBlankString((String)data)) continue;
                res = "";
            } else {
                res = this.convertRecords(r);
            }
            zone.setData(res);
            map.remove("record");
            this.zoneDAO.updateZone(zone);
        }
    }

    private String convertRecords(String r) {
        StringBuilder sb = new StringBuilder();
        String[] records = r.split(";");
        for (int i = 0; i < records.length; ++i) {
            if (records[i] == null) continue;
            sb.append(records[i]);
            if (i == records.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }
}

