/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.event;

import jakarta.xml.bind.annotation.XmlRootElement;
import javax.jms.JMSException;
import javax.jms.Message;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.PoolEventPublisher;
import ru.bitel.bgbilling.kernel.event.common.PoolQueueEvent;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;

@EventType(timeToLive=600000L, deliveryMode=1)
@XmlRootElement
public class InetAccountingManagePoolEvent
extends PoolQueueEvent {
    public static final int TYPE_START = 1;
    public static final int TYPE_STOP = 2;
    public static final int TYPE_UPDATE = 3;
    private final int accountingRootDeviceId;
    private final int type;
    private InetConnection connection;

    protected InetAccountingManagePoolEvent() {
        this.accountingRootDeviceId = -1;
        this.type = -1;
    }

    public InetAccountingManagePoolEvent(int moduleId, int contractId, int userId, int accountingRootDeviceId, InetConnection connection, int type) {
        super(moduleId, contractId, userId);
        this.accountingRootDeviceId = accountingRootDeviceId;
        this.connection = connection;
        this.type = type;
    }

    public InetAccountingManagePoolEvent(PoolEventPublisher<InetAccountingManagePoolEvent> publisher, int contractId, int userId, int accountingRootDeviceId, InetConnection connection, int type) {
        super(publisher, contractId, userId);
        this.accountingRootDeviceId = accountingRootDeviceId;
        this.connection = connection;
        this.type = type;
    }

    public InetConnection getConnection() {
        return this.connection;
    }

    public void setConnection(InetConnection connection) {
        this.connection = connection;
    }

    public int getType() {
        return this.type;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("accountingRootDeviceId", this.accountingRootDeviceId);
    }

    protected void toString(StringBuilder sb) {
        sb.append("; type: ");
        sb.append(this.type);
        sb.append("; deviceId: ");
        sb.append(this.connection.getDeviceId());
        sb.append("; connectionId: ");
        sb.append(this.connection.getId());
    }
}

