/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.plugins.shop.common.bean.ShopDirectoryItem;
import ru.bitel.common.model.Id;

public class ShopDirectoryItemDao
extends AbstractIdDao<ShopDirectoryItem> {
    public ShopDirectoryItemDao(Connection con) {
        super(con, 0, "shop_directory_item");
    }

    public List<ShopDirectoryItem> list() throws SQLException {
        return this.list("", "title", new Object[0]);
    }

    protected ShopDirectoryItem getFromRS(ResultSet rs) throws SQLException {
        JSONArray filterList;
        ShopDirectoryItem shopDirectoryItem = new ShopDirectoryItem();
        shopDirectoryItem.setId(rs.getInt("id"));
        shopDirectoryItem.setParentId(rs.getInt("parent_id"));
        shopDirectoryItem.setTitle(rs.getString("title"));
        shopDirectoryItem.setAllowSubDirectory(rs.getBoolean("allow_sub_directory"));
        String data = rs.getString("data");
        JSONObject jsonObject = new JSONObject(data == null || data.isEmpty() ? "{}" : data);
        JSONArray itemTypeIds = jsonObject.optJSONArray("itemTypeIds");
        if (itemTypeIds != null) {
            itemTypeIds.forEach(id -> shopDirectoryItem.getItemTypeIds().add((Integer)id));
        }
        if ((filterList = jsonObject.optJSONArray("filters")) != null) {
            filterList.forEach(a -> shopDirectoryItem.getFilterList().add(((JSONObject)a).toString()));
        }
        return shopDirectoryItem;
    }

    protected void updateImpl(ShopDirectoryItem shopDirectoryItem) throws SQLException {
        String querySet = "parent_id=?, title=?, allow_sub_directory=?, data=?";
        try (PreparedStatement ps = this.prepareStatement((Id)shopDirectoryItem, querySet);){
            JSONObject data = new JSONObject();
            JSONArray itemTypeIds = new JSONArray();
            shopDirectoryItem.getItemTypeIds().forEach(a -> itemTypeIds.put(a));
            data.put("itemTypeIds", (Object)itemTypeIds);
            JSONArray filterList = new JSONArray();
            shopDirectoryItem.getFilterList().forEach(a -> filterList.put((Object)new JSONObject(a)));
            data.put("filters", (Object)filterList);
            int index = 1;
            ps.setInt(index++, shopDirectoryItem.getParentId());
            ps.setString(index++, shopDirectoryItem.getTitle());
            ps.setBoolean(index++, shopDirectoryItem.isAllowSubDirectory());
            ps.setString(index++, data.toString());
            this.executeUpdate((Id)shopDirectoryItem, index, ps);
        }
    }
}

