/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.bonus.server.task;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.kernel.task.server.bean.TaskParameter;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusProgram;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusProgramSpecification;
import ru.bitel.bgbilling.plugins.bonus.server.dao.BonusDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class CalculationBonus
extends TaskBase {
    List<Integer> programIds = null;

    protected boolean initTask() {
        this.programIds = Utils.toIntegerList((String)this.getTaskSetup().get("program.ids"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            con.setAutoCommit(false);
            BonusDao bonusDao = new BonusDao(con);
            List<BonusProgram> bonusPrograms = bonusDao.getProgramList(new Date(), 0);
            for (BonusProgram program : bonusPrograms) {
                BonusProgramSpecification specification;
                if (!this.programIds.isEmpty() && !this.programIds.contains(program.getId()) || (specification = bonusDao.getProgramAction(program)) == null) continue;
                specification.accrualOfBonus(con, program);
            }
            con.commit();
        }
        catch (Exception e) {
            try {
                con.rollback();
            }
            catch (SQLException e1) {
                this.getLogger().error(e1.getMessage(), (Throwable)e1);
            }
            this.getLogger().error(e.getMessage(), (Throwable)e);
            this.error = e;
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    public String getDescription() {
        return this.defaultDescription + "\u041f\u043b\u0430\u0433\u0438\u043d Bonus. \u0417\u0430\u0434\u0430\u0447\u0430, \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u0431\u043e\u043d\u0443\u0441\u043e\u0432 \u0437\u0430 \u043f\u0440\u0438\u0445\u043e\u0434\u044b.";
    }

    public List<TaskParameter> taskParameters() {
        List taskParameters = super.taskParameters();
        taskParameters.add(new TaskParameter().setKey("program.ids").setTitle("program.ids").setDefaultValue(""));
        return taskParameters;
    }
}

