/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.tariff;

import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffRequest;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class RealmTariffTreeNode
extends TariffTreeNode<InetTariffRequest, InetTariffContext, TreeContext, InetTariffWorkerContext> {
    private final Set<String> realms;

    public RealmTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.realms = Utils.toSet((String)parameterMap.get("realms", ""));
    }

    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, InetTariffRequest req, InetTariffContext ctx, TreeContext treeContext, InetTariffWorkerContext workerContext) {
        if (this.realms.size() == 0) {
            Set acceptedSet = req.getAcceptedSet(RealmTariffTreeNode.class);
            if (!acceptedSet.contains(parentTreeNodeId)) {
                acceptedSet.add(parentTreeNodeId);
                return 1;
            }
            return 0;
        }
        if (req.realm != null ? !this.realms.contains(req.realm) : !this.realms.contains("null")) {
            return 0;
        }
        Set acceptedSet = req.getAcceptedSet(RealmTariffTreeNode.class);
        acceptedSet.add(parentTreeNodeId);
        return 1;
    }
}

