/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.service;

import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCamera;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCameraBrand;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCameraModel;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCameraType;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostMaster;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostObject;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostProtocol;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostPtzType;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostRecordType;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostRemoteMaster;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostRtspTransport;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostTMCAO;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostUser;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostUtils;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostService;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ForpostDirectoryRuntime;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ForpostManager;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseId;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseStatus;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostAccountDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostCameraDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostDefaultHandler;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostObjectDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostUserDao;
import ru.bitel.bgbilling.modules.smarthouse.server.event.ForpostCameraAddEvent;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostService")
public class ForpostServiceImpl
extends AbstractService
implements ForpostService {
    public SearchResult<ForpostMaster> forpostMasterSearch(String[] sort, Page page) throws Exception {
        List<ForpostMaster> forpostMasters = ForpostDirectoryRuntime.getInstance(this.moduleId).getMasters();
        page.setRecordCount(forpostMasters.size());
        SearchResult searchResult = new SearchResult(page, sort);
        searchResult.setList(forpostMasters.stream().skip(page.indexStart()).limit(page.getPageSize()).toList());
        return searchResult;
    }

    public void forpostMasterSync() throws Exception {
        this.checkTestMode();
        ForpostDirectoryRuntime.getInstance(this.moduleId).resetMasters();
    }

    public List<ForpostMaster> forpostMasterList() throws Exception {
        return ForpostDirectoryRuntime.getInstance(this.moduleId).getMasters();
    }

    public SearchResult<ForpostRemoteMaster> forpostRemoteMasterSearch(String[] sort, Page page) throws Exception {
        List<ForpostRemoteMaster> forpostRemoteMasters = ForpostDirectoryRuntime.getInstance(this.moduleId).getRemoteMasters();
        page.setRecordCount(forpostRemoteMasters.size());
        SearchResult searchResult = new SearchResult(page, sort);
        searchResult.setList(forpostRemoteMasters.stream().skip(page.indexStart()).limit(page.getPageSize()).toList());
        return searchResult;
    }

    public void forpostRemoteMasterSync() throws Exception {
        this.checkTestMode();
        ForpostDirectoryRuntime.getInstance(this.moduleId).resetRemoteMasters();
    }

    public List<ForpostRemoteMaster> forpostRemoteMasterList() throws Exception {
        return ForpostDirectoryRuntime.getInstance(this.moduleId).getRemoteMasters();
    }

    public SearchResult<ForpostProtocol> forpostProtocolSearch(String[] sort, Page page) throws Exception {
        List<ForpostProtocol> forpostProtocols = ForpostDirectoryRuntime.getInstance(this.moduleId).getProtocols();
        page.setRecordCount(forpostProtocols.size());
        SearchResult searchResult = new SearchResult(page, sort);
        searchResult.setList(forpostProtocols.stream().skip(page.indexStart()).limit(page.getPageSize()).toList());
        return searchResult;
    }

    public void forpostProtocolSync() throws Exception {
        this.checkTestMode();
        ForpostDirectoryRuntime.getInstance(this.moduleId).resetProtocols();
    }

    public List<ForpostProtocol> forpostProtocolList() throws Exception {
        return ForpostDirectoryRuntime.getInstance(this.moduleId).getProtocols();
    }

    public SearchResult<ForpostPtzType> forpostPtzTypeSearch(String[] sort, Page page) throws Exception {
        List<ForpostPtzType> forpostPtzTypes = ForpostDirectoryRuntime.getInstance(this.moduleId).getPtzTypes();
        page.setRecordCount(forpostPtzTypes.size());
        SearchResult searchResult = new SearchResult(page, sort);
        searchResult.setList(forpostPtzTypes.stream().skip(page.indexStart()).limit(page.getPageSize()).toList());
        return searchResult;
    }

    public void forpostPtzTypeSync() throws Exception {
        this.checkTestMode();
        ForpostDirectoryRuntime.getInstance(this.moduleId).resetPtzTypes();
    }

    public List<ForpostPtzType> forpostPtzTypeList() throws Exception {
        return ForpostDirectoryRuntime.getInstance(this.moduleId).getPtzTypes();
    }

    public SearchResult<ForpostRecordType> forpostRecordTypeSearch(String[] sort, Page page) throws Exception {
        List<ForpostRecordType> forpostRecordTypes = ForpostDirectoryRuntime.getInstance(this.moduleId).getRecordTypes();
        page.setRecordCount(forpostRecordTypes.size());
        SearchResult searchResult = new SearchResult(page, sort);
        searchResult.setList(forpostRecordTypes.stream().skip(page.indexStart()).limit(page.indexEnd()).toList());
        return searchResult;
    }

    public void forpostRecordTypeSync() throws Exception {
        this.checkTestMode();
        ForpostDirectoryRuntime.getInstance(this.moduleId).resetRecordTypes();
    }

    public List<ForpostRecordType> forpostRecordTypeList() throws Exception {
        return ForpostDirectoryRuntime.getInstance(this.moduleId).getRecordTypes();
    }

    public SearchResult<ForpostRtspTransport> forpostRtspTransportSearch(String[] sort, Page page) throws Exception {
        List<ForpostRtspTransport> forpostRtspTransports = ForpostDirectoryRuntime.getInstance(this.moduleId).getRtspTransports();
        page.setRecordCount(0);
        SearchResult searchResult = new SearchResult(page, sort);
        searchResult.setList(forpostRtspTransports.stream().skip(page.indexStart()).limit(page.getPageSize()).toList());
        return searchResult;
    }

    public void forpostRtspTransportSync() throws Exception {
        this.checkTestMode();
        ForpostDirectoryRuntime.getInstance(this.moduleId).resetRtspTransports();
    }

    public List<ForpostRtspTransport> forpostRtspTransportList() throws Exception {
        return ForpostDirectoryRuntime.getInstance(this.moduleId).getRtspTransports();
    }

    public SearchResult<ForpostCameraBrand> forpostCameraBrandSearch(String[] sort, Page page) throws Exception {
        List<ForpostCameraBrand> forpostCameraBrands = ForpostDirectoryRuntime.getInstance(this.moduleId).getCameraBrands();
        page.setRecordCount(forpostCameraBrands.size());
        SearchResult searchResult = new SearchResult(page, sort);
        searchResult.setList(forpostCameraBrands.stream().skip(page.indexStart()).limit(page.getPageSize()).toList());
        return searchResult;
    }

    public void forpostCameraBrandSync() throws Exception {
        this.checkTestMode();
        ForpostDirectoryRuntime.getInstance(this.moduleId).resetCameraBrands();
    }

    public List<ForpostCameraBrand> forpostCameraBrandList() throws Exception {
        return ForpostDirectoryRuntime.getInstance(this.moduleId).getCameraBrands();
    }

    public SearchResult<ForpostCameraModel> forpostCameraModelSearch(int brandId, String[] sort, Page page) throws Exception {
        List<ForpostCameraModel> forpostCameraModels = ForpostDirectoryRuntime.getInstance(this.moduleId).getCameraModels();
        page.setRecordCount(forpostCameraModels.size());
        SearchResult searchResult = new SearchResult(page, sort);
        searchResult.setList(forpostCameraModels.stream().skip(page.indexStart()).limit(page.getPageSize()).toList());
        return searchResult;
    }

    public void forpostCameraModelSync() throws Exception {
        this.checkTestMode();
        ForpostDirectoryRuntime.getInstance(this.moduleId).resetCameraBrands();
        ForpostDirectoryRuntime.getInstance(this.moduleId).resetCameraModels();
    }

    public List<ForpostCameraModel> forpostCameraModelList() throws Exception {
        try (ForpostCameraDao forpostCameraDao = new ForpostCameraDao(this.getConnection(), this.moduleId);){
            Map<Integer, Integer> cameraModelStats = forpostCameraDao.getForpostCameraModelStat();
            List<ForpostCameraModel> cameraModels = ForpostDirectoryRuntime.getInstance(this.moduleId).getCameraModels();
            cameraModels.forEach(e -> e.setUseCount(cameraModelStats.getOrDefault(e.getId(), 0).intValue()));
            List<ForpostCameraModel> list = cameraModels;
            return list;
        }
    }

    public ForpostCameraModel forpostCameraModelGet(int id) throws Exception {
        return ForpostDirectoryRuntime.getInstance(this.moduleId).getCameraModels().stream().filter(a -> a.getId() == id).findFirst().orElse(null);
    }

    public SearchResult<ForpostCameraType> forpostCameraTypeSearch(String[] sort, Page page) throws Exception {
        return null;
    }

    public void forpostCameraTypeSync() throws Exception {
    }

    public List<ForpostCameraType> forpostCameraTypelList() throws Exception {
        return null;
    }

    public ForpostCameraType forpostCameraTypeGet(int id) throws Exception {
        return null;
    }

    public SearchResult<ForpostTMCAO<ForpostUser>> forpostUsersSearch(String[] sort, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page, sort);
        try (ForpostUserDao forpostUserDao = new ForpostUserDao(this.getConnection(), this.moduleId);){
            forpostUserDao.searchForpostUsers((SearchResult<ForpostTMCAO<ForpostUser>>)searchResult);
        }
        return searchResult;
    }

    public SearchResult<ForpostUser> forpostAccountUserSearch(int accountId) throws Exception {
        SearchResult searchResult = new SearchResult();
        try (ForpostUserDao forpostUserDao = new ForpostUserDao(this.getConnection(), this.moduleId);){
            forpostUserDao.searchForpostAccountUsers((SearchResult<ForpostUser>)searchResult, accountId);
        }
        return searchResult;
    }

    public void forpostUserSync() throws Exception {
        this.checkTestMode();
        try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);
             ForpostUserDao forpostUserDao = new ForpostUserDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            for (int accountId : forpostAccountDao.getIds()) {
                forpostUserDao.doSync(accountId, forpostManager.getAccountUsers(accountId, null));
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void forpostUsersSync(int accountId) throws Exception {
        this.checkTestMode();
        try (ForpostUserDao forpostUserDao = new ForpostUserDao(this.getConnection(), this.moduleId);){
            forpostUserDao.doSync(accountId, new ForpostManager(this.moduleId).getAccountUsers(accountId, null));
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public ForpostUser forpostUserDefaultGet(int contractId, int accountId) throws Exception {
        return this.getForpostDefaultHandler().getForpostUserDefault((ParameterMap)this.getModuleSetup(), contractId, accountId);
    }

    public int forpostUserAdd(ForpostUser forpostUser) throws Exception, BGMessageException {
        int n;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Login", forpostUser.getLogin());
        params.put("AccountID", String.valueOf(forpostUser.getAccountId()));
        params.put("Password", forpostUser.getPassword());
        Optional.ofNullable(forpostUser.get("Email")).ifPresent(a -> params.put("Email", String.valueOf(a)));
        ForpostUserDao forpostUserDao = new ForpostUserDao(this.getConnection(), this.moduleId);
        try {
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            ResponseId responseId = forpostManager.addUser(params);
            if (responseId.getErrorCode() > 0) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
            }
            int userId = responseId.getId();
            forpostUser.setId(userId);
            forpostUserDao.update(forpostUser);
            forpostUserDao.doSync(forpostUser.getAccountId(), forpostManager.getAccountUsers(forpostUser.getAccountId(), null));
            n = userId;
        }
        catch (Throwable throwable) {
            try {
                try {
                    forpostUserDao.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BGMessageException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        forpostUserDao.close();
        return n;
    }

    public void forpostUserUpdate(ForpostUser forpostUser) throws Exception, BGMessageException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ID", String.valueOf(forpostUser.getId()));
        ForpostUtils.putParams(params, (String)"Login", (String)forpostUser.getLogin());
        ForpostUtils.putParams(params, (String)"Password", (String)forpostUser.getPassword());
        ForpostUtils.putParams(params, (String)"Email", (String)forpostUser.getString("Email"));
        ForpostUtils.putParams(params, (String)"Phone", (String)forpostUser.getString("Phone"));
        ForpostUtils.putParams(params, (String)"FIO", (String)forpostUser.getString("FIO"));
        ForpostUtils.putParams(params, (String)"IsReadOnly", (String)forpostUser.getString("IsReadOnly"));
        ForpostUtils.putParams(params, (String)"CanChangeOwnInfo", (String)forpostUser.getString("CanChangeOwnInfo"));
        ForpostUtils.putParams(params, (String)"ChangePasswordAtNextLogin", (String)forpostUser.getString("ChangePasswordAtNextLogin"));
        ForpostUtils.putParams(params, (String)"AuthProviderID", (String)forpostUser.getString("AuthProviderID"));
        ForpostUtils.putParams(params, (String)"IsActive", (String)String.valueOf(forpostUser.getIsActive()));
        try (ForpostUserDao forpostUserDao = new ForpostUserDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            try {
                ResponseId responseId = forpostManager.editUser(params);
                if (responseId.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
                }
                forpostUserDao.update(forpostUser);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void forpostUserParamUpdate(int forpostUserId, String name, String value) throws Exception, BGMessageException {
        try (ForpostUserDao forpostUserDao = new ForpostUserDao(this.getConnection(), this.moduleId);){
            ForpostUser forpostUser = forpostUserDao.getForpostUser(forpostUserId);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("ID", String.valueOf(forpostUser.getId()));
            params.put(name, value);
            switch (name) {
                case "Login": {
                    forpostUser.setLogin(value);
                    break;
                }
                case "Password": {
                    forpostUser.setPassword(value);
                    break;
                }
                case "IsActive": {
                    forpostUser.setIsActive(Utils.parseInt((String)value));
                    break;
                }
                default: {
                    forpostUser.put(name, (Object)value);
                }
            }
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            try {
                ResponseId responseId;
                ResponseId responseId2 = responseId = "Password".equals(name) ? forpostManager.editUserPassword(params) : forpostManager.editUser(params);
                if (responseId.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
                }
                forpostUserDao.update(forpostUser);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void forpostUserDelete(int id) throws Exception {
        try (ForpostUserDao forpostUserDao = new ForpostUserDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            ResponseStatus responseStatus = forpostManager.deleteUser(id);
            if (responseStatus.getErrorCode() > 0) {
                if (responseStatus.getErrorCode() == 1) {
                    // empty if block
                }
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseStatus.getErrorCode() + " - " + responseStatus.getError());
            }
            forpostUserDao.deleteForpostUser(id);
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void forpostAccountUsersDelete(int accountId) throws Exception, BGMessageException {
        try (ForpostUserDao forpostUserDao = new ForpostUserDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            SearchResult searchResult = new SearchResult();
            forpostUserDao.searchForpostAccountUsers((SearchResult<ForpostUser>)searchResult, accountId);
            for (ForpostUser forpostUser : searchResult.getList()) {
                ResponseStatus responseStatus = forpostManager.deleteUser(forpostUser.getId());
                if (responseStatus.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseStatus.getErrorCode() + " - " + responseStatus.getError());
                }
                forpostUserDao.deleteForpostUser(forpostUser.getId());
            }
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<KeyValue> forpostCameraList() throws Exception {
        ArrayList<CameraItem> list = new ArrayList<CameraItem>();
        list.add(new CameraItem().setId(0).setName("\u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430"));
        ServerContext serverContext = (ServerContext)ServerContext.get();
        List cameraBrands = ((ForpostService)serverContext.getService(ForpostService.class, this.moduleId)).forpostCameraBrandList();
        List cameraModels = ((ForpostService)serverContext.getService(ForpostService.class, this.moduleId)).forpostCameraModelList();
        for (ForpostCameraModel cameraModel : cameraModels) {
            ForpostCameraBrand cameraBrand = cameraBrands.parallelStream().filter(a -> a.getId() == cameraModel.getBrandId()).findFirst().orElse(null);
            list.add(new CameraItem().setId(cameraModel.getId()).setName((String)(cameraBrand != null ? cameraBrand.getName() + " " : "") + cameraModel.getName() + (String)(cameraModel.getUseCount() > 0 ? " [" + cameraModel.getUseCount() + "]" : "")).setUseCount(cameraModel.getUseCount()));
        }
        list.sort((o1, o2) -> {
            int result = o2.getUseCount() - o1.getUseCount();
            if (result == 0) {
                result = o1.getName().compareTo(o2.getName());
            }
            return result;
        });
        return list.stream().map(a -> new KeyValue(String.valueOf(a.getId()), a.getName())).toList();
    }

    public SearchResult<ForpostTMCAO<ForpostObject>> forpostObjectSearch(String[] sort, Page page) throws Exception {
        SearchResult searchResult = new SearchResult();
        searchResult.setSort(sort);
        searchResult.setPage(page);
        try (ForpostObjectDao forpostObjectDao = new ForpostObjectDao(this.getConnection(), this.moduleId);){
            forpostObjectDao.searchForpostObjects((SearchResult<ForpostTMCAO<ForpostObject>>)searchResult);
        }
        return searchResult;
    }

    public List<ForpostObject> forpostAccountObjectList(int accountId) throws Exception {
        return this.forpostAccountObjectSearch(accountId).getList();
    }

    public SearchResult<ForpostObject> forpostAccountObjectSearch(int accountId) throws Exception {
        SearchResult searchResult = new SearchResult();
        try (ForpostObjectDao forpostObjectDao = new ForpostObjectDao(this.getConnection(), this.moduleId);){
            forpostObjectDao.searchForpostAccountObjects((SearchResult<ForpostObject>)searchResult, accountId);
        }
        return searchResult;
    }

    public void forpostObjectSync() throws Exception {
        if ("test".equals(this.getModuleSetup().get("forpost.mode", ""))) {
            throw new BGMessageException("\u0412\u043a\u043b\u044e\u0447\u0435\u043d \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0440\u0435\u0436\u0438\u043c, \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u043d\u0435 \u043f\u0440\u043e\u0432\u043e\u0434\u0438\u0442\u0441\u044f");
        }
        try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);
             ForpostObjectDao forpostObjectDao = new ForpostObjectDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            for (int accountId : forpostAccountDao.getIds()) {
                forpostObjectDao.doSync(accountId, forpostManager.getObjects(accountId, 0));
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void forpostObjectsSync(int accountId) throws Exception {
        try (ForpostObjectDao forpostObjectDao = new ForpostObjectDao(this.getConnection(), this.moduleId);){
            forpostObjectDao.doSync(accountId, new ForpostManager(this.moduleId).getObjects(accountId, 0));
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public ForpostObject forpostObjectDefaultGet(int contractId, int accountId) throws Exception {
        return this.getForpostDefaultHandler().getForpostObjectDefault((ParameterMap)this.getModuleSetup(), contractId, accountId);
    }

    public int forpostObjectAdd(ForpostObject forpostObject) throws Exception, BGMessageException {
        int n;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Name", forpostObject.getName());
        params.put("AccountID", String.valueOf(forpostObject.getAccountId()));
        if (Utils.notBlankString((String)forpostObject.getAddress())) {
            params.put("Address", forpostObject.getAddress());
        }
        ForpostObjectDao forpostObjectDao = new ForpostObjectDao(this.getConnection(), this.moduleId);
        try {
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            ResponseId responseId = forpostManager.addObject(params);
            if (responseId.getErrorCode() > 0) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
            }
            int objectId = responseId.getId();
            forpostObject.setId(objectId);
            forpostObjectDao.update(forpostObject);
            forpostObjectDao.doSync(forpostObject.getAccountId(), new ForpostManager(this.moduleId).getObjects(forpostObject.getAccountId(), 0));
            n = objectId;
        }
        catch (Throwable throwable) {
            try {
                try {
                    forpostObjectDao.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BGMessageException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        forpostObjectDao.close();
        return n;
    }

    public void forpostObjectUpdate(ForpostObject forpostObject) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ID", String.valueOf(forpostObject.getId()));
        ForpostUtils.putParams(params, (String)"Name", (String)forpostObject.getName());
        ForpostUtils.putParams(params, (String)"Address", (String)forpostObject.getAddress());
        ForpostUtils.putParams(params, (String)"Lat", (String)forpostObject.getString("Lat"));
        ForpostUtils.putParams(params, (String)"Lon", (String)forpostObject.getString("Lon"));
        try (ForpostObjectDao forpostObjectDao = new ForpostObjectDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            try {
                ResponseId responseId = forpostManager.editObject(params);
                if (responseId.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
                }
                forpostObjectDao.update(forpostObject);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void forpostObjectParamUpdate(int forpostObjectId, String name, String value) throws Exception, BGMessageException {
        try (ForpostObjectDao forpostObjectDao = new ForpostObjectDao(this.getConnection(), this.moduleId);){
            ForpostObject forpostObject = forpostObjectDao.getForpostObject(forpostObjectId);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("ID", String.valueOf(forpostObject.getId()));
            params.put(name, value);
            switch (name) {
                case "Name": {
                    forpostObject.setName(value);
                    break;
                }
                case "Address": {
                    forpostObject.setAddress(value);
                    break;
                }
                default: {
                    forpostObject.put(name, (Object)value);
                }
            }
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            try {
                ResponseId responseId = forpostManager.editObject(params);
                if (responseId.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
                }
                forpostObjectDao.update(forpostObject);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void forpostObjectDelete(int id) throws Exception {
        try (ForpostObjectDao forpostObjectDao = new ForpostObjectDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            ResponseStatus responseStatus = forpostManager.deleteObject(id);
            if (responseStatus.getErrorCode() > 0) {
                if (responseStatus.getErrorCode() == 1) {
                    forpostObjectDao.deleteForpostObject(id);
                }
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseStatus.getErrorCode() + " - " + responseStatus.getError());
            }
            forpostObjectDao.deleteForpostObject(id);
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void forpostAccountObjectDelete(int accountId) throws Exception, BGMessageException {
        try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);
             ForpostObjectDao forpostObjectDao = new ForpostObjectDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            SearchResult searchResult = new SearchResult();
            forpostObjectDao.searchForpostAccountObjects((SearchResult<ForpostObject>)searchResult, accountId);
            for (ForpostObject forpostObject : searchResult.getList()) {
                ResponseStatus responseStatus = forpostManager.deleteObject(forpostObject.getId());
                if (responseStatus.getErrorCode() > 0) {
                    if (responseStatus.getErrorCode() == 1) {
                        forpostObjectDao.deleteForpostObject(forpostObject.getId());
                    }
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseStatus.getErrorCode() + " - " + responseStatus.getError());
                }
                forpostObjectDao.deleteForpostObject(forpostObject.getId());
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public SearchResult<ForpostTMCAO<ForpostCamera>> searchForpostCameras(KeyValue filter, String[] sort, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page, sort);
        try (ForpostCameraDao forpostCameraDao = new ForpostCameraDao(this.getConnection(), this.moduleId);){
            forpostCameraDao.searchForpostCameras((SearchResult<ForpostTMCAO<ForpostCamera>>)searchResult, filter);
        }
        return searchResult;
    }

    public SearchResult<ForpostCamera> searchForpostAccountCameras(int accountId) throws Exception {
        SearchResult searchResult = new SearchResult();
        try (ForpostCameraDao forpostCameraDao = new ForpostCameraDao(this.getConnection(), this.moduleId);){
            forpostCameraDao.searchForpostAccountCameras((SearchResult<ForpostCamera>)searchResult, accountId);
        }
        return searchResult;
    }

    public void doSync() throws Exception {
        this.checkTestMode();
        try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);
             ForpostCameraDao forpostCameraDao = new ForpostCameraDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            List<Integer> accountIds = forpostAccountDao.getIds();
            forpostCameraDao.getAccountIds().forEach(a -> {
                if (!accountIds.contains(a)) {
                    accountIds.add((Integer)a);
                }
            });
            for (int accountId : accountIds) {
                forpostCameraDao.doSync(forpostManager.getCameras(accountId, null, null));
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void doSyncForpostCameras(int accountId) throws Exception {
        try (ForpostCameraDao forpostCameraDao = new ForpostCameraDao(this.getConnection(), this.moduleId);){
            forpostCameraDao.doSync(new ForpostManager(this.moduleId).getCameras(accountId, null, null));
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public ForpostCamera getDefaultForpostCamera(int contractId, int accountId) throws Exception {
        return this.getForpostDefaultHandler().getForpostCameraDefault((ParameterMap)this.getModuleSetup(), contractId, accountId);
    }

    public int forpostCameraAdd(int contractId, ForpostCamera forpostCamera) throws Exception, BGMessageException {
        int n;
        ForpostCameraAddEvent event = new ForpostCameraAddEvent(this.moduleId, contractId, forpostCamera);
        forpostCamera = ((ForpostCameraAddEvent)EventProcessor.getInstance().request((QueueEvent)event)).getForpostCamera();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Name", forpostCamera.getName());
        params.put("AccountID", String.valueOf(forpostCamera.getAccountId()));
        params.put("IPOrDomain", forpostCamera.getIpOrDomain());
        params.put("Login", forpostCamera.getLogin());
        params.put("MasterID", String.valueOf(forpostCamera.getMasterId()));
        params.put("Port", String.valueOf(forpostCamera.getPort()));
        params.put("IsActive", String.valueOf(forpostCamera.getIsActive()));
        params.put("MasterID", String.valueOf(forpostCamera.getMasterId()));
        for (Map.Entry entry : ForpostUtils.toMap((String)forpostCamera.getData()).entrySet()) {
            String stringValue;
            Object value = entry.getValue();
            params.put((String)entry.getKey(), value instanceof String ? (stringValue = (String)value) : String.valueOf(value));
        }
        ForpostCameraDao forpostCameraDao = new ForpostCameraDao(this.getConnection(), this.moduleId);
        try {
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            ResponseId responseId = forpostManager.addCamera(params);
            if (responseId.getErrorCode() > 0) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
            }
            int cameraId = responseId.getId();
            forpostCamera.setId(cameraId);
            forpostCameraDao.update(forpostCamera);
            n = cameraId;
        }
        catch (Throwable throwable) {
            try {
                try {
                    forpostCameraDao.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BGMessageException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        forpostCameraDao.close();
        return n;
    }

    public int forpostCameraUpdate(int contractId, ForpostCamera forpostCamera) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ID", String.valueOf(forpostCamera.getId()));
        params.put("Port", String.valueOf(forpostCamera.getPort()));
        params.put("IsActive", String.valueOf(forpostCamera.getIsActive()));
        params.put("MasterID", String.valueOf(forpostCamera.getMasterId()));
        params.put("AccountObjectID", String.valueOf(forpostCamera.getAccountObjectId()));
        Optional.ofNullable(forpostCamera.getName()).ifPresent(a -> params.put("Name", (String)a));
        Optional.ofNullable(forpostCamera.getLogin()).ifPresent(a -> params.put("Login", (String)a));
        Optional.ofNullable(forpostCamera.getIpOrDomain()).ifPresent(a -> params.put("IPOrDomain", (String)a));
        for (Map.Entry entry : ForpostUtils.toMap((String)forpostCamera.getData()).entrySet()) {
            String stringValue;
            Object value = entry.getValue();
            params.put((String)entry.getKey(), value instanceof String ? (stringValue = (String)value) : String.valueOf(value));
        }
        try (ForpostCameraDao forpostCameraDao = new ForpostCameraDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            try {
                ResponseId responseId = forpostManager.editCamera(params);
                if (responseId.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
                }
                forpostCameraDao.update(forpostCamera);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        return forpostCamera.getId();
    }

    public void forpostCameraParamUpdate(int forpostCameraId, String name, String value) throws Exception, BGMessageException {
        try (ForpostCameraDao forpostCameraDao = new ForpostCameraDao(this.getConnection(), this.moduleId);){
            ForpostCamera forpostCamera = forpostCameraDao.getForpostCamera(forpostCameraId);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("ID", String.valueOf(forpostCamera.getId()));
            params.put(name, value);
            switch (name) {
                case "Name": {
                    forpostCamera.setName(value);
                    break;
                }
                case "AccountObjectID": {
                    forpostCamera.setAccountObjectId(Utils.parseInt((String)value));
                    break;
                }
                case "MasterID": {
                    forpostCamera.setMasterId(Utils.parseInt((String)value));
                    break;
                }
                case "Login": {
                    forpostCamera.setLogin(value);
                    break;
                }
                case "IPOrDomain": {
                    forpostCamera.setIpOrDomain(value);
                    break;
                }
                case "IsActive": {
                    forpostCamera.setIsActive(Utils.parseInt((String)value));
                    break;
                }
                case "Port": {
                    forpostCamera.setPort(Utils.parseInt((String)value));
                    break;
                }
                default: {
                    forpostCamera.put(name, (Object)value);
                }
            }
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            try {
                ResponseId responseId = forpostManager.editCamera(params);
                if (responseId.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
                }
                forpostCameraDao.update(forpostCamera);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void forpostCameraDelete(int id) throws Exception, BGMessageException {
        try (ForpostCameraDao forpostCameraDao = new ForpostCameraDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            ResponseStatus responseStatus = forpostManager.deleteCamera(id);
            if (responseStatus.getErrorCode() > 0) {
                if (responseStatus.getErrorCode() == 1) {
                    forpostCameraDao.deleteForpostCamera(id);
                }
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseStatus.getErrorCode() + " - " + responseStatus.getError());
            }
            forpostCameraDao.deleteForpostCamera(id);
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void deleteForpostAccountCameras(int accountId) throws Exception {
        try (ForpostCameraDao forpostCameraDao = new ForpostCameraDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            SearchResult searchResult = new SearchResult();
            forpostCameraDao.searchForpostAccountCameras((SearchResult<ForpostCamera>)searchResult, accountId);
            for (ForpostCamera forpostCamera : searchResult.getList()) {
                ResponseStatus responseStatus = forpostManager.deleteCamera(forpostCamera.getId());
                if (responseStatus.getErrorCode() > 0) {
                    if (responseStatus.getErrorCode() == 1) {
                        forpostCameraDao.deleteForpostCamera(forpostCamera.getId());
                    }
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseStatus.getErrorCode() + " - " + responseStatus.getError());
                }
                forpostCameraDao.deleteForpostCamera(forpostCamera.getId());
            }
        }
    }

    private void checkTestMode() throws BGMessageException {
        if ("test".equals(this.getModuleSetup().get("forpost.mode", ""))) {
            throw new BGMessageException("\u0412\u043a\u043b\u044e\u0447\u0435\u043d \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0440\u0435\u0436\u0438\u043c, \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u043d\u0435 \u043f\u0440\u043e\u0432\u043e\u0434\u0438\u0442\u0441\u044f");
        }
    }

    private ForpostDefaultHandler getForpostDefaultHandler() {
        ForpostDefaultHandler forpostDefaultHandler = new ForpostDefaultHandler();
        String forpostDefaultHandlerClassName = this.getModuleSetup().get("forpost.default.handler.class");
        if (forpostDefaultHandlerClassName != null) {
            try {
                forpostDefaultHandler = (ForpostDefaultHandler)DynamicClassManager.getInstance().loadClass(forpostDefaultHandlerClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return forpostDefaultHandler;
    }

    class CameraItem {
        private int id = 0;
        private int useCount = 0;
        private String name = "";

        CameraItem() {
        }

        public int getId() {
            return this.id;
        }

        public int getUseCount() {
            return this.useCount;
        }

        public String getName() {
            return this.name;
        }

        public CameraItem setId(int id) {
            this.id = id;
            return this;
        }

        public CameraItem setUseCount(int useCount) {
            this.useCount = useCount;
            return this;
        }

        public CameraItem setName(String name) {
            this.name = name;
            return this;
        }
    }
}

