/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.bean;

import bitel.billing.server.contract.bean.ContractUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Reserve;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ReserveJob;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.oss.kernel.job.server.JobScheduler;

public class ReserveDao
extends AbstractIdDao<Reserve> {
    private static final String TABLE_RESERVE_TOTAL = " contract_reserve_total ";
    private static final Logger logger = LogManager.getLogger();
    public static final boolean flagReserve;

    public ReserveDao(Connection con) {
        super(con, -1, " contract_reserve ");
    }

    public boolean isUseReserveType(int reserveTypeId) throws SQLException {
        boolean result = true;
        String query = "SELECT * FROM " + this.tableName + " WHERE typeId=" + reserveTypeId;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            result = false;
            if (rs.next()) {
                result = true;
            }
        }
        return result;
    }

    protected void updateImpl(Reserve reserve) throws SQLException {
        PreparedStatement ps;
        if (reserve.getId() < 1) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " VALUES(0,?,?,?,NOW(),?,?,?)", 1);
            ps.setInt(1, reserve.getContractId());
            ps.setInt(2, reserve.getTypeId());
            ps.setBigDecimal(3, reserve.getSum());
            ps.setTimestamp(4, reserve.getPeriod() != null ? TimeUtils.convertDateToTimestamp((Date)reserve.getPeriod().getDateTo()) : null);
            ps.setTimestamp(5, null);
            ps.setString(6, reserve.getComment());
            ps.executeUpdate();
            this.con.commit();
            if (reserve.getPeriod() != null && reserve.getPeriod().getDateTo() != null) {
                this.addReservJob(reserve.getPeriod().getDateTo(), ServerUtils.lastInsertId(ps));
            }
            reserve.setId(ServerUtils.lastInsertId(ps));
        } else {
            ps = this.con.prepareStatement("UPDATE" + this.tableName + "SET typeId=?, comment=?, sum=? WHERE id=" + reserve.getId());
            ps.setInt(1, reserve.getTypeId());
            ps.setString(2, reserve.getComment());
            ps.setBigDecimal(3, reserve.getSum());
            ps.executeUpdate();
        }
        ps.close();
    }

    public List<Reserve> getReserveList(int cid, Period period, int reserveMembers) throws SQLException {
        List list;
        String cids = ContractUtils.getCidsStringForQuery(cid, reserveMembers, this.con);
        if (cids == null) {
            return new ArrayList<Reserve>();
        }
        StringBuilder query = new StringBuilder();
        query.append("SELECT cr.id,cr.cid,cr.typeId,cr.sum,cr.dateCreate,cr.dateTo,cr.dateClose,cr.comment FROM  " + this.tableName + " cr WHERE cid IN(" + cids + ")");
        if (period != null) {
            query.append(" AND (? IS NULL OR(cr.dateClose IS NOT NULL AND cr.dateClose>=?) OR(cr.dateTo IS NOT NULL AND cr.dateTo>=?) OR(cr.dateClose IS NULL AND cr.dateTo IS NULL) ) AND (? IS NULL OR cr.dateCreate<=?)");
        }
        query.append(" ORDER BY cr.dateCreate");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            if (period != null) {
                ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                ps.setTimestamp(3, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                ps.setTimestamp(4, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
                ps.setTimestamp(5, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
            }
            list = this.getListFromRS(ps.executeQuery());
        }
        return list;
    }

    public boolean closeReserve(int reserveId) throws SQLException {
        boolean result = false;
        String query = "SELECT IF(cr.dateClose IS NULL AND COUNT(*)=1, TRUE, FALSE ) as result FROM " + this.tableName + " cr WHERE id=" + reserveId;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                result = rs.getBoolean("result");
            }
        }
        if (result) {
            query = "UPDATE " + this.tableName + " SET dateClose=NOW() WHERE id=" + reserveId;
            ps = this.con.prepareStatement(query);
            try {
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            this.con.commit();
        }
        return result;
    }

    public BigDecimal getReserveSum(int contractId) throws SQLException {
        BigDecimal sum = new BigDecimal(0);
        String query = "SELECT sum FROM  contract_reserve_total  WHERE cid=" + contractId;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                sum = rs.getBigDecimal("sum");
            }
            rs.close();
        }
        return sum;
    }

    public BigDecimal getReserveSumByDate(int cid, Date date) throws SQLException {
        BigDecimal sum = new BigDecimal(0);
        String cids = ContractUtils.getCidsStringForQuery(cid, 2, this.con);
        if (cids == null) {
            return sum;
        }
        try (PreparedStatement ps = this.con.prepareStatement("SELECT SUM(sum) as sum FROM " + this.tableName + " WHERE cid IN (" + cids + ") AND dateCreate<=? AND (dateClose IS NULL OR dateClose>=?)");){
            ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)date));
            ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)date));
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                sum = rs.getBigDecimal("sum");
            }
        }
        return sum == null ? BigDecimal.ZERO : sum;
    }

    public void recalculationSumReserve(int contractId) throws Exception {
        try (ContractDao dao = new ContractDao(this.con, 0);){
            Contract contract = (Contract)dao.get(contractId);
            BigDecimal sum = BigDecimal.ZERO;
            PreparedStatement ps = this.con.prepareStatement("SELECT SUM(sum) as sum FROM" + this.tableName + "WHERE cid=" + contractId + " AND dateCreate<=NOW() AND (dateClose IS NULL OR dateClose>NOW() )");
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                sum = rs.getBigDecimal("sum") == null ? BigDecimal.ZERO : rs.getBigDecimal("sum");
            }
            rs.close();
            ps.close();
            if (contract.isSuper()) {
                ps = this.con.prepareStatement("SELECT SUM(cr.sum) as subSum FROM" + this.tableName + "cr LEFT JOIN contract c ON c.id=cr.cid WHERE c.scid=" + contractId + " AND c.sub_mode=? AND dateCreate<=NOW() AND (dateClose IS NULL OR dateClose>NOW())");
                ps.setInt(1, 0);
                rs = ps.executeQuery();
                if (rs.next()) {
                    sum = sum.add(rs.getBigDecimal("subSum") == null ? BigDecimal.ZERO : rs.getBigDecimal("subSum"));
                }
                ps.close();
                rs.close();
            }
            ps = this.con.prepareStatement("INSERT INTO  contract_reserve_total  SET cid=" + contractId + ", sum=? ON DUPLICATE KEY UPDATE sum=?");
            ps.setBigDecimal(1, sum);
            ps.setBigDecimal(2, sum);
            ps.executeUpdate();
            ps.close();
            if (contract.isDependSub()) {
                this.recalculationSumReserve(contract.getSuperCid());
            }
        }
    }

    @Deprecated
    public BigDecimal getBalanceWithReserve(Contract contract, BigDecimal balance, Calendar calendar) throws SQLException {
        return this.getBalanceWithReserve(contract, balance, TimeUtils.convertDateToLocalDate((Date)calendar.getTime()));
    }

    public BigDecimal getBalanceWithReserve(Contract contract, BigDecimal balance, LocalDate localDate) throws SQLException {
        LocalDate now;
        if (flagReserve && (now = LocalDate.now()).getYear() == localDate.getYear() && now.getMonthValue() == localDate.getMonthValue()) {
            if (contract.isDependSub()) {
                return balance.subtract(this.getReserveSum(contract.getSuperCid()));
            }
            return balance.subtract(this.getReserveSum(contract.getId()));
        }
        return balance;
    }

    protected Reserve getFromRS(ResultSet rs) throws SQLException {
        return Reserve.builder().setId(rs.getInt("id")).setContractId(rs.getInt("cid")).setTypeId(rs.getInt("typeId")).setPeriod(new PeriodWithTime((Date)rs.getTimestamp("dateCreate"), (Date)rs.getTimestamp("dateTo"))).setDateClose(rs.getTimestamp("dateClose")).setSum(rs.getBigDecimal("sum")).setComment(rs.getString("comment")).build();
    }

    private void addReservJob(Date date, int reserveId) {
        JobScheduler jobExecutor = JobScheduler.getInstance("reserve", 0);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("reserveId", Integer.toString(reserveId));
        try {
            jobExecutor.schedule(ReserveJob.class, (ParameterMap)new ParameterMap.DefaultParameterMap(map), date);
        }
        catch (Exception ex) {
            throw new BGRuntimeException((Throwable)ex);
        }
    }

    static {
        boolean _flagReserve = false;
        try {
            _flagReserve = Setup.getSetup().getBoolean("contract.balance.reserve.influenceToBalance", false);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        flagReserve = _flagReserve;
    }
}

