/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.provider.sbis;

import bitel.billing.common.VersionInfo;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;

public class SbisAPI
extends BGLogger {
    private int userId = 0;
    private BGPluginServer plugin = null;
    private static Map<Integer, String> tokenMap = new HashMap<Integer, String>();

    public SbisAPI(int userId) {
        this.userId = userId;
        this.plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.edo");
    }

    public List<String> doChangeList() throws BGException, SbisJsonRpcException {
        JSONObject filter = new JSONObject();
        filter.put("\u041f\u043e\u043b\u043d\u044b\u0439\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u042d\u041f", (Object)"\u041d\u0435\u0442");
        JSONObject params = new JSONObject();
        params.put("\u0424\u0438\u043b\u044c\u0442\u0440", (Object)filter);
        this.doRequest("\u0421\u0411\u0418\u0421.\u0421\u043f\u0438\u0441\u043e\u043a\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439", params, this.getToken());
        ArrayList<String> list = new ArrayList<String>();
        return list;
    }

    private String getToken() throws BGException, SbisJsonRpcException {
        String token = tokenMap.get(this.userId);
        if (token == null) {
            String login = this.plugin.getSetup().get("sbis.service.login");
            String password = this.plugin.getSetup().get("sbis.service.password");
            JSONObject loginPassword = new JSONObject();
            loginPassword.put("\u041b\u043e\u0433\u0438\u043d", (Object)login);
            loginPassword.put("\u041f\u0430\u0440\u043e\u043b\u044c", (Object)password);
            JSONObject params = new JSONObject();
            params.put("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", (Object)loginPassword);
            Object result = this.doAuthRequest("\u0421\u0411\u0418\u0421.\u0410\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u0442\u044c", params, null);
            token = (String)result;
            tokenMap.put(this.userId, token);
        }
        return token;
    }

    private String httpRequest(String url, String httpMethod, String data, String sessionId) throws BGException {
        String result = null;
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(url));
        if ("GET".equals(httpMethod)) {
            builder = builder.GET();
        } else if ("POST".equals(httpMethod)) {
            builder = builder.POST(HttpRequest.BodyPublishers.ofString(data));
        }
        builder.setHeader("Content-Type", "application/json-rpc;charset=utf-8");
        builder.setHeader("User-Agent", "BGBilling " + VersionInfo.getVersionInfo((String)"kernel"));
        if (sessionId != null) {
            builder.setHeader("X-SBISSessionID", sessionId);
        }
        HttpRequest request = builder.build();
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("request = " + request);
            }
            result = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
            this.getLogger().debug("result = {}", (Object)result);
        }
        catch (IOException ex) {
            throw new BGException("io error", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            throw new BGException("interrupt error", (Throwable)ex);
        }
        return result;
    }

    private Object jsonRequest(String url, String jsonMethod, JSONObject jsonParams, String sessionId) throws BGException, SbisJsonRpcException {
        JSONObject json = new JSONObject().put("jsonrpc", (Object)"2.0").put("method", (Object)jsonMethod).put("params", (Object)jsonParams).put("id", System.currentTimeMillis());
        JSONObject result = new JSONObject(this.httpRequest(url, "POST", json.toString(), sessionId));
        if (result.has("result")) {
            return result.get("result");
        }
        if (result.has("error")) {
            JSONObject error = result.getJSONObject("error");
            throw new SbisJsonRpcException(error.getInt("code"), error.getString("message"), error.getString("details"), error.getJSONObject("data"));
        }
        throw new BGException("error jsonrpc reply");
    }

    private Object doAuthRequest(String jsonMethod, JSONObject jsonParams, String sessionId) throws BGException, SbisJsonRpcException {
        String url = this.plugin.getSetup().get("sbis.auth.url", "https://online.sbis.ru/auth/service/");
        return this.jsonRequest(url, jsonMethod, jsonParams, sessionId);
    }

    private Object doRequest(String jsonMethod, JSONObject jsonParams, String sessionId) throws BGException, SbisJsonRpcException {
        String url = this.plugin.getSetup().get("sbis.service.url", "https://online.sbis.ru/service/?srv=1");
        return this.jsonRequest(url, jsonMethod, jsonParams, sessionId);
    }

    public static class SbisJsonRpcException
    extends BGException {
        int code;
        String message;
        String details;
        JSONObject data;

        public SbisJsonRpcException(int code, String message, String details, JSONObject data) {
            super("JsonRpc error " + code + ": " + message);
            this.code = code;
            this.message = message;
            this.details = details;
            this.data = data;
        }
    }
}

