/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.about.client;

import bitel.billing.module.common.BGDialog;
import bitel.billing.module.common.DBInfoManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.license.common.service.LicenseService;
import ru.bitel.common.Utils;

public class AboutDialog
extends BGDialog
implements ActionListener {
    private static final String bg = "/img/about.gif";
    private Graphics2D gTop;
    private JPanel panel;
    private int imgheight;
    private int imgwidth;
    private JSONObject doc = null;
    private static final int MODULE_REPORT_SCROLL_HEIGHT = 200;
    private JTextArea modulesReport = new JTextArea(){

        @Override
        public void paint(Graphics g) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            super.paint(g);
        }
    };
    private JScrollPane moduleReportScroll = new JScrollPane(this.modulesReport);

    public AboutDialog(boolean modal) {
        try {
            this.jbInit();
            this.about();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.setModal(modal);
        this.repaint();
        this.pack();
        this.moveWindowToCenterScreen();
        this.setVisible(true);
    }

    private void jbInit() throws Exception {
        BufferedImage image;
        this.setResizable(false);
        this.getContentPane().setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        this.setTitle("\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435");
        this.getContentPane().setLayout(new GridBagLayout());
        this.panel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)this.panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        this.panel.setBackground(Color.WHITE);
        this.panel.add((Component)bottomPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel copyLabel = new JLabel("\u00a9 2002\u2014" + new GregorianCalendar().get(1) + " \u041e\u041e\u041e \"\u0411\u0438\u0442\u0435\u043b\". https://bgbilling.ru"){

            @Override
            public void paint(Graphics g) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                super.paint(g);
            }
        };
        copyLabel.setFont(new Font("Dialog", 1, 11));
        bottomPanel.setOpaque(false);
        bottomPanel.add((Component)this.moduleReportScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        bottomPanel.add((Component)copyLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        bottomPanel.setBackground(Color.WHITE);
        this.modulesReport.setOpaque(false);
        this.moduleReportScroll.setOpaque(false);
        this.moduleReportScroll.getViewport().setOpaque(false);
        this.modulesReport.setEditable(false);
        this.modulesReport.setFont(new Font("Dialog", 0, 9));
        this.moduleReportScroll.setMinimumSize(new Dimension(0, 200));
        this.moduleReportScroll.setPreferredSize(new Dimension(0, 200));
        this.modulesReport.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 5));
        URL url = AboutDialog.class.getResource(bg);
        if (url != null) {
            image = ImageIO.read(url);
        } else {
            image = new BufferedImage(400, 205, 5);
            image.getGraphics().setColor(Color.WHITE);
            image.getGraphics().fillRect(0, 0, 400, 205);
        }
        this.panel.setBorder(new BackgroundBorder(image));
        this.imgheight = image.getHeight();
        this.imgwidth = image.getWidth();
        this.gTop = (Graphics2D)image.getGraphics();
        this.gTop.setBackground(new Color(255, 255, 255));
        this.gTop.setColor(new Color(0, 0, 0));
        this.gTop.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.modulesReport.addMouseListener(new MouseAdapter(){

            public void mouse(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem item = new JMenuItem("\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0441\u0451");
                    item.addActionListener(AboutDialog.this);
                    item.setActionCommand("copyinfo");
                    menu.add(item);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.mouse(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mouse(e);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("copyinfo".equals(e.getActionCommand())) {
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(AboutDialog.makeVersionText(this.doc, true));
            clpbrd.setContents(stringSelection, null);
        }
    }

    private static String aptel(String prefix, String lines) {
        StringBuilder sb = new StringBuilder(50);
        for (String line : Utils.toList(lines, "\n")) {
            sb.append(prefix + line + "\n");
        }
        return sb.toString();
    }

    private static String getClientTime(String tzid) {
        if (Utils.notEmptyString(tzid)) {
            SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm z Z");
            df.setTimeZone(TimeZone.getTimeZone(tzid));
            return df.format(new Date()) + " (" + tzid + ")";
        }
        return "?";
    }

    private void about() {
        this.gTop.setFont(new Font("Dialog", 2, 13));
        this.gTop.drawString("\"BGBilling\" \u2014 \u0443\u043d\u0438\u0432\u0435\u0440\u0441\u0430\u043b\u044c\u043d\u0430\u044f", 10, 115);
        this.gTop.drawString(" \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u043e\u0432\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430", 10, 130);
        if (DBInfoManager.getManager().getActiveDBInfo() != null) {
            try {
                this.doc = new JSONObject(this.getContext().getPort(LicenseService.class).aboutGet());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
        if (this.doc != null) {
            this.moduleReportScroll.setVisible(true);
            this.modulesReport.setText(AboutDialog.makeVersionText(this.doc, false));
            this.modulesReport.setCaretPosition(0);
        } else {
            this.moduleReportScroll.setVisible(false);
            this.gTop.setFont(new Font("Dialog", 1, 11));
            this.gTop.setFont(new Font("Dialog", 2, 9));
            this.gTop.drawString(Utils.getOsJavaVersion(false), 20, 160);
        }
        this.panel.setPreferredSize(new Dimension(this.imgwidth, this.imgheight + (this.moduleReportScroll.isVisible() ? 155 : 0)));
        this.pack();
    }

    private static String makeVersionText(JSONObject doc, boolean isForCopy) {
        StringBuilder sb = new StringBuilder(50);
        sb.append("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0432\u0435\u0440\u0441\u0438\u0438:\n\n");
        JSONObject client = doc.optJSONObject("client");
        JSONObject server = doc.optJSONObject("server");
        if (server != null) {
            if (client != null) {
                String clientServerVersionstring = client.optString("versionstring");
                sb.append("  \u041a\u043b\u0438\u0435\u043d\u0442: " + clientServerVersionstring + "\n");
            }
            sb.append("    " + Utils.getOsJavaVersion(false) + "\n");
            try {
                Utils.checkJava();
            }
            catch (BGException e) {
                sb.append(AboutDialog.aptel("    \u0412\u041d\u0418\u041c\u0410\u041d\u0418\u0415: ", e.getMessage()));
            }
            sb.append("  \u0421\u0435\u0440\u0432\u0435\u0440: " + server.optString("versionstring") + "\n");
            sb.append("    " + server.optString("server") + "\n\n");
        }
        JSONArray modules = doc.optJSONArray("modules");
        for (int index = 0; index < modules.length(); ++index) {
            JSONObject module = modules.getJSONObject(index);
            String serName = module.optString("name");
            String versionstring = module.optString("versionstring");
            sb.append(String.format("  %s: %s\n", serName, versionstring));
        }
        sb.append("\n\u041e\u043a\u0440\u0443\u0436\u0435\u043d\u0438\u0435:\n\n");
        sb.append("  \u041a\u043b\u0438\u0435\u043d\u0442:\n");
        sb.append(AboutDialog.aptel("    ", Utils.getOsJavaVersion(true)));
        sb.append("    memory (use/total/max): " + Utils.memoryStatusShort() + "\n");
        sb.append("    default tz: " + AboutDialog.getClientTime(TimeZone.getDefault().getID()) + "\n");
        sb.append("    user tz: " + AboutDialog.getClientTime(System.getProperty("user.timezone")) + "\n");
        sb.append("    locale: " + Locale.getDefault().toString() + "\n");
        sb.append("    charset jvm: " + Charset.defaultCharset().toString() + "\n");
        sb.append("  \u0421\u0435\u0440\u0432\u0435\u0440:\n");
        sb.append(AboutDialog.aptel("    ", server.optString("serverfull")));
        sb.append("    default tz: " + server.optString("servertime") + "\n");
        sb.append("    memory (use/total/max): " + server.optString("memory") + "\n");
        sb.append("    db time: " + server.optString("serverdbtime") + "\n");
        sb.append("    db charset: " + server.optString("serverdbcharset") + "\n");
        sb.append("    locale: " + server.optString("serverlocale") + "\n");
        sb.append("    charset jvm: " + server.optString("servercharset") + "\n");
        sb.append("    uptime: " + server.optString("uptimestatus") + "\n");
        if (server.has("uptimestatus_warning")) {
            sb.append("    \u0412\u041d\u0418\u041c\u0410\u041d\u0418\u0415: " + server.optString("uptimestatus_warning") + "\n");
        }
        if (!isForCopy) {
            sb.append("\n\u0422\u0440\u0435\u0442\u044c\u0438 \u0441\u0442\u043e\u0440\u043e\u043d\u044b:\n\n");
            sb.append("  Fugue Icons. Copyright \u00a9 2011 Yusuke Kamiyamane. All rights reserved.\n");
            sb.append("    http://p.yusukekamiyamane.com/\n");
            sb.append("  Silk icon set. Copyright \u00a9 Mark James. All rights reserved.\n");
            sb.append("    http://www.famfamfam.com/lab/icons/silk/");
        }
        return sb.toString();
    }

    public class BackgroundBorder
    implements Border {
        private final BufferedImage image;

        public BackgroundBorder(BufferedImage image) {
            this.image = image;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.drawImage(this.image, 0, 0, null);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

