/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.client.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.client.table.EntityAttrEntry;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;

public class EntityAttrTextCellEditor
extends DefaultCellEditor
implements TableCellEditor {
    private EntityAttrEntry value = null;

    public EntityAttrTextCellEditor() {
        super(EntityAttrTextCellEditor.newTextField());
    }

    private static JTextField newTextField() {
        JTextField textField = new JTextField();
        textField.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        return textField;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = (EntityAttrEntry)value;
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public boolean stopCellEditing() {
        if (this.value == null) {
            return true;
        }
        String value = (String)this.getCellEditorValue();
        if (Utils.isBlankString(value)) {
            this.value.setAttr(null);
        } else if (this.value.getAttr() == null) {
            this.value.setAttr((EntityAttr)new EntityAttrText(this.value.getEntity().getEntityId(), this.value.getSpecAttr().getId(), value));
        } else {
            ((EntityAttrText)this.value.getAttr()).setValue(value);
        }
        return super.stopCellEditing();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return true;
    }
}

