/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.action;

import bitel.billing.server.admin.action.base.ActionBase;
import bitel.billing.server.contract.logon.ContractLogonBase;
import bitel.billing.server.contract.logon.ContractLogonError;
import bitel.billing.server.contract.logon.ContractLogonOk;
import bitel.billing.server.contract.logon.LogonManager;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.SearchResult;

public class ActionWebLogonLog
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        String logType = this.getParameter("logType", "ok");
        String contracts = this.getParameter("contracts", null);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        LogonManager logonManager = new LogonManager(this.con);
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(this.getPage());
        searchResult.setPeriod(this.getPeriod());
        if ("ok".equals(logType)) {
            Element row = null;
            logonManager.searchLogonOk(contracts, (SearchResult<ContractLogonBase>)searchResult);
            for (Object item : searchResult.getList()) {
                ContractLogonOk contractLogonOk = (ContractLogonOk)item;
                row = this.createElement(data, "row");
                row.setAttribute("ip", contractLogonOk.getRemoteIP());
                row.setAttribute("date", TimeUtils.format((Date)contractLogonOk.getDateTime(), (String)"dd.MM.yyyy HH:mm:ss"));
                row.setAttribute("sessionId", contractLogonOk.getSessionId());
                row.setAttribute("contract", contractLogonOk.getContractTitle());
                row.setAttribute("passwordType", contractLogonOk.getPasswordType());
            }
        } else {
            Element row = null;
            logonManager.searchLogonError(contracts, (SearchResult<ContractLogonBase>)searchResult);
            for (Object item : searchResult.getList()) {
                ContractLogonError contractLogonError = (ContractLogonError)item;
                StringBuilder builder = new StringBuilder();
                builder.append("[");
                builder.append(contractLogonError.getErrorCode());
                builder.append("] ");
                builder.append(contractLogonError.getRequestData());
                row = this.createElement(data, "row");
                row.setAttribute("ip", contractLogonError.getRemoteIP());
                row.setAttribute("date", TimeUtils.format((Date)contractLogonError.getDateTime(), (String)"dd.MM.yyyy HH:mm:ss"));
                row.setAttribute("login", contractLogonError.getLogin());
                row.setAttribute("errorCode", builder.toString());
                row.setAttribute("contract", contractLogonError.getContractTitle());
            }
        }
        this.setPageAttribute(table, searchResult.getPage());
    }
}

