/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.tv.accounting.worker;

import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.jmx.AnnotatedMBean;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.jmx.MBeanUtils;
import ru.bitel.common.util.FrequencyCounter;
import ru.bitel.common.worker.WorkerTask;

public abstract class AccountingWorkerTask
extends WorkerTask<ServerContext>
implements Lifecycle {
    private final ScheduledExecutorService scheduledExecutorService;
    private volatile ScheduledFuture<?> future;
    private static final Random RANDOM = new Random();
    private volatile long delay;
    protected volatile int batchSize;
    protected String name;
    private volatile ObjectName objectName;
    protected final FrequencyCounter processTimePerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    protected final FrequencyCounter processTimePerTenMinutes = new FrequencyCounter(600L, TimeUnit.SECONDS);
    protected final FrequencyCounter invokePerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    protected final FrequencyCounter invokePerTenMinutes = new FrequencyCounter(600L, TimeUnit.SECONDS);

    public AccountingWorkerTask(int batchSize) {
        this.scheduledExecutorService = null;
        this.name = null;
        this.delay = 0L;
        this.batchSize = batchSize;
        if (this.batchSize <= 0) {
            this.batchSize = Integer.MAX_VALUE;
        }
    }

    public AccountingWorkerTask(ScheduledExecutorService scheduledExecutorService, String name, ParameterMap params) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.name = name;
        long delay = params.getLong("delay.millis", params.getLong("delay", 10L) * 1000L);
        if (delay <= 50L) {
            delay = 50L;
        }
        this.delay = delay;
        this.batchSize = params.getInt("batchSize", 0);
        if (this.batchSize <= 0) {
            this.batchSize = Integer.MAX_VALUE;
        }
    }

    @MBeanAttribute
    public long getDelay() {
        return this.delay;
    }

    public synchronized void setDelay(long delay) {
        if (delay <= 50L) {
            delay = 50L;
        }
        this.delay = delay;
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.future = this.scheduledExecutorService.scheduleWithFixedDelay((Runnable)((Object)this), delay / 2L + (long)(RANDOM.nextInt((int)delay / 2) + 1), delay, TimeUnit.MILLISECONDS);
    }

    @MBeanAttribute
    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        if (batchSize <= 0) {
            batchSize = Integer.MAX_VALUE;
        }
        this.batchSize = batchSize;
    }

    public synchronized void start() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.future = this.scheduledExecutorService.scheduleWithFixedDelay((Runnable)((Object)this), this.delay / 2L + (long)(RANDOM.nextInt((int)this.delay / 2) + 1), this.delay, TimeUnit.MILLISECONDS);
    }

    public synchronized void stop() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
    }

    public void init() {
        this.objectName = AnnotatedMBean.register((Object)((Object)this), (String)this.name);
    }

    public void destroy() {
        MBeanUtils.unregisterMBean((ObjectName)this.objectName);
    }

    @MBeanAttribute(description="process time per minute in millis")
    public long getProcessTimePerMinute() {
        return this.processTimePerMinute.get(System.currentTimeMillis());
    }

    @MBeanAttribute(description="process time per 10 minutes in millis")
    public long getProcessTimePerTenMinutes() {
        return this.processTimePerTenMinutes.get(System.currentTimeMillis());
    }

    @MBeanAttribute
    public long getInvokePerMinute() {
        return this.invokePerMinute.get(System.currentTimeMillis());
    }

    @MBeanAttribute
    public long getInvokePerTenMinutes() {
        return this.invokePerTenMinutes.get(System.currentTimeMillis());
    }
}

