/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceRuntime;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.SystemLimitChangedEvent;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.WorkerThreadFactory;

public class ConvergenceBalanceManager
implements EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    protected static boolean generateConvergenceBalanceEvents = false;
    protected static boolean invalidateOnContractModified = true;
    final DefaultServerSetup setup;
    private final ConcurrentMap<Integer, ConvergenceBalanceRuntime> balanceMap;
    private final ConcurrentMap<Integer, Integer> dependSubMap;
    private final boolean subLimitFix;
    private final ScheduledThreadPoolExecutor balanceService;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();

    public static ConvergenceBalanceManager getInstance() {
        return InstanceHolder.manager;
    }

    public static void setGenerateConvergenceBalanceEvents(boolean generate) {
        generateConvergenceBalanceEvents = generate;
    }

    protected ConvergenceBalanceManager(DefaultServerSetup setup) throws BGException {
        this.setup = setup;
        this.balanceMap = new ConcurrentHashMap<Integer, ConvergenceBalanceRuntime>();
        this.dependSubMap = new ConcurrentHashMap<Integer, Integer>();
        long cleanDelay = setup.getLong("balance.convergence.cleanDelay", 900L);
        long updateDelay = setup.getLong("balance.convergence.updateDelay", 1800L);
        this.subLimitFix = setup.getInt("balance.convergence.subLimitMode", 1) > 0;
        EventProcessor ep = EventProcessor.getInstance();
        ep.addListener(this, ContractBalanceChangedEvent.class);
        ep.addListener(this, SystemLimitChangedEvent.class);
        ep.addListener(this, ContractModifiedEvent.class);
        this.balanceService = new ScheduledThreadPoolExecutor(1, new WorkerThreadFactory("convergenceBalance", null, null));
        this.balanceService.scheduleWithFixedDelay(new Cleaner(this.balanceMap.values(), cleanDelay), 60L, 48L, TimeUnit.SECONDS);
        this.balanceService.scheduleWithFixedDelay(new Updater(this.balanceMap.values(), updateDelay), 84L, 48L, TimeUnit.SECONDS);
    }

    public ConvergenceBalance getBalance(ConnectionSet connectionSet, Integer contractId, long now_) throws BGException {
        ConvergenceBalanceRuntime balance = this.getOrCreateBalance(connectionSet, contractId, now_);
        if (balance.superContractId > 0) {
            ConvergenceBalanceRuntime superBalance = this.getOrCreateBalance(connectionSet, balance.superContractId, now_);
            return this.subLimitFix ? superBalance.subBalance(balance) : superBalance;
        }
        return balance;
    }

    private ConvergenceBalanceRuntime getOrCreateBalance(ConnectionSet connectionSet, Integer contractId, long now_) throws BGException {
        ConvergenceBalanceRuntime balance = this.getBalanceIfExists(contractId, now_);
        if (balance != null) {
            return balance;
        }
        return this.newBalance(connectionSet, contractId, now_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConvergenceBalanceRuntime getBalanceIfExists(Integer contractId, long now_) throws BGException {
        ConvergenceBalanceRuntime balance;
        this.readLock.lock();
        try {
            balance = (ConvergenceBalanceRuntime)this.balanceMap.get(contractId);
        }
        finally {
            this.readLock.unlock();
        }
        if (balance == null) {
            return null;
        }
        if (balance.monthStartTime > now_ || balance.monthEndTime < now_) {
            GregorianCalendar now = new GregorianCalendar();
            ConvergenceBalanceRuntime newBalance = balance.toNewer(now);
            this.balanceMap.remove(contractId, balance);
            balance = this.balanceMap.putIfAbsent(contractId, newBalance);
            if (balance == null) {
                balance = newBalance;
            }
        }
        return balance;
    }

    public void updateBalance(ConnectionSet connectionSet, int contractId, long now_) throws BGException {
        this.balanceMap.remove(contractId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConvergenceBalanceRuntime newBalance(ConnectionSet connectionSet, Integer contractId, long now_) throws BGException {
        Connection con = connectionSet.getConnection();
        try (BalanceDao balanceDao = new BalanceDao(con);){
            Contract contract = new ContractManager(con).getContractById(contractId.intValue());
            if (contract == null) {
                logger.error("Contract not found with id: " + contractId + "! Return -100000 balance cache.");
                ContractBalance nullBalance = new ContractBalance();
                nullBalance.setIncomingSaldo(new BigDecimal("-100000"));
                nullBalance.setAccounts(BigDecimal.ZERO);
                nullBalance.setPayments(BigDecimal.ZERO);
                nullBalance.setCharges(BigDecimal.ZERO);
                nullBalance.setReserve(BigDecimal.ZERO);
                GregorianCalendar now = new GregorianCalendar();
                ConvergenceBalanceRuntime convergenceBalanceRuntime = new ConvergenceBalanceRuntime(contractId, -1, BigDecimal.ZERO, nullBalance, now);
                return convergenceBalanceRuntime;
            }
            if (!generateConvergenceBalanceEvents) {
                if (contract.isSuper()) {
                    List<Integer> cids = Utils.toIntegerList(contract.getDependSubList());
                    int size = cids.size();
                    for (int i = 0; i < size; ++i) {
                        this.dependSubMap.put(cids.get(i), contractId);
                    }
                } else if (contract.isDependSub()) {
                    this.dependSubMap.put(contractId, contract.getSuperId());
                }
            }
            GregorianCalendar now = new GregorianCalendar();
            int year = now.get(1);
            int month = now.get(2) + 1;
            ContractBalance contractBalance = balanceDao.getContractBalance(contractId, year, month);
            now.setTimeInMillis(System.currentTimeMillis());
            ConvergenceBalanceRuntime newBalance = contractBalance == null ? new ConvergenceBalanceRuntime(contract, BigDecimal.ZERO, (Calendar)now) : (year != contractBalance.getYear() || month != contractBalance.getMonth() ? new ConvergenceBalanceRuntime(contract, contractBalance.toBalance(), (Calendar)now) : new ConvergenceBalanceRuntime(contract, contractBalance, (Calendar)now));
            this.readLock.lock();
            try {
                ConvergenceBalanceRuntime balance = this.balanceMap.putIfAbsent(contractId, newBalance);
                if (balance == null) {
                    balance = newBalance;
                }
                ConvergenceBalanceRuntime convergenceBalanceRuntime = balance;
                this.readLock.unlock();
                return convergenceBalanceRuntime;
            }
            catch (Throwable throwable) {
                this.readLock.unlock();
                throw throwable;
            }
        }
    }

    private void tryGenerateConvergenceBalanceEvent(ConvergenceBalanceRuntime balance) throws BGException {
        if (balance.superContractId > 0) {
            ConvergenceBalanceRuntime superBalance = (ConvergenceBalanceRuntime)this.balanceMap.get(balance.superContractId);
            if (superBalance != null) {
                superBalance.tryGenerateConvergenceBalanceEvent();
            }
        } else {
            balance.tryGenerateConvergenceBalanceEvent();
        }
    }

    private void generateConvergenceBalanceEvent(ConvergenceBalanceRuntime balance) throws BGException {
        if (balance.superContractId > 0) {
            ConvergenceBalanceRuntime superBalance = (ConvergenceBalanceRuntime)this.balanceMap.get(balance.superContractId);
            if (superBalance != null) {
                superBalance.generateConvergenceBalanceEvent();
            }
        } else {
            balance.generateConvergenceBalanceEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void notify(Event e, EventListenerContext ctx) throws BGException {
        ConvergenceBalanceRuntime balance = (ConvergenceBalanceRuntime)this.balanceMap.get(e.getContractId());
        if (balance == null) {
            Integer superId;
            if (generateConvergenceBalanceEvents) {
                balance = this.getOrCreateBalance(ctx.getConnectionSet(), e.getContractId(), e.getTimestamp());
                if (e instanceof ContractBalanceChangedEvent && balance.superContractId > 0) {
                    this.processContractBalanceChangedEventForSuper(ctx, balance.superContractId, (ContractBalanceChangedEvent)e);
                }
                this.tryGenerateConvergenceBalanceEvent(balance);
                return;
            }
            if (!(e instanceof ContractBalanceChangedEvent) || (superId = (Integer)this.dependSubMap.get(e.getContractId())) == null) return;
            this.processContractBalanceChangedEventForSuper(ctx, superId, (ContractBalanceChangedEvent)e);
            return;
        }
        long now = e.getTimestamp();
        if (balance.created >= now) {
            if (generateConvergenceBalanceEvents) {
                this.tryGenerateConvergenceBalanceEvent(balance);
            }
            if (!(e instanceof ContractBalanceChangedEvent)) return;
            ContractBalanceChangedEvent ev = (ContractBalanceChangedEvent)e;
            switch (ev.getType()) {
                case 3: 
                case 4: {
                    ConvergenceBalanceRuntime superBalance;
                    if (balance.superContractId > 0 && (superBalance = this.getBalanceIfExists(balance.superContractId, now)) != null) {
                        this.checkForCollision(superBalance, now);
                    }
                    this.checkForCollision(balance, now);
                    return;
                }
            }
            return;
        }
        if (e instanceof ContractBalanceChangedEvent) {
            ContractBalanceChangedEvent ev = (ContractBalanceChangedEvent)e;
            this.processContractBalanceChangedEvent(ctx, balance, now, ev);
            return;
        } else if (e instanceof SystemLimitChangedEvent) {
            balance.setLimit(((SystemLimitChangedEvent)e).getNewLimit());
            if (!generateConvergenceBalanceEvents) return;
            this.tryGenerateConvergenceBalanceEvent(balance);
            return;
        } else if (e instanceof ContractModifiedEvent) {
            if (!invalidateOnContractModified) return;
            this.writeLock(this.writeLock);
            try {
                this.balanceMap.remove(balance.contractId, balance);
                if (!generateConvergenceBalanceEvents) return;
                balance = this.newBalance(ctx.getConnectionSet(), e.getContractId(), e.getTimestamp());
                this.tryGenerateConvergenceBalanceEvent(balance);
                return;
            }
            finally {
                this.writeLock.unlock();
            }
        } else {
            if (!generateConvergenceBalanceEvents) return;
            this.tryGenerateConvergenceBalanceEvent(balance);
        }
    }

    private void writeLock(ReentrantReadWriteLock.WriteLock writeLock) throws BGException {
        if (this.lock.getReadHoldCount() > 0) {
            logger.error("lock.getReadHoldCount() > 0");
            if (this.lock.getWriteHoldCount() == 0) {
                logger.error("lock.getWriteHoldCount() == 0");
                throw new BGException("lock.getReadHoldCount() > 0");
            }
        }
        writeLock.lock();
    }

    private void processContractBalanceChangedEvent(EventListenerContext ctx, ConvergenceBalanceRuntime balance, long now, ContractBalanceChangedEvent ev) throws BGException {
        switch (ev.getType()) {
            case 1: {
                ConvergenceBalanceRuntime superBalance;
                BigDecimal summa = ev.getSumma();
                balance.addAccount(summa, now);
                if (balance.superContractId <= 0 || (superBalance = this.getBalanceIfExists(balance.superContractId, now)) == null || superBalance.created >= now) break;
                superBalance.addAccount(summa, now);
                break;
            }
            case 2: {
                if (balance.year == ev.getYear() && balance.month == ev.getMonth()) {
                    balance.setAccount(ev.getSumma(), ev.getTimestamp());
                    if (balance.superContractId > 0) {
                        this.balanceMap.remove(balance.superContractId);
                    }
                    if (generateConvergenceBalanceEvents) {
                        this.generateConvergenceBalanceEvent(balance);
                    }
                } else {
                    this.balanceMap.remove(balance.contractId, balance);
                    if (balance.superContractId > 0) {
                        this.balanceMap.remove(balance.superContractId);
                    }
                    if (generateConvergenceBalanceEvents) {
                        balance = this.newBalance(ctx.getConnectionSet(), ev.getContractId(), ev.getTimestamp());
                        this.generateConvergenceBalanceEvent(balance);
                    }
                }
                return;
            }
            case 3: {
                ConvergenceBalanceRuntime superBalance;
                BigDecimal summa = ev.getSumma();
                balance.addPayment(summa, now);
                if (balance.superContractId > 0 && (superBalance = this.getBalanceIfExists(balance.superContractId, now)) != null) {
                    if (superBalance.created < now) {
                        superBalance.addPayment(summa, now);
                    }
                    this.checkForCollision(superBalance, now);
                }
                this.checkForCollision(balance, now);
                break;
            }
            case 4: {
                ConvergenceBalanceRuntime superBalance;
                BigDecimal summa = ev.getSumma();
                balance.addCharge(summa, now);
                this.balanceMap.remove(balance.contractId, balance);
                if (balance.superContractId > 0 && (superBalance = this.getBalanceIfExists(balance.superContractId, now)) != null) {
                    if (superBalance.created < now) {
                        superBalance.addCharge(summa, now);
                    }
                    this.checkForCollision(superBalance, now);
                }
                this.checkForCollision(balance, now);
                break;
            }
            case 5: {
                ConvergenceBalanceRuntime superBalance;
                BigDecimal summa = ev.getSumma();
                balance.addReserve(summa, now);
                if (balance.superContractId <= 0 || (superBalance = this.getBalanceIfExists(balance.superContractId, now)) == null || superBalance.created >= now) break;
                superBalance.addReserve(summa, now);
                break;
            }
            case 6: {
                ConvergenceBalanceRuntime superBalance;
                BigDecimal summa = ev.getSumma();
                balance.subtractReserve(summa, now);
                if (balance.superContractId <= 0 || (superBalance = this.getBalanceIfExists(balance.superContractId, now)) == null || superBalance.created >= now) break;
                superBalance.subtractReserve(summa, now);
                break;
            }
        }
        if (generateConvergenceBalanceEvents) {
            this.tryGenerateConvergenceBalanceEvent(balance);
        }
    }

    private void processContractBalanceChangedEventForSuper(EventListenerContext ctx, Integer contractId, ContractBalanceChangedEvent ev) throws BGException {
        long now = ev.getTimestamp();
        ConvergenceBalanceRuntime balance = this.getBalanceIfExists(contractId, now);
        if (balance == null) {
            return;
        }
        if (balance.created >= now) {
            switch (ev.getType()) {
                case 3: 
                case 4: {
                    this.checkForCollision(balance, now);
                    break;
                }
            }
            return;
        }
        switch (ev.getType()) {
            case 1: {
                balance.addAccount(ev.getSumma(), now);
                break;
            }
            case 2: {
                this.balanceMap.remove(balance.contractId);
                return;
            }
            case 3: {
                BigDecimal summa = ev.getSumma();
                balance.addPayment(summa, now);
                this.checkForCollision(balance, now);
                break;
            }
            case 4: {
                BigDecimal summa = ev.getSumma();
                balance.addCharge(summa, now);
                this.checkForCollision(balance, now);
                break;
            }
            case 5: {
                BigDecimal summa = ev.getSumma();
                balance.addReserve(summa, now);
                break;
            }
            case 6: {
                BigDecimal summa = ev.getSumma();
                balance.subtractReserve(summa, now);
                break;
            }
        }
    }

    private boolean checkForCollision(ConvergenceBalanceRuntime balance, long now) {
        long delta = now - balance.created;
        if (delta < 10000L) {
            if (delta < 5000L) {
                this.balanceMap.remove(balance.contractId, balance);
                return true;
            }
            if (this.balanceService.getQueue().size() < 100000) {
                this.balanceService.schedule(() -> this.balanceMap.remove(balance.contractId, balance), 10L, TimeUnit.SECONDS);
            } else {
                this.balanceMap.remove(balance.contractId, balance);
            }
            return true;
        }
        return false;
    }

    public ConvergenceBalance copy(final ConvergenceBalance convergenceBalance, final BigDecimal balance) {
        return new ConvergenceBalance(){

            @Override
            public BigDecimal getBalance() {
                return balance;
            }

            @Override
            public BigDecimal getSaldo() {
                return convergenceBalance.getSaldo();
            }

            @Override
            public BigDecimal getLimit() {
                return convergenceBalance.getLimit();
            }

            @Override
            public boolean isBalanceExceedsLimit() {
                return balance.compareTo(this.getLimit()) >= 0;
            }

            @Override
            public boolean isBalanceExceedsLimit(BigDecimal addAccount) {
                return balance.subtract(addAccount).compareTo(this.getLimit()) >= 0;
            }

            @Override
            @Deprecated
            public boolean isBalanceUnderLimit(BigDecimal addAccount) {
                return this.isBalanceExceedsLimit(addAccount);
            }

            @Override
            @Deprecated
            public boolean isBalanceUnderLimit() {
                return this.isBalanceExceedsLimit();
            }

            public String toString() {
                return new StringBuilder(25).append(this.getBalance().toPlainString()).append(" [").append(this.getLimit().toPlainString()).append("]").toString();
            }
        };
    }

    static class InstanceHolder {
        static final ConvergenceBalanceManager manager = InstanceHolder.newManager();

        InstanceHolder() {
        }

        static ConvergenceBalanceManager newManager() {
            try {
                return new ConvergenceBalanceManager((DefaultServerSetup)Setup.getSetup());
            }
            catch (BGException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
    }

    private static class Cleaner
    implements Runnable {
        private final Collection<ConvergenceBalanceRuntime> iterable;
        private Iterator<ConvergenceBalanceRuntime> iter;
        private final long timeout;

        Cleaner(Collection<ConvergenceBalanceRuntime> iterable, long seconds) {
            this.iterable = iterable;
            this.timeout = TimeUnit.MILLISECONDS.convert(seconds, TimeUnit.SECONDS);
            logger.trace("Cleaner: timeout = {}", (Object)this.timeout);
        }

        @Override
        public void run() {
            if (this.iter == null || !this.iter.hasNext()) {
                this.iter = this.iterable.iterator();
            }
            long test = System.currentTimeMillis() - this.timeout;
            int max = Math.min(Math.max(this.iterable.size() / 60, 500), 1000);
            for (int count = 0; count < max && this.iter.hasNext(); ++count) {
                ConvergenceBalanceRuntime balance = this.iter.next();
                logger.trace("Cleaner: balance = {}", (Object)balance);
                if (balance.lastAccess >= test) continue;
                this.iter.remove();
            }
        }
    }

    private static class Updater
    implements Runnable {
        private final Collection<ConvergenceBalanceRuntime> iterable;
        private Iterator<ConvergenceBalanceRuntime> iter;
        private final long timeout;

        Updater(Collection<ConvergenceBalanceRuntime> iterable, long seconds) {
            this.iterable = iterable;
            this.timeout = TimeUnit.MILLISECONDS.convert(seconds, TimeUnit.SECONDS);
            logger.trace("Updater: timeout = {}", (Object)this.timeout);
        }

        @Override
        public void run() {
            if (this.iter == null || !this.iter.hasNext()) {
                this.iter = this.iterable.iterator();
            }
            long test = System.currentTimeMillis() - this.timeout;
            int max = Math.min(Math.max(this.iterable.size() / 60, 500), 1000);
            for (int count = 0; count < max && this.iter.hasNext(); ++count) {
                ConvergenceBalanceRuntime balance = this.iter.next();
                logger.trace("Updater: balance = {}", (Object)balance);
                if (balance.created >= test) continue;
                this.iter.remove();
            }
        }
    }
}

