/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action.idealer;

import au.com.bytecode.opencsv.CSVWriter;
import bitel.billing.server.ActionResultContentType;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import ru.bitel.bgbilling.modules.card.common.bean.DealerPayment;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBaseIDealer;
import ru.bitel.bgbilling.modules.card.server.bean.DealerPaymentDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.localize.Localizer;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.common.util.FileDownload;

public class ActionPaymentListExport
extends ActionBaseIDealer {
    public void doAction() throws Exception {
        if (this.mid < 0 || this.dealer == null) {
            return;
        }
        Page page = this.getPage();
        Date from = this.getDateParameter("from");
        Date until = this.getDateParameter("until");
        int type = this.getIntParameter("type", 3);
        String contractTitle = this.getParameter("contract");
        if (from == null) {
            from = new Date();
        }
        DealerPaymentDao dao = new DealerPaymentDao(this.con, this.mid, from);
        Result<DealerPayment> result = dao.list(Collections.singleton(this.dealer.getId()), from, until, type, null, contractTitle, 0L, null, page);
        try {
            ActionResultContentType.binary.set((ServletRequest)this.request);
            this.response.setContentType("text/csv");
            this.response.setHeader("Content-Disposition", FileDownload.getContentDisposition((HttpServletRequest)this.request, (String)MessageFormat.format("payments_{0,date}-{1,date}.csv", from, until), (boolean)true));
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            char decimalSeparator = this.moduleSetup.getChar("format.decimal.separator", Localizer.getDecimalFormatSymbols().getDecimalSeparator());
            dfs.setDecimalSeparator(decimalSeparator);
            DecimalFormat df = new DecimalFormat("########0.00", dfs);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.response.getOutputStream(), "UTF-8");
            CSVWriter csv = new CSVWriter((Writer)writer, this.moduleSetup.get("csv.separator", ";").charAt(0));
            for (DealerPayment payment : result.getList()) {
                csv.writeNext(new String[]{payment.getTransId(), payment.getDealerTitle(), payment.getContractTitle(), payment.getContractComment(), TimeUtils.format((Date)payment.getDateTime(), (String)"dd.MM.yyyy HH:mm:ss"), df.format(payment.getSumma()), payment.getPaymentComment(), switch (payment.getStatus()) {
                    case 1 -> "\u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d";
                    case 0 -> "\u043e\u0442\u043c\u0435\u043d\u0435\u043d";
                    case -1 -> "\u0443\u0434\u0430\u043b\u0435\u043d";
                    default -> "-";
                }}, false);
            }
            csv.flush();
            csv.close();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }
}

