/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.tariff;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ModuleServiceTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Packet;
import ru.bitel.bgbilling.modules.cerbercrypt.server.tariff.CerbercryptServiceCost;
import ru.bitel.bgbilling.modules.cerbercrypt.server.tariff.CerbercryptTariffContext;
import ru.bitel.bgbilling.modules.cerbercrypt.server.tariff.CerbercryptTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

public class DiscountIgnoreTariffTreeNode
extends ModuleServiceTariffTreeNode<CerbercryptTariffContext, CerbercryptServiceCost, CerbercryptTariffRequest> {
    private Set<Integer> packets = new HashSet<Integer>();

    public DiscountIgnoreTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        String packets = parameterMap.get("packets");
        if (Utils.notBlankString((String)packets)) {
            this.packets.addAll(Utils.toIntegerList((String)packets));
        }
    }

    public int execute(Long treeNodeId, Long parentTreeNodeId, CerbercryptTariffRequest tariffRequest, TariffTreeNodeHolder holder, CerbercryptTariffContext tariffContext, TreeContext treeContext, ThreadContext workerContext) {
        int curr_packet_id;
        List<Packet> packets_oncontract;
        Set<Integer> ignoreDiscountPackets = tariffRequest.getPacketsIgnoreDiscount();
        if (ignoreDiscountPackets != null) {
            ignoreDiscountPackets.addAll(this.packets);
        } else {
            tariffRequest.setPacketsIgnoreDiscount(new HashSet<Integer>(this.packets));
        }
        List<Packet> packets = tariffRequest.getPacketList();
        if (packets != null) {
            int packetsMinus = 0;
            for (Packet packet : packets) {
                if (!this.packets.contains(packet.getId())) continue;
                ++packetsMinus;
            }
            tariffRequest.setPacketMinus(packetsMinus);
        }
        if ((packets_oncontract = tariffRequest.getPacketListOnContract()) != null) {
            int packetsMinus_oncontract = 0;
            for (Packet packet_oncontract : packets_oncontract) {
                if (!this.packets.contains(packet_oncontract.getId())) continue;
                ++packetsMinus_oncontract;
            }
            tariffRequest.setPacketMinusOnContract(packetsMinus_oncontract);
        }
        if ((curr_packet_id = tariffRequest.getPacket()) > 0) {
            int packetsMinus_current_oncontract = 0;
            if (this.packets.contains(curr_packet_id)) {
                int packet_count_current_oncontract;
                packetsMinus_current_oncontract = packet_count_current_oncontract = tariffRequest.getPacketCountOnContractCurrent();
            }
            tariffRequest.setPacketMinusOnContractCurrent(packetsMinus_current_oncontract);
        }
        return 1;
    }
}

