/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.MSUtils;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.kernel.network.tlv.Tlv;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class RadiusUtils {
    private static final Logger log = LogManager.getLogger();
    private static SecureRandom random = new SecureRandom();
    public static volatile boolean logEnable = true;
    private static final Pattern nasPortIdPattern1 = Pattern.compile("0/0/0/0/0/0");
    private static final Pattern nasPortIdPattern2 = Pattern.compile("[\\D]+");

    public static int checkMessageAuthenticator(RadiusPacket packet, ByteBuffer bb, byte[] secret) throws InvalidKeyException, NoSuchAlgorithmException {
        Object ma = packet.getAttribute(-1, 80);
        if (ma != null) {
            ByteBuffer data = ((RadiusAttribute)ma).getDataInternal();
            data.put(RadiusPacket.empty16);
            data.rewind();
            byte[] hmac = RadiusUtils.getHmacMD5(secret, bb);
            if (!Arrays.equals(hmac, packet.messageAuthenticator)) {
                log.error("Invalid message authenticator!");
                return 0;
            }
            data.put(packet.messageAuthenticator);
            data.rewind();
            bb.reset();
            return 1;
        }
        return -1;
    }

    public static byte[] getHmacMD5(byte[] key, ByteBuffer data) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec skey = new SecretKeySpec(key, "HmacMD5");
        Mac mac = Mac.getInstance("HmacMD5");
        mac.init(skey);
        mac.update(data);
        return mac.doFinal();
    }

    public static byte[] next() {
        return RadiusUtils.next(16);
    }

    public static byte[] next(int num) {
        byte[] result = new byte[num];
        random.nextBytes(result);
        return result;
    }

    public static byte[] encodeChapPassword(String userPassword, byte[] chapChallenge) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte chapIdentifier = (byte)random.nextInt(256);
        byte[] chapPassword = new byte[17];
        chapPassword[0] = chapIdentifier;
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.reset();
        md5.update(chapIdentifier);
        md5.update(userPassword.getBytes("UTF-8"));
        byte[] chapHash = md5.digest(chapChallenge);
        System.arraycopy(chapHash, 0, chapPassword, 1, 16);
        return chapPassword;
    }

    public static byte[] encodePapPassword(byte[] userPassword, byte[] secret, byte[] authenticator) throws NoSuchAlgorithmException {
        int i;
        byte[] userPassBytes = null;
        if (userPassword.length > 128) {
            userPassBytes = new byte[128];
            System.arraycopy(userPassword, 0, userPassBytes, 0, 128);
        } else {
            userPassBytes = userPassword;
        }
        byte[] encryptedPass = null;
        encryptedPass = userPassBytes.length < 128 ? (userPassBytes.length % 16 == 0 ? new byte[userPassBytes.length] : new byte[userPassBytes.length / 16 * 16 + 16]) : new byte[128];
        System.arraycopy(userPassBytes, 0, encryptedPass, 0, userPassBytes.length);
        for (int i2 = userPassBytes.length; i2 < encryptedPass.length; ++i2) {
            encryptedPass[i2] = 0;
        }
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        if (secret != null) {
            md5.update(secret);
        }
        md5.update(authenticator);
        byte[] bn = md5.digest();
        for (i = 0; i < 16; ++i) {
            encryptedPass[i] = (byte)(bn[i] ^ encryptedPass[i]);
        }
        if (encryptedPass.length > 16) {
            for (i = 16; i < encryptedPass.length; i += 16) {
                md5.reset();
                if (secret != null) {
                    md5.update(secret);
                }
                md5.update(encryptedPass, i - 16, 16);
                bn = md5.digest();
                for (int j = 0; j < 16; ++j) {
                    encryptedPass[i + j] = (byte)(bn[j] ^ encryptedPass[i + j]);
                }
            }
        }
        return encryptedPass;
    }

    public static void setChapPassword(RadiusPacket packet, String userPassword) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] chapChallenge = RadiusUtils.next(16);
        byte[] chapPassword = RadiusUtils.encodeChapPassword(userPassword, chapChallenge);
        packet.setAttribute(new RadiusAttribute(-1, 60, ByteBuffer.wrap(chapChallenge)));
        packet.setAttribute(new RadiusAttribute(-1, 3, ByteBuffer.wrap(chapPassword)));
    }

    public static void setPapPassword(RadiusPacket packet, byte[] secret, String userPassword) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] papPassword = RadiusUtils.encodePapPassword(userPassword.getBytes(StandardCharsets.UTF_8), secret, packet.authenticator);
        packet.setAttribute(new RadiusAttribute.RadiusAttributeString(-1, 2, ByteBuffer.wrap(papPassword)));
    }

    public static void decryptPassword(RadiusPacket request, byte[] secret) {
        byte[] requestAuth;
        Object userPassword = request.getAttribute(-1, 2);
        if (secret != null && userPassword != null && (requestAuth = request.authenticator) != null) {
            byte[] userPassw = new byte[16];
            byte[] encryptedPassw = ((Tlv)userPassword).getDataAsByteArray();
            System.arraycopy(encryptedPassw, 0, userPassw, 0, Math.min(encryptedPassw.length, userPassw.length));
            byte[] concattedAuthSec = new byte[secret.length + requestAuth.length];
            System.arraycopy(secret, 0, concattedAuthSec, 0, secret.length);
            System.arraycopy(requestAuth, 0, concattedAuthSec, secret.length, requestAuth.length);
            byte[] hash = Utils.getDigestBytes((byte[])concattedAuthSec);
            for (int i = 0; i < 16; ++i) {
                int n = i;
                userPassw[n] = (byte)(userPassw[n] ^ hash[i]);
            }
            int pos = -1;
            for (int i = 0; i < userPassw.length; ++i) {
                if (userPassw[i] != 0) continue;
                pos = i;
                break;
            }
            if (pos == -1) {
                pos = userPassw.length;
            }
            byte[] newUserPassword = new byte[pos];
            for (int i = 0; i < pos; ++i) {
                newUserPassword[i] = userPassw[i];
            }
            request.setAttribute(new RadiusAttribute.RadiusAttributeString(-1, 2, ByteBuffer.wrap(newUserPassword)));
        }
    }

    public static boolean checkChapPassword(RadiusAttributeSet packet, byte[] authenticator, String openPassword) {
        boolean result = false;
        Object chapPassword = packet.getAttribute(-1, 3);
        byte[] challengeBytes = authenticator;
        Object challenge = packet.getAttribute(-1, 60);
        if (challenge != null) {
            challengeBytes = ((Tlv)challenge).getDataAsByteArray();
        }
        if (chapPassword != null && challengeBytes != null && openPassword != null) {
            try {
                byte[] chap = ((Tlv)chapPassword).getDataAsByteArray();
                byte indent = chap[0];
                byte[] passwBytes = openPassword.getBytes("ISO-8859-1");
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                md5.update(indent);
                md5.update(passwBytes);
                md5.update(challengeBytes);
                byte[] hash = md5.digest();
                result = true;
                for (int i = 0; i < hash.length; ++i) {
                    if (hash[i] == chap[i + 1]) continue;
                    result = false;
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        } else {
            result = false;
        }
        return result;
    }

    public static boolean checkDigestMD5Password(RadiusAttributeSet packet, String openPassw) {
        log.trace("try checkDigestMD5Password ");
        boolean result = false;
        try {
            byte code;
            String user = null;
            String realm = null;
            String nonce = null;
            String method = null;
            String uri = null;
            List<RadiusAttribute<?>> digestAttributes = packet.getAttributes(-1, 207);
            RadiusAttribute.RadiusAttributeString digestResponseAttribute = (RadiusAttribute.RadiusAttributeString)packet.getAttribute(-1, 206);
            String digestResponse = null;
            if (digestResponseAttribute != null) {
                digestResponse = (String)digestResponseAttribute.getValue();
            }
            log.trace("digestAttributes=" + digestAttributes);
            log.trace("digestResponse=" + digestResponse);
            if (digestAttributes != null && Utils.notBlankString((String)digestResponse)) {
                try {
                    for (RadiusAttribute<?> attr : digestAttributes) {
                        byte[] value = attr.getDataAsByteArray();
                        code = value[0];
                        String subValue = new String(value, 2, value.length - 2, "ISO-8859-1");
                        switch (code) {
                            case 1: {
                                realm = subValue;
                                break;
                            }
                            case 2: {
                                nonce = subValue;
                                break;
                            }
                            case 3: {
                                method = subValue;
                                break;
                            }
                            case 4: {
                                uri = subValue;
                                break;
                            }
                            case 10: {
                                user = subValue;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("user =" + user + " realm =" + realm + " nonce = " + nonce + " method = " + method + " uri = " + uri);
            }
            if (user == null || realm == null || nonce == null || method == null || uri == null) {
                log.trace("try all in one string");
                user = null;
                realm = null;
                nonce = null;
                method = null;
                uri = null;
                RadiusAttribute.RadiusAttributeString digestAttribute = (RadiusAttribute.RadiusAttributeString)packet.getAttribute(-1, 207);
                log.trace("digestAttribute=" + digestAttribute);
                if (digestAttribute != null && Utils.notBlankString((String)digestResponse)) {
                    try {
                        byte length;
                        byte[] value = digestAttribute.getDataAsByteArray();
                        log.debug("value[]=" + Utils.bytesToHexString((byte[])value));
                        block21: for (int i = 0; i < value.length; i += length) {
                            code = value[i];
                            log.debug("code=" + code);
                            length = value[i + 1];
                            log.debug("length=" + length);
                            String subValue = new String(value, i + 2, length - 2, "ISO-8859-1");
                            log.debug("subValue=" + subValue);
                            switch (code) {
                                case 1: {
                                    realm = subValue;
                                    continue block21;
                                }
                                case 2: {
                                    nonce = subValue;
                                    continue block21;
                                }
                                case 3: {
                                    method = subValue;
                                    continue block21;
                                }
                                case 4: {
                                    uri = subValue;
                                    continue block21;
                                }
                                case 10: {
                                    user = subValue;
                                }
                            }
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("user =" + user + " realm =" + realm + " nonce = " + nonce + " method = " + method + " uri = " + uri);
                        }
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (user != null && realm != null && nonce != null && method != null && uri != null) {
                String a1 = Utils.getDigest((String)(user + ":" + realm + ":" + openPassw), (String)"cp1251").toLowerCase();
                String a2 = Utils.getDigest((String)(method + ":" + uri), (String)"cp1251").toLowerCase();
                String validResult = Utils.getDigest((String)(a1 + ":" + nonce + ":" + a2), (String)"cp1251").toLowerCase();
                result = validResult.equals(digestResponse);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static boolean checkDigestPassword(RadiusAttributeSet packet, RadiusAttributeSet response, String openPassw) {
        Object digestResponse = packet.getAttribute(-1, 103);
        if (digestResponse != null) {
            try {
                byte[] qopData;
                Object userName = packet.getAttribute(-1, 115);
                Object method = packet.getAttribute(-1, 108);
                Object uri = packet.getAttribute(-1, 109);
                Object realm = packet.getAttribute(-1, 104);
                Object nonce = packet.getAttribute(-1, 105);
                Object algoritm = packet.getAttribute(-1, 111);
                if (algoritm != null && !"md5".equalsIgnoreCase((String)((Tlv)algoritm).getValue())) {
                    log.warn("Unsupported Digest-Algorithm=" + (String)((Tlv)algoritm).getValue());
                    return false;
                }
                if (userName == null || method == null || uri == null || realm == null || nonce == null) {
                    log.warn("Incorrect Digest-Authentication attributes.");
                    return false;
                }
                Object qop = packet.getAttribute(-1, 110);
                Object nonceCount = packet.getAttribute(-1, 114);
                Object cnonce = packet.getAttribute(-1, 113);
                byte[] colon = ":".getBytes("UTF-8");
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                md5.update(((Tlv)userName).getDataAsByteArray());
                md5.update(colon);
                md5.update(((Tlv)realm).getDataAsByteArray());
                md5.update(colon);
                md5.update(openPassw.getBytes("UTF-8"));
                byte[] a1 = md5.digest();
                a1 = Utils.bytesToHexString((byte[])a1).toLowerCase().getBytes("UTF-8");
                md5.reset();
                md5.update(((Tlv)method).getDataAsByteArray());
                md5.update(colon);
                md5.update(((Tlv)uri).getDataAsByteArray());
                byte[] a2 = md5.digest();
                a2 = Utils.bytesToHexString((byte[])a2).toLowerCase().getBytes("UTF-8");
                byte[] nonceBytes = ((String)((Tlv)nonce).getValue()).getBytes("UTF-8");
                md5.reset();
                md5.update(a1);
                md5.update(colon);
                md5.update(nonceBytes);
                md5.update(colon);
                if (qop != null && (qopData = ((Tlv)qop).getDataAsByteArray()) != null & qopData.length > 0) {
                    md5.update(((Tlv)nonceCount).getDataAsByteArray());
                    md5.update(colon);
                    md5.update(((Tlv)cnonce).getDataAsByteArray());
                    md5.update(colon);
                    md5.update(qopData);
                    md5.update(colon);
                }
                md5.update(a2);
                byte[] resp = md5.digest();
                if (Utils.bytesToHexString((byte[])resp).toLowerCase().equals(((String)((Tlv)digestResponse).getValue()).toLowerCase())) {
                    byte[] qopData2;
                    md5.reset();
                    md5.update(colon);
                    md5.update(((Tlv)uri).getDataAsByteArray());
                    a2 = md5.digest();
                    a2 = Utils.bytesToHexString((byte[])a2).toLowerCase().getBytes("UTF-8");
                    md5.reset();
                    md5.update(a1);
                    md5.update(colon);
                    md5.update(nonceBytes);
                    md5.update(colon);
                    if (qop != null && (qopData2 = ((Tlv)qop).getDataAsByteArray()) != null & qopData2.length > 0) {
                        md5.update(((Tlv)nonceCount).getDataAsByteArray());
                        md5.update(colon);
                        md5.update(((Tlv)cnonce).getDataAsByteArray());
                        md5.update(colon);
                        md5.update(qopData2);
                        md5.update(colon);
                    }
                    md5.update(a2);
                    resp = md5.digest();
                    response.setAttribute(new RadiusAttribute.RadiusAttributeString(-1, 106, Utils.bytesToHexString((byte[])resp).toLowerCase()));
                    return true;
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public static boolean checkPassword(Nas<?, ?, ?> nas, String openPassw, RadiusAttributeSet packet, RadiusAttributeSet response, byte[] secret, byte[] authenticator) {
        String userPassw;
        RadiusAttribute.RadiusAttributeString pswd = (RadiusAttribute.RadiusAttributeString)packet.getAttribute(-1, 2);
        if (pswd != null && (userPassw = (String)pswd.getValue()) != null && openPassw != null && (userPassw.equals(openPassw) || Utils.getDigest((String)userPassw, (String)"cp1251").equals(openPassw))) {
            return true;
        }
        if (RadiusUtils.checkDigestMD5Password(packet, openPassw)) {
            return true;
        }
        if (RadiusUtils.checkChapPassword(packet, authenticator, openPassw)) {
            return true;
        }
        if (MSUtils.checkMSChapV2Password(packet, response, openPassw, secret, authenticator, nas.isMppeAddTypesAndPolicy())) {
            return true;
        }
        return RadiusUtils.checkDigestPassword(packet, response, openPassw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int insertToLog(DefaultServerSetup setup, int mid, RadiusPacket packet, Date logMonthDate) {
        int result = 0;
        if (!logEnable) {
            return 0;
        }
        String query = null;
        String tableName = RadiusUtils.getLogTableName(mid, logMonthDate);
        Connection con = setup.getDBTrashOrMasterConnectionFromPool(tableName);
        try {
            RadiusUtils.checkAndCreateLogTable(setup, tableName, con);
            query = "INSERT INTO " + tableName + " ( requests ) VALUES ( ? )";
            PreparedStatement ps = con.prepareStatement(query, 1);
            ps.setString(1, "\n" + TimeUtils.format((Date)new Date(), (String)"dd HH:mm:ss") + "\n" + packet.toString());
            ps.executeUpdate();
            result = ServerUtils.lastInsertId(ps);
            ps.close();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            ServerUtils.closeConnection(con);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToLog(DefaultServerSetup setup, int mid, RadiusPacket packet, Date logMonthDate, int recordId) {
        Connection con;
        block6: {
            if (!logEnable) {
                return;
            }
            con = null;
            String query = null;
            try {
                String tableName = RadiusUtils.getLogTableName(mid, logMonthDate);
                con = setup.getDBTrashOrMasterConnectionFromPool(tableName);
                if (con == null) break block6;
                String logString = packet.toString();
                query = "UPDATE LOW_PRIORITY " + tableName + " SET requests=CONCAT( requests, ' ', ? ) WHERE id=?";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setString(1, "\n" + TimeUtils.format((Date)new Date(), (String)"dd HH:mm:ss") + "\n" + logString);
                ps.setInt(2, recordId);
                if (ps.executeUpdate() == 0) {
                    log.error("RadiusUtils.addToLog - can't append: date=" + logMonthDate.getTime() + " tableName=" + tableName + " record_id=" + recordId + " log:\n" + logString);
                }
                ps.close();
            }
            catch (Exception ex) {
                try {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    ServerUtils.closeConnection(con);
                    throw throwable;
                }
                ServerUtils.closeConnection(con);
            }
        }
        ServerUtils.closeConnection(con);
    }

    private static void checkAndCreateLogTable(DefaultServerSetup setup, String tableName, Connection con) {
        String query = "CREATE TABLE " + tableName + "( id int auto_increment primary key NOT NULL,  requests LONGTEXT NOT NULL )";
        ServerUtils.checkAndCreatePeriodicTableName(con, tableName, query);
    }

    private static String getLogTableName(int mid, Date date) {
        return ServerUtils.getModuleMonthTableName("log_server", date, mid);
    }

    public static int getNasPort(RadiusPacket request) {
        Object nasPortIdAttribute;
        Object nasPortAttribute = request.getAttribute(-1, 5);
        if (nasPortAttribute != null) {
            Object result = ((Tlv)nasPortAttribute).getValue();
            if (result instanceof Number) {
                return ((Number)result).intValue();
            }
            log.error("Can't parse Nas-Port attribute");
        }
        if ((nasPortIdAttribute = request.getAttribute(-1, 87)) != null) {
            String nasPortId = String.valueOf(((Tlv)nasPortIdAttribute).getValue());
            nasPortId = nasPortIdPattern1.matcher(nasPortId).replaceAll("");
            nasPortId = nasPortIdPattern2.matcher(nasPortId).replaceAll("");
            nasPortId = nasPortId.substring(Math.max(0, nasPortId.length() - 9));
            return Utils.parseInt((String)nasPortId, (int)0);
        }
        return 0;
    }

    public static class RadiusPacketAdapter
    extends XmlAdapter<byte[], RadiusPacket> {
        public byte[] marshal(RadiusPacket v) throws Exception {
            byte[] packet = new byte[4096];
            ByteBuffer bb = ByteBuffer.wrap(packet);
            v.write(bb, new byte[16]);
            return Arrays.copyOf(packet, bb.position());
        }

        public RadiusPacket unmarshal(byte[] v) throws Exception {
            ByteBuffer bb = ByteBuffer.wrap(v);
            return RadiusPacket.parse(bb);
        }
    }
}

