/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.tariff;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.editor.MultiSelectEditor;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;

public class NZoneTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon((String)"eath");
    private JLabel view = new JLabel();
    private MultiSelectEditor multiList;
    private Directory zoneDir;
    private String zoneTitle;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> nodes) {
        super.init(id, mtree, type, tree, config, parent, nodes);
        this.view.setIcon(icon);
        this.zoneDir = this.getDirManager().getDirectory("zones");
    }

    public Component getView() {
        return this.view;
    }

    public void setData(String data) {
        super.setData(data);
        this.updateView();
    }

    private void updateView() {
        try {
            this.extractData();
            this.view.setText(this.zoneTitle);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    protected void loadData() throws Exception {
        ((MultiSelectEditor)this.getEditorPanel()).setSelect(this.getDataInHash().getOrDefault("zone", ""));
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("zone", this.multiList.getSelect());
        this.setDataInHash(data);
        this.updateView();
    }

    public void extractData() throws Exception {
        String zone = this.getDataInHash().getOrDefault("zone", "");
        StringBuffer str = new StringBuffer();
        if (this.zoneDir != null && !zone.equals("")) {
            Iterator iterator = Utils.toIntegerList((String)zone).iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                str.append(str.length() > 0 ? ";" : "").append(" ").append(this.zoneDir.getValue(id));
            }
        }
        this.zoneTitle = this.getLabelTitle() + str.toString();
    }

    protected JPanel getEditorPanel() throws Exception {
        if (this.multiList == null) {
            this.multiList = new MultiSelectEditor(this.zoneDir.getItems());
        }
        return this.multiList;
    }

    public void serializeToXML(Element element) throws Exception {
        super.serializeToXML(element);
        this.extractData();
        if (Utils.notEmptyString((String)this.zoneTitle)) {
            element.setAttribute("zone", this.zoneTitle);
        }
        this.serializeChildsToXML(element);
    }

    public void loadFromXML(Element element) throws Exception {
        HashMap<String, String> data = new HashMap<String, String>(3);
        String zone = element.getAttribute("zone");
        if (Utils.notBlankString((String)zone)) {
            String[] titles = zone.split("|");
            ArrayList<Integer> codes = new ArrayList<Integer>();
            for (String zoneTitle : titles) {
                int zoneCode = this.zoneDir.getCode(zoneTitle);
                if (zoneCode <= 0) {
                    zoneCode = this.zoneDir.addValue(zoneTitle);
                }
                codes.add(zoneCode);
            }
            data.put("zone", Utils.toString(codes));
        }
        this.setDataInHash(data);
        this.saveData();
        this.updateView();
        this.loadChildsFromXML(element);
    }

    protected String getLabelTitle() {
        return "\u0417\u043e\u043d\u0430: ";
    }
}

