/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.access.sa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivatorEventType;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntimeMap;
import ru.bitel.common.Utils;

public class ServiceActivatorEvent {
    final transient Access inetAccess;
    final int eventType;
    int processDeviceId;
    boolean consumed = false;
    boolean async;
    boolean doAsync = false;
    final int inetServId;
    final boolean call;
    final InetServ oldInetServ;
    final InetServ newInetServ;
    final int oldState;
    final short newState;
    final int accessCode;
    final Set<Integer> oldOptions;
    final Set<Integer> newOptions;
    final Set<Integer> optionsToAdd;
    final Set<Integer> optionsToRemove;
    final InetServRuntime servRuntime;
    InetConnectionRuntime connectionRuntime;
    List<InetConnection> serviceConnections;
    private String realm;
    boolean connectionStateModified;
    boolean connectionOptionsModified = true;
    List<Future<?>> futures;
    final Event event;

    public void consume() {
        this.consumed = true;
    }

    public void doAsync() {
        this.doAsync = true;
    }

    public boolean isAsync() {
        return this.async;
    }

    public int getInetServId() {
        return this.inetServId;
    }

    public ServiceActivatorEvent(Access inetAccess, Event event, int processDeviceId, InetServRuntime servRuntime, int eventType, int inetServId, InetServType inetServType, InetServ oldInetServ, InetServ newInetServ, short oldState, short newState, Set<Integer> oldOptionSet, Set<Integer> newOptionSet, int accessCode) {
        this.inetAccess = inetAccess;
        this.event = event;
        this.servRuntime = servRuntime;
        this.eventType = eventType;
        this.processDeviceId = processDeviceId;
        this.inetServId = inetServId;
        this.oldInetServ = oldInetServ;
        this.newInetServ = newInetServ;
        this.oldState = oldState;
        this.newState = newState;
        if (oldOptionSet == null) {
            oldOptionSet = Collections.emptySet();
        }
        if (newOptionSet == null) {
            newOptionSet = Collections.emptySet();
        }
        this.oldOptions = oldOptionSet;
        this.newOptions = newOptionSet;
        this.accessCode = accessCode;
        if (oldOptionSet.size() == 0 || newOptionSet.size() == 0) {
            this.optionsToRemove = oldOptionSet;
            this.optionsToAdd = newOptionSet;
        } else {
            this.optionsToRemove = new HashSet<Integer>(oldOptionSet);
            this.optionsToRemove.removeAll(newOptionSet);
            this.optionsToAdd = new HashSet<Integer>(newOptionSet);
            this.optionsToAdd.removeAll(oldOptionSet);
        }
        this.call = inetServType.getSessionInitiationType() == 0;
    }

    public InetServRuntime getInetServRuntime() {
        return this.servRuntime;
    }

    public InetServ getOldInetServ() {
        return this.oldInetServ;
    }

    public InetServ getNewInetServ() {
        return this.newInetServ;
    }

    public int getAccessCode() {
        return this.accessCode;
    }

    public int getOldState() {
        return this.oldState;
    }

    public int getNewState() {
        return this.newState;
    }

    public boolean isOptionsModified() {
        return this.optionsToAdd.size() > 0 || this.optionsToRemove.size() > 0;
    }

    public Set<Integer> getOptionsToAdd() {
        return this.optionsToAdd;
    }

    public Set<Integer> getOptionsToRemove() {
        return this.optionsToRemove;
    }

    public InetConnection getConnection() {
        return this.connectionRuntime != null ? this.connectionRuntime.connection : null;
    }

    public void setConnectionRuntime(InetConnectionRuntime connectionRuntime) {
        assert (this.connectionRuntime == null);
        this.connectionRuntime = connectionRuntime;
    }

    public List<InetConnection> getServiceConnections() {
        return this.serviceConnections;
    }

    @Deprecated
    public Set<Integer> getOldOptionSet() {
        return this.oldOptions;
    }

    @Deprecated
    public Set<Integer> getNewOptionSet() {
        return this.newOptions;
    }

    public Set<Integer> getOldOptions() {
        return this.oldOptions;
    }

    public Set<Integer> getNewOptions() {
        return this.newOptions;
    }

    public boolean isConnectionStateModified() {
        return this.connectionStateModified;
    }

    public void setConnectionStateModified(boolean connectionStateModified) {
        this.connectionStateModified = connectionStateModified;
    }

    public boolean isConnectionOptionsModified() {
        return this.connectionOptionsModified;
    }

    public void setConnectionOptionsModified(boolean connectionOptionsModified) {
        this.connectionOptionsModified = connectionOptionsModified;
    }

    public String getRealm() {
        if (this.realm != null) {
            return this.realm;
        }
        if (this.connectionRuntime != null) {
            this.realm = InetUtils.getRealm(this.connectionRuntime.connection.getUsername());
        }
        return this.realm;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(200);
        result.append("ServiceActivatorEvent (");
        result.append("type=").append((Object)ServiceActivatorEventType.getServiceActivatorEventTypeByCode(this.eventType));
        result.append("; inetServId=").append(this.inetServId);
        result.append("; call=").append(this.call);
        result.append("; oldState=").append(this.oldState);
        result.append("; newState=").append(this.newState);
        result.append("; oldOptionSet=").append(Utils.toString(this.oldOptions));
        result.append("; newOptionSet=").append(Utils.toString(this.newOptions));
        result.append(")");
        return result.toString();
    }

    public static List<InetServ> getInetServChildren(InetServRuntimeMap inetServRuntimeMap, int inetServId, long millis) {
        List<InetServRuntime> childrenServRuntimes;
        List<InetServRuntime> list = childrenServRuntimes = millis <= 0L ? inetServRuntimeMap.listChildren(inetServId) : inetServRuntimeMap.listChildren(inetServId, millis);
        if (childrenServRuntimes == null || childrenServRuntimes.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<InetServ> childrenServs = new ArrayList<InetServ>(childrenServRuntimes.size());
        for (InetServRuntime servRuntime : childrenServRuntimes) {
            childrenServs.add(servRuntime.getInetServ());
        }
        return childrenServs;
    }
}

