/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import bitel.billing.module.common.IPField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;

class AdressPanel
extends JPanel {
    private IPField iPField1 = new IPField();
    private IPField iPField2 = new IPField();

    public AdressPanel() {
        this.initGUI();
    }

    public void initGUI() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String actionCommand = e.getActionCommand();
                this.process(actionCommand, 1, AdressPanel.this.iPField1);
                this.process(actionCommand, 2, AdressPanel.this.iPField2);
            }

            void process(String actionCommand, int n, IPField ipTextField) {
                Transferable content;
                Clipboard theClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                if (actionCommand.equals("copy" + n)) {
                    String ip = ipTextField.getIP();
                    if (ip != null && ip.length() > 0) {
                        StringSelection buffer = new StringSelection(ip);
                        theClipboard.setContents(buffer, buffer);
                    }
                } else if (actionCommand.equals("cut" + n)) {
                    String ip = ipTextField.getIP();
                    if (ip != null && ip.length() > 0) {
                        StringSelection buffer = new StringSelection(ip);
                        theClipboard.setContents(buffer, buffer);
                    }
                    ipTextField.setIP("0.0.0.0");
                } else if (actionCommand.equals("paste" + n) && (content = theClipboard.getContents(this)) != null) {
                    try {
                        ipTextField.setIP((String)content.getTransferData(DataFlavor.stringFlavor));
                    }
                    catch (Exception e) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
        };
        this.setLayout(new GridBagLayout());
        this.setBorder((Border)new BGTitleBorder(" \u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432 "));
        this.add((Component)((Object)new AdressPanelButton("copy1", "copy.png", "\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c", actionListener)), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)((Object)new AdressPanelButton("paste1", "paste.png", "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", actionListener)), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)((Object)new AdressPanelButton("cut1", "cut.png", "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c", actionListener)), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.iPField1, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel("-"), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.iPField2, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)((Object)new AdressPanelButton("copy2", "copy.png", "\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c", actionListener)), new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)((Object)new AdressPanelButton("paste2", "paste.png", "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", actionListener)), new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)((Object)new AdressPanelButton("cut2", "cut.png", "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c", actionListener)), new GridBagConstraints(9, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
    }

    public long getIPValue1() {
        return this.iPField1.getIPValue();
    }

    public long getIPValue2() {
        return this.iPField2.getIPValue();
    }

    public void setIPValue1(long value) {
        this.iPField1.setIPValue(value);
    }

    public void setIPValue2(long value) {
        this.iPField2.setIPValue(value);
    }

    public void setIpEnabled(boolean enabled) {
        this.iPField1.setEnabled(enabled);
        this.iPField2.setEnabled(enabled);
    }

    class AdressPanelButton
    extends BGButton {
        public AdressPanelButton(String actionCommand, String icon, String toolTipText, ActionListener actionListener) {
            this.setToolTipText(toolTipText);
            this.setIcon(ClientUtils.getIcon((String)icon));
            this.setActionCommand(actionCommand);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.addActionListener(actionListener);
        }
    }
}

