/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.gorod.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.modules.gorod.server.bean.Tag;

public class TagManager {
    protected int mid = -1;
    protected Connection con;

    public TagManager(Connection con, int mid) {
        this.mid = mid;
        this.con = con;
    }

    public List<Tag> getTagList() {
        ArrayList<Tag> result = new ArrayList<Tag>();
        try {
            String query = "SELECT * FROM gorod_tag_" + this.mid + " ORDER BY id";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Tag tag = new Tag();
                this.getTagFromRS(rs, tag);
                result.add(tag);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<Tag> getTagListForContract(int cid) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        try {
            String query = "SELECT g1.id, g1.title FROM gorod_tag_" + this.mid + " AS g1 LEFT JOIN gorod_contract_tag_" + this.mid + " AS g2 ON g1.id=g2.tid WHERE cid=? ORDER BY tid";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Tag tag = new Tag();
                this.getTagFromRS(rs, tag);
                result.add(tag);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Set<Integer> getTagSetForContract(int cid) {
        HashSet<Integer> result = new HashSet<Integer>();
        try {
            String query = "SELECT tid FROM gorod_contract_tag_" + this.mid + " WHERE cid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Tag getTagById(int tagId) {
        Tag tag = new Tag();
        try {
            String query = "SELECT * FROM gorod_tag_" + this.mid + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, tagId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                this.getTagFromRS(rs, tag);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tag;
    }

    @Deprecated
    public Tag getTagByID(int tagId) {
        return this.getTagById(tagId);
    }

    public void updateTag(Tag tag) {
        try {
            String query = "UPDATE gorod_tag_" + this.mid + " SET title=? WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, tag.getTitle());
            ps.setInt(2, tag.getId());
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addTag(String tagTitle) {
        try {
            String query = "INSERT INTO gorod_tag_" + this.mid + " SET title=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, tagTitle);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteTag(int tagId) {
        try {
            String query = "DELETE FROM gorod_contract_tag_" + this.mid + " WHERE tid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, tagId);
            ps.executeUpdate();
            ps.close();
            query = "DELETE FROM gorod_tag_" + this.mid + " WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, tagId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteTagFromContract(int cid, int tagId) {
        try {
            String query = "DELETE FROM gorod_contract_tag_" + this.mid + " WHERE cid=? AND tid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, tagId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void linkTagToContract(int cid, int tagId) {
        try {
            String query = "INSERT INTO gorod_contract_tag_" + this.mid + " SET cid=?, tid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, tagId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getTagFromRS(ResultSet rs, Tag tag) throws SQLException {
        tag.setId(rs.getInt("id"));
        tag.setTitle(rs.getString("title"));
    }
}

