/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.datalog.netflow.nat;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import ru.bitel.bgbilling.kernel.network.datalog.netflow.nat.NatLogHsl;
import ru.bitel.common.ByteBufferUtils;
import ru.bitel.common.util.FileSort;

public class NatLogHslSort
extends FileSort<NatLogHsl> {
    public NatLogHslSort(Comparator<NatLogHsl> comparator, int bufferSize) {
        super(comparator, bufferSize);
    }

    @Override
    protected void writeFile(File file, List<NatLogHsl> list) throws FileNotFoundException, IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        FileChannel channel = raf.getChannel();
        ByteBuffer bb = ByteBuffer.allocate(131070);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            NatLogHsl log = list.get(i);
            bb.putLong(log.millis);
            bb.putLong(log.millis2);
            bb.put(log.srcAddress);
            ByteBufferUtils.putUnsignedShort(bb, log.srcPort);
            bb.put(log.t_srcAddress);
            ByteBufferUtils.putUnsignedShort(bb, log.t_srcPort);
            bb.putInt(log.vrfId);
            bb.put(log.protocol);
            bb.put(log.add ? (byte)1 : 2);
            if (bb.hasRemaining()) continue;
            bb.flip();
            channel.write(bb);
            bb.clear();
        }
        bb.flip();
        channel.write(bb);
        if (channel.isOpen()) {
            channel.force(true);
        }
        channel.close();
        raf.close();
    }

    @Override
    protected Iterator<NatLogHsl> readFile(File file) throws IOException {
        return new FileIterator(file);
    }

    class FileIterator
    implements Iterator<NatLogHsl>,
    Closeable {
        private NatLogHsl v = null;
        private final ByteBuffer bb = ByteBuffer.allocate(131070);
        private final RandomAccessFile raf;
        private final FileChannel channel;

        FileIterator(File file) throws FileNotFoundException {
            this.raf = new RandomAccessFile(file, "r");
            this.channel = this.raf.getChannel();
            this.bb.limit(0);
        }

        @Override
        public boolean hasNext() {
            if (this.v != null) {
                return true;
            }
            try {
                while (!this.bb.hasRemaining()) {
                    this.bb.clear();
                    if (this.channel.read(this.bb) == -1) {
                        return false;
                    }
                    this.bb.flip();
                }
                long millis = this.bb.getLong();
                long millis2 = this.bb.getLong();
                byte[] intAddress = new byte[4];
                this.bb.get(intAddress);
                int intPort = ByteBufferUtils.getUnsignedShort(this.bb);
                byte[] extAddress = new byte[4];
                this.bb.get(extAddress);
                int extPort = ByteBufferUtils.getUnsignedShort(this.bb);
                int vrfId = this.bb.getInt();
                byte protocol = this.bb.get();
                boolean add = this.bb.get() == 1;
                this.v = new NatLogHsl(intAddress, intPort, extAddress, extPort, new byte[4], 0, new byte[4], 0, vrfId, protocol, millis, millis2, add);
                return true;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public NatLogHsl next() {
            NatLogHsl result = this.v;
            this.v = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            if (this.channel.isOpen()) {
                this.channel.force(true);
            }
            this.raf.close();
        }
    }
}

