/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

class BGUComboBoxKeySelectionManager
implements JComboBox.KeySelectionManager {
    private String pattern = null;

    BGUComboBoxKeySelectionManager() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public int selectionForKey(char ch, ComboBoxModel model) {
        int currentSelection = 0;
        Object selectedItem = model.getSelectedItem();
        if (selectedItem != null) {
            int c = model.getSize();
            for (int i = 0; i < c; ++i) {
                if (selectedItem != model.getElementAt(i)) continue;
                currentSelection = i;
                break;
            }
        }
        if (ch == '\u001b') {
            this.pattern = null;
            return -1;
        }
        if (!Character.isDefined(ch)) {
            return -1;
        }
        if (ch == '\b') {
            if (this.pattern != null && this.pattern.length() > 1) {
                this.pattern = this.pattern.substring(0, this.pattern.length() - 1);
                return this.find(model, currentSelection);
            }
            if (this.pattern == null) return -1;
            if (this.pattern.length() != 1) return -1;
            this.pattern = null;
            return -1;
        }
        if (this.pattern == null) {
            this.pattern = ("" + ch).toLowerCase();
            return this.find(model, currentSelection);
        }
        this.pattern = (this.pattern + ch).toLowerCase();
        return this.find(model, currentSelection);
    }

    public final int find(ComboBoxModel model, int currentSelection) {
        int i;
        int c = model.getSize();
        for (i = currentSelection; i < c; ++i) {
            String v;
            Object elem = model.getElementAt(i);
            if (elem == null || elem.toString() == null || (v = elem.toString().toLowerCase()).length() <= 0 || v.indexOf(this.pattern) < 0) continue;
            return i;
        }
        for (i = 0; i <= currentSelection; ++i) {
            String v;
            Object elem = model.getElementAt(i);
            if (elem == null || elem.toString() == null || (v = elem.toString().toLowerCase()).length() <= 0 || v.indexOf(this.pattern) < 0) continue;
            return i;
        }
        return -1;
    }

    public final int findNext(ComboBoxModel model, boolean down) {
        int i;
        int c;
        int currentSelection = -1;
        Object selectedItem = model.getSelectedItem();
        if (selectedItem != null) {
            c = model.getSize();
            for (i = 0; i < c; ++i) {
                if (selectedItem != model.getElementAt(i)) continue;
                currentSelection = i;
                break;
            }
        }
        if (down) {
            c = model.getSize();
            for (i = ++currentSelection; i < c; ++i) {
                String v;
                Object elem = model.getElementAt(i);
                if (elem == null || elem.toString() == null || (v = elem.toString().toLowerCase()).length() <= 0 || v.indexOf(this.pattern) < 0) continue;
                return i;
            }
        } else {
            for (i = --currentSelection; i >= 0; --i) {
                String v;
                Object elem = model.getElementAt(i);
                if (elem == null || elem.toString() == null || (v = elem.toString().toLowerCase()).length() <= 0 || v.indexOf(this.pattern) < 0) continue;
                return i;
            }
        }
        return -1;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void resetPattern() {
        this.pattern = null;
    }
}

