/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.script.action;

import bitel.billing.server.ActionBase;
import bitel.billing.server.script.bean.Function;
import bitel.billing.server.script.bean.FunctionManager;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.script.common.bean.EventType;
import ru.bitel.bgbilling.kernel.script.server.bean.EventTypeManager;
import ru.bitel.common.Utils;

public class ActionFunctionTable
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        int scriptId = this.getIntParameter("script_id", -1);
        if (scriptId < -1) {
            throw new BGIllegalArgumentException();
        }
        EventTypeManager etm = new EventTypeManager(this.con);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        for (Function f : new FunctionManager(this.con).getScriptFunctions(scriptId)) {
            Element row = this.createElement(data, "row");
            StringBuffer eventTypes = new StringBuffer(100);
            List<EventType> eventTypesList = etm.getEventTypeList(Utils.toString(f.getEventTypeIdList()));
            for (EventType et : eventTypesList) {
                if (eventTypes.length() != 0) {
                    eventTypes.append("; ");
                }
                Object title = et.getTitle();
                String moduleID = et.getModuleId();
                if (!moduleID.equals("0")) {
                    if (moduleID.startsWith("p")) {
                        int pluginUid = Utils.parseInt((String)moduleID.substring(1));
                        BGPluginServer plugin = BGPluginManagerServer.getManager().getPluginByUID(pluginUid);
                        if (plugin != null) {
                            title = "\u041f\u043b\u0430\u0433\u0438\u043d " + plugin.getName() + " => " + (String)title;
                        }
                    } else {
                        title = ModuleCache.getInstance().optModule(Utils.parseInt((String)moduleID)).map(a -> "\u041c\u043e\u0434\u0443\u043b\u044c " + a.getTitle() + " => ").orElse("") + (String)title;
                    }
                }
                eventTypes.append((String)title);
            }
            row.setAttribute("id", String.valueOf(f.getId()));
            row.setAttribute("title", f.getTitle());
            row.setAttribute("event_type", eventTypes.toString());
        }
    }
}

