/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class CopyOnWriteArrayMap<K, V> {
    protected final ConcurrentMap<K, V[]> arrayMap;

    public CopyOnWriteArrayMap(int mapInitialCapacity) {
        this.arrayMap = new ConcurrentHashMap<K, V[]>(mapInitialCapacity);
    }

    public int size() {
        return this.arrayMap.size();
    }

    protected abstract V[] newArray(int var1);

    protected abstract V[] newArray(V var1);

    public boolean add(K key, V value) {
        ConcurrentMap<K, V[][]> map = this.arrayMap;
        while (true) {
            Object[] newArray;
            Object[] array;
            if ((array = (Object[])map.get(key)) == null) {
                newArray = this.newArray(value);
                if (map.putIfAbsent(key, (V[][])newArray) != null) continue;
                return true;
            }
            int size = array.length;
            for (int i = 0; i < size; ++i) {
                if (!value.equals(array[i])) continue;
                return false;
            }
            newArray = this.newArray((V)(array.length + 1));
            System.arraycopy(array, 0, newArray, 0, array.length);
            newArray[array.length] = value;
            if (map.replace(key, (V[][])array, (V[][])newArray)) break;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean remove(K key, V value) {
        ConcurrentMap<K, int[][]> map = this.arrayMap;
        block0: while (true) {
            Object[] array;
            if ((array = (Object[])map.get(key)) == null) {
                return false;
            }
            int size = array.length;
            for (int i = 0; i < size; ++i) {
                if (!value.equals(array[i])) continue;
                if (size == 1) {
                    if (!map.remove(key, array)) continue block0;
                    return true;
                }
                int[] newArray = this.newArray((V)(array.length - 1));
                System.arraycopy(array, 0, newArray, 0, i);
                System.arraycopy(array, i + 1, newArray, i, array.length - i - 1);
                if (map.replace(key, (int[][])array, (int[][])newArray)) return true;
                continue block0;
            }
            break;
        }
        return false;
    }

    public String toString() {
        return this.arrayMap.toString();
    }
}

