/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.ipn.common.bean.RuleTypeLog;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class RuleTypeLogManager {
    private String tableName = null;
    protected int mid = -1;
    protected Connection con;

    public RuleTypeLogManager(Connection con, int mid) {
        this.mid = mid;
        this.con = con;
        this.tableName = "ipn_user_gate_rule_log_" + mid;
    }

    public List<RuleTypeLog> list(int cid, int gid) throws BGException {
        ArrayList<RuleTypeLog> result = new ArrayList<RuleTypeLog>();
        try {
            StringBuffer query = new StringBuffer();
            query.append(" SELECT log.*, rule.title as ruleTitle, user.name  as user FROM " + this.tableName + " as log ");
            query.append(" LEFT JOIN ipn_rule_type_" + this.mid + " as rule ON log.rtid = rule.id ");
            query.append(" LEFT JOIN user ON log.user_id = user.id ");
            query.append(" WHERE cid = ? AND gid = ? ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, cid);
            ps.setInt(2, gid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                RuleTypeLog log = this.getFromRS(rs);
                result.add(log);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    private RuleTypeLog getFromRS(ResultSet rs) throws SQLException {
        int id = rs.getInt("id");
        int rtid = rs.getInt("rtid");
        int userId = rs.getInt("user_id");
        int cid = rs.getInt("cid");
        int gid = rs.getInt("gid");
        Timestamp date = rs.getTimestamp("date");
        String ruleTitle = rs.getString("ruleTitle");
        String user = rs.getString("user");
        RuleTypeLog log = new RuleTypeLog();
        log.setId(id);
        log.setTypeId(rtid);
        log.setUserId(userId);
        log.setContractId(cid);
        log.setDate((Date)date);
        log.setRuleTypeName(ruleTitle);
        log.setUserName(user);
        log.setGateId(gid);
        return log;
    }

    public void addLog(RuleTypeLog log) throws BGException {
        try {
            StringBuffer query = new StringBuffer();
            query.append(" INSERT INTO " + this.tableName + "(rtid, user_id, cid, date, gid )");
            query.append(" VALUES(?, ?, ?, ?, ?)");
            PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
            int idx = 1;
            ps.setInt(idx++, log.getTypeId());
            ps.setInt(idx++, log.getUserId());
            ps.setInt(idx++, log.getContractId());
            ps.setTimestamp(idx++, TimeUtils.convertDateToTimestamp((Date)log.getDate()));
            ps.setInt(idx++, log.getGateId());
            ps.executeUpdate();
            log.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
    }
}

