/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.table.server.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.enums.ComponentType;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.table.common.dto.TableComponentDto;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfo;
import ru.bitel.common.Utils;

public class TableCache {
    private static Map<String, List<BGTableInfo>> tableCacheMap = null;

    public static List<BGTableInfo> getTableList(String componentId) {
        return TableCache.getTableCacheMap().get(componentId);
    }

    public static List<TableComponentDto> getTableComponentList() {
        ArrayList<TableComponentDto> componentDtos = new ArrayList<TableComponentDto>();
        TableComponentDto tableKernel = new TableComponentDto();
        tableKernel.setType("kernel");
        tableKernel.setComponentName("kernel");
        tableKernel.setComponentTitle("\u042f\u0434\u0440\u043e");
        tableKernel.setTableCount(TableCache.getTableCacheMap().get(tableKernel.getComponentName()).size());
        componentDtos.add(tableKernel);
        for (BGModule bGModule : ModuleCache.getInstance().getModulesList()) {
            BGInstalledModule bgInstalledModule = bGModule.getInstalledModule();
            List<BGTableInfo> datas = TableCache.getTableCacheMap().get(bgInstalledModule.getName());
            if (datas == null || datas.isEmpty()) continue;
            TableComponentDto dto = new TableComponentDto();
            dto.setType("module");
            dto.setComponentName(bgInstalledModule.getName());
            dto.setComponentTitle(bGModule.getGuiTitle());
            dto.setModuleId(bGModule.getId());
            dto.setTableCount(datas.size());
            componentDtos.add(dto);
        }
        for (Map.Entry entry : BGPluginManagerServer.getManager().getPluginsMap().entrySet()) {
            List<BGTableInfo> datas = TableCache.getTableCacheMap().get(entry.getKey());
            if (datas == null || datas.isEmpty()) continue;
            TableComponentDto dto = new TableComponentDto();
            dto.setType("plugin");
            dto.setComponentName((String)entry.getKey());
            dto.setComponentTitle(((BGPluginServer)entry.getValue()).getName());
            dto.setTableCount(datas.size());
            componentDtos.add(dto);
        }
        return componentDtos;
    }

    private static Map<String, List<BGTableInfo>> getTableCacheMap() {
        if (tableCacheMap == null) {
            HashMap<String, List<BGTableInfo>> map = new HashMap<String, List<BGTableInfo>>();
            TableCache.a("ru.bitel.bgbilling.kernel.table.server.table", "kernel", map);
            for (BGInstalledModule bGInstalledModule : ModuleCache.getInstance().getInstalledModulesList()) {
                if (bGInstalledModule.getType() != ComponentType.MODULE) continue;
                TableCache.a(bGInstalledModule.getPackageServer() + ".table", bGInstalledModule.getName(), map);
            }
            for (Map.Entry entry : BGPluginManagerServer.getManager().getPluginsMap().entrySet()) {
                TableCache.a(((BGPluginServer)entry.getValue()).getPackServer() + ".table", (String)entry.getKey(), map);
            }
            tableCacheMap = map;
        }
        return tableCacheMap;
    }

    private static void a(String packageName, String componentName, Map<String, List<BGTableInfo>> map) {
        for (Class clazz : Utils.getClassList((String)packageName)) {
            if (!BGTableInfo.class.isAssignableFrom(clazz)) continue;
            try {
                String componentId = componentName;
                BGTableInfo tableData = (BGTableInfo)Utils.newInstance((String)clazz.getName(), BGTableInfo.class);
                List<BGTableInfo> tableDatas = map.get(componentId);
                if (tableDatas == null) {
                    tableDatas = new ArrayList<BGTableInfo>();
                    map.put(componentId, tableDatas);
                }
                tableDatas.add(tableData);
            }
            catch (Exception ex) {
                LogManager.getLogger().error((Object)ex);
            }
        }
    }
}

