package ru.bitel.bgbilling.modules.tv.dyn.smarty;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;

public class SmartyErrorMessageDeserialize
    extends StdDeserializer<SmartyErorMessage>
{
    public SmartyErrorMessageDeserialize()
    {
        this( null );
    }

    public SmartyErrorMessageDeserialize( Class<?> vc )
    {
        super( vc );
    }

    @Override
    public SmartyErorMessage deserialize( JsonParser jsonParser, DeserializationContext context )
        throws IOException, JsonProcessingException
    {
        JsonNode node = jsonParser.getCodec().readTree( jsonParser );
        if ( node.isTextual() )
        {
            SmartyErorMessage erorMessage = new SmartyErorMessage();
            erorMessage.setErrorMessage( node.asText() );
            return erorMessage;
        }
        else
        {
            SmartyErorMessage erorMessage = new SmartyErorMessage();
            erorMessage.setErrorMessage( node.asText() );
            return erorMessage;
        }
    }
}
