/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.ipn.server.bean.Iface;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class IfaceManager {
    private Connection con;
    private String tableName;

    public IfaceManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "ipn_iface_" + mid;
    }

    public Map<Integer, List<Iface>> getSourceIfacesMap() {
        HashMap<Integer, List<Iface>> result = new HashMap<Integer, List<Iface>>();
        try {
            String query = "SELECT * FROM " + this.tableName + " ORDER BY source_id, title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int sourceId = rs.getInt("source_id");
                ArrayList<Iface> list = (ArrayList<Iface>)result.get(sourceId);
                if (list == null) {
                    list = new ArrayList<Iface>();
                    result.put(sourceId, list);
                }
                list.add(this.getIfaceFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<Iface> getSourceIfaceList(int sourceId) {
        ArrayList<Iface> result = new ArrayList<Iface>();
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE source_id=? ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, sourceId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getIfaceFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateIface(Iface iFace) throws BGException {
        try {
            String query = null;
            String message = null;
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT id FROM " + this.tableName + " WHERE source_id=" + iFace.getSourceId() + " AND number=" + iFace.getNumber() + " AND id!=" + iFace.getId());
            if (rs.next()) {
                message = "\u0422\u0430\u043a\u043e\u0439 \u043d\u043e\u043c\u0435\u0440 \u0432 \u044d\u0442\u043e\u043c \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0435 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442";
            }
            rs.close();
            st.close();
            if (message != null) {
                throw new BGException(message);
            }
            query = iFace.getId() <= 0 ? "INSERT INTO " + this.tableName + " SET number=?, title=?, zone_id=?, source_id=?" : "UPDATE " + this.tableName + " SET number=?, title=?, zone_id=? WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query, 1);
            ps.setInt(1, iFace.getNumber());
            ps.setString(2, iFace.getTitle());
            ps.setInt(3, iFace.getZoneId());
            ps.setInt(4, iFace.getId() <= 0 ? iFace.getSourceId() : iFace.getId());
            ps.executeUpdate();
            if (iFace.getId() <= 0) {
                iFace.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Iface getIface(int id) {
        Iface result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id=" + id;
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getIfaceFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Iface getIface(int sourceId, int number) {
        Iface result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE source_id=? AND number=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, sourceId);
            ps.setInt(2, number);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getIfaceFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void deleteIface(int id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Iface getIfaceFromRS(ResultSet rs) throws SQLException {
        Iface result = new Iface();
        result.setId(rs.getInt("id"));
        result.setNumber(rs.getInt("number"));
        result.setSourceId(rs.getInt("source_id"));
        result.setTitle(rs.getString("title"));
        result.setZoneId(rs.getInt("zone_id"));
        return result;
    }
}

