/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree.unused;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class TariffLinkTariffTreeNode
extends DefaultTariffTreeNode {
    private static ImageIcon icon = ClientUtils.getIcon((String)"link");
    private JLabel view;
    private Directory tariffDir;
    private int tariffTreeId;
    private String tariffTitle;
    private BGComboBox<IdTitle> tariffCombo;

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> nodes) {
        super.init(id, mtree, type, tree, config, parent, nodes);
        this.tariffDir = this.getDirManager().getDirectory("tariff");
    }

    @Override
    protected JPanel getEditorPanel() throws Exception {
        JPanel editor = new JPanel();
        this.tariffCombo = new BGComboBox();
        this.buildDirectoryCombo(this.tariffDir, (JComboBox<IdTitle>)this.tariffCombo);
        for (int i = 0; i < this.tariffCombo.getItemCount(); ++i) {
            IdTitle item = (IdTitle)this.tariffCombo.getItemAt(i);
            if (item.getId() != this.tree.getTreeId()) continue;
            this.tariffCombo.removeItemAt(i);
            break;
        }
        return editor;
    }

    @Override
    public Component getView() throws Exception {
        if (this.view == null) {
            this.view = new JLabel(icon, 2);
        }
        this.extractData();
        StringBuilder sb = new StringBuilder(40);
        sb.append("\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0442\u0430\u0440\u0438\u0444: ");
        sb.append(this.tariffTitle);
        this.view.setText(sb.toString());
        return this.view;
    }

    private void extractData() throws Exception {
        Map<String, String> data = this.getDataInHash();
        this.tariffTreeId = Utils.parseInt((String)data.get("tree_id"));
        this.tariffTitle = Utils.maskNull((String)this.tariffDir.getValue(this.tariffTreeId));
    }

    @Override
    protected void loadData() throws Exception {
        this.extractData();
        this.setDirectoryItemSelection((JComboBox<? extends IdTitle>)this.tariffCombo, this.tariffTreeId);
    }

    @Override
    protected void serializeData() {
        int treeId = this.getIdFromDirectoryCombo((JComboBox<? extends IdTitle>)this.tariffCombo);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("tree_id", String.valueOf(treeId));
        this.setDataInHash(data);
    }
}

