/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CompositeFuture<K>
implements Future<List<K>> {
    protected final List<Future<K>> list;

    public CompositeFuture(List<Future<K>> list) {
        this.list = list;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean result = true;
        for (Future<K> f : this.list) {
            result &= f.cancel(mayInterruptIfRunning);
        }
        return result;
    }

    @Override
    public boolean isCancelled() {
        boolean result = true;
        for (Future<K> f : this.list) {
            result &= f.isCancelled();
        }
        return result;
    }

    @Override
    public boolean isDone() {
        boolean result = true;
        for (Future<K> f : this.list) {
            result &= f.isDone();
        }
        return result;
    }

    @Override
    public List<K> get() throws InterruptedException, ExecutionException {
        ArrayList<K> result = new ArrayList<K>(this.list.size());
        for (Future<K> f : this.list) {
            K r = f.get();
            result.add(r);
        }
        return result;
    }

    @Override
    public List<K> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return CompositeFuture.get(this.list, timeout, unit);
    }

    public static <K> List<K> get(List<Future<K>> list, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long nanos = unit.toNanos(timeout);
        long lastTime = System.nanoTime();
        ArrayList<K> result = new ArrayList<K>(list.size());
        for (Future<K> f : list) {
            K r = f.get(nanos, TimeUnit.NANOSECONDS);
            result.add(r);
            long now = System.nanoTime();
            nanos -= now - lastTime;
            lastTime = now;
        }
        return result;
    }
}

