/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.bean;

import bsh.BshMethod;
import bsh.EvalError;
import bsh.Interpreter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptInstance;
import ru.bitel.bgbilling.modules.phone.common.bean.Gate;
import ru.bitel.bgbilling.modules.phone.common.bean.GateType;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class GateWorker
extends Thread {
    private Gate gate;
    private GateType gateType;
    private int mid;
    private Connection con;
    private final Logger log = LogManager.getLogger();
    private int cid;
    private int status;
    private StringBuffer resultLog = new StringBuffer();
    private String exceptions = "";

    public void init(Gate gate, Connection con, int mid, GateType gateType, int cid, int status) {
        this.gate = gate;
        this.gateType = gateType;
        this.con = con;
        this.mid = mid;
        this.cid = cid;
        this.status = status;
    }

    @Override
    public void run() {
        try {
            this.runScript();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void runScript() throws EvalError, IOException {
        Interpreter it = new Interpreter();
        it.getNameSpace().importCommands("/ru/bitel/bgbilling/kernel/script/server/bsh/commands");
        this.log.info("Running script ");
        it.set("con", (Object)this.con);
        it.set("gate", (Object)this.gate);
        it.set("log", (Object)this.log);
        it.set("mid", this.mid);
        it.set("cid", this.cid);
        it.set("status", this.status);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        StringBuilder warnings = new StringBuilder();
        StringWriter exceptions = new StringWriter();
        it.setOut(new PrintStream(out));
        it.setErr(new PrintStream(err));
        long time = System.currentTimeMillis();
        try {
            it.eval(this.gateType.getScript());
            BshMethod method = it.getNameSpace().getMethod("doSync", new Class[0]);
            if (method == null) {
                throw new BGMessageException("Method doSync was not found!");
            }
            method.invoke(new Object[0], it);
            ScriptInstance.DeprecatedCheker.checkOnDeprecated((Interpreter)it, (String)(this.gate.getHost() + ":" + this.gate.getPort() + "[" + this.gate.getComment() + "]"), (StringBuilder)warnings);
        }
        catch (Throwable ex) {
            this.log.error("Eval error: " + ex.getMessage(), ex);
            exceptions.append(ex.getMessage()).append("\n");
            ex.printStackTrace(new PrintWriter(exceptions));
        }
        long processTime = System.currentTimeMillis() - time;
        this.log.info("Process time => " + processTime);
        if (out.size() > 0) {
            this.log.info(out.toString());
        }
        if (err.size() > 0) {
            this.log.error(err.toString());
        }
        this.resultLog = new StringBuffer(out.toString().length() + err.toString().length() + 700);
        Date completeTime = new Date();
        this.resultLog.append("COMPLETE_TIME: ");
        this.resultLog.append(TimeUtils.format((Date)completeTime, (String)"dd.MM.yy HH:mm:ss"));
        this.resultLog.append("\nPROCESS_TIME: ");
        this.resultLog.append(processTime);
        this.resultLog.append("\n\nOUT:\n");
        this.resultLog.append(out);
        if (Utils.notBlankString((String)err.toString())) {
            this.resultLog.append("\n\nERROR:\n");
            this.resultLog.append(err.toString());
        }
        if (Utils.notBlankString((String)exceptions.toString())) {
            this.resultLog.append("\n\nEXCEPTIONS:\n");
            this.resultLog.append(exceptions.toString());
        }
        if (Utils.notBlankString((String)warnings.toString())) {
            this.resultLog.append("\n\nWARNINGS:\n");
            this.resultLog.append((CharSequence)warnings);
        }
        this.exceptions = exceptions.toString();
    }

    public StringBuffer getResultLog() {
        return this.resultLog;
    }

    public String getExceptions() {
        return this.exceptions;
    }
}

