/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rentsoft.server;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.rentsoft.common.RentsoftService;
import ru.bitel.bgbilling.modules.rentsoft.common.bean.RentsoftPayment;
import ru.bitel.bgbilling.modules.rentsoft.common.bean.RentsoftProduct;
import ru.bitel.bgbilling.modules.rentsoft.common.bean.SubscribtionStatus;
import ru.bitel.bgbilling.modules.rentsoft.server.bean.RentsoftPaymentManager;
import ru.bitel.bgbilling.modules.rentsoft.server.bean.RentsoftProductManager;
import ru.bitel.bgbilling.modules.rentsoft.server.bean.SubscribtionStatusManager;
import ru.bitel.common.model.Pair;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.rentsoft.common.RentsoftService")
public class RentsoftServiceImpl
extends AbstractService
implements RentsoftService {
    private RentsoftProductManager rentsoftProductManager;
    private RentsoftPaymentManager rentsoftPaymentManager;

    @PostConstruct
    private void init() {
        this.rentsoftProductManager = new RentsoftProductManager(this.getConnection(), this.moduleId);
        try {
            this.rentsoftPaymentManager = new RentsoftPaymentManager(this.getConnection(), this.moduleId);
        }
        catch (Exception ex) {
            throw new BGRuntimeException((Throwable)ex);
        }
    }

    public List<RentsoftProduct> getProductList() throws Exception {
        return this.rentsoftProductManager.getList();
    }

    public List<RentsoftPayment> getPaymentsByProduct(int productId, int contractId) throws Exception {
        return this.rentsoftPaymentManager.getPaymentList(productId, contractId);
    }

    public List<Pair<RentsoftProduct, SubscribtionStatus>> getSubscribtionStatuses(int contractId) throws Exception {
        ArrayList<Pair<RentsoftProduct, SubscribtionStatus>> result = new ArrayList<Pair<RentsoftProduct, SubscribtionStatus>>();
        SubscribtionStatusManager subscribtionStatusManager = new SubscribtionStatusManager(this.getConnection(), this.moduleId);
        for (SubscribtionStatus ss : subscribtionStatusManager.getList(contractId)) {
            result.add((Pair<RentsoftProduct, SubscribtionStatus>)new Pair((Object)((RentsoftProduct)this.rentsoftProductManager.get(ss.getProductId())), (Object)ss));
        }
        return result;
    }

    public void recalculate(int cid, Date date) throws Exception {
        this.rentsoftPaymentManager.recalculateUser(cid, date);
    }

    public static String md5(String s) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.reset();
            m.update(s.getBytes());
            byte[] digest = m.digest();
            BigInteger bigInt = new BigInteger(1, digest);
            Object hash = bigInt.toString(16);
            while (((String)hash).length() < 32) {
                hash = "0" + (String)hash;
            }
            return hash;
        }
        catch (Exception ex) {
            return "md5_error";
        }
    }

    public String source(int contractId, String rsUri) throws Exception {
        String apikey = this.getModuleSetup().get("rentsoft.secret", "undefined");
        String agName = this.getModuleSetup().get("rentsoft.ag_name", "undefined-in-properties");
        String rsSrc = RentsoftServiceImpl.getIframeSource(rsUri, agName, this.rentsoftPaymentManager.cidToUuid(contractId), apikey);
        return RentsoftServiceImpl.json(rsSrc);
    }

    private static String json(String s) {
        StringBuffer sb = new StringBuffer("\"");
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch == '&' || ch == '<' || ch == '>' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }

    private static String getIframeSource(String rsUri, String agName, String agUuid, String agSecret) {
        if (rsUri == null) {
            rsUri = "";
        }
        if (rsUri.length() > 0 && rsUri.charAt(0) == '/') {
            rsUri = rsUri.substring(1);
        }
        String rsSignedParams = "ag_uuid=" + agUuid + "&ag_timestamp=" + String.valueOf(System.currentTimeMillis() / 1000L) + "&ag_rnd=" + String.valueOf((int)(Math.random() * 1000000.0));
        rsSignedParams = rsSignedParams + "&ag_sign=" + RentsoftServiceImpl.md5(agSecret + rsSignedParams);
        String rsResponseUri = "/2.01/iframe/" + rsUri + (rsUri.indexOf("?") >= 0 ? "&" : "?") + rsSignedParams;
        String rsSrc = "https://" + agName + ".ag.rentsoft.ru" + rsResponseUri;
        return rsSrc;
    }
}

