/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.modules.tv.server.TvUtils;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.util.AbstractPeriodItemSet;
import ru.bitel.oss.systems.inventory.service.common.bean.Service;

public class ServiceRuntimeList
extends AbstractPeriodItemSet<ServiceItem> {
    private static final Logger logger = LogManager.getLogger();

    ServiceRuntimeList(List<ServiceItem> entryList) {
        super(ServiceItem.class, entryList);
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(160);
            sb.append("Create: \n");
            for (ServiceItem item : (ServiceItem[])this.entries) {
                item.toString(sb.append("\tService: ")).append("\n");
            }
            sb.setLength(sb.length() - 1);
            logger.debug(sb.toString());
        }
    }

    ServiceRuntimeList(ServiceItem[] entries) {
        super(ServiceItem.class, (AbstractPeriodItemSet.PeriodItem[])entries);
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(160);
            sb.append("Create: \n");
            for (ServiceItem item : entries) {
                item.toString(sb.append("\tService: ")).append("\n");
            }
            sb.setLength(sb.length() - 1);
            logger.debug(sb.toString());
        }
    }

    public List<ServiceItem> listEndingAt(long millis) {
        millis = millis / 1000L * 1000L + 999L;
        ArrayList<ServiceItem> result = new ArrayList<ServiceItem>();
        int size = ((ServiceItem[])this.entries).length;
        for (int i = 0; i < size; ++i) {
            ServiceItem item = ((ServiceItem[])this.entries)[i];
            if (item.timeTo != millis) continue;
            result.add(item);
        }
        return result;
    }

    public List<ServiceItem> listByProductId(int productId) {
        ArrayList<ServiceItem> result = new ArrayList<ServiceItem>();
        int size = ((ServiceItem[])this.entries).length;
        for (int i = 0; i < size; ++i) {
            ServiceItem item = ((ServiceItem[])this.entries)[i];
            if (item.id != productId) continue;
            result.add(item);
        }
        return result;
    }

    protected boolean containsMillis(ServiceItem item, long millis) {
        return item.timeFrom <= millis && (item.timeTo == 0L || millis <= item.timeTo);
    }

    protected boolean isCoincide(ServiceItem item, ServiceItem other) {
        return other.serviceId == item.serviceId && other.id == item.id;
    }

    public long getTimeFrom(int serviceId) {
        int size = ((ServiceItem[])this.entries).length;
        for (int i = 0; i < size; ++i) {
            ServiceItem item = ((ServiceItem[])this.entries)[i];
            if (serviceId != item.serviceId) continue;
            return item.timeFrom;
        }
        return 0L;
    }

    public Map<Integer, Integer> optionMap(long date1, long date2) {
        if (((ServiceItem[])this.entries).length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Integer> options = new HashMap<Integer, Integer>(4);
        long[] intersection = new long[2];
        int size = ((ServiceItem[])this.entries).length;
        for (int i = 0; i < size; ++i) {
            ServiceItem item = ((ServiceItem[])this.entries)[i];
            long[] period = RangeUtils.intersectionAnd((long[])intersection, (long)item.timeFrom, (long)item.timeTo, (long)date1, (long)date2);
            if (period == null) continue;
            options.put(item.id, item.serviceId);
        }
        if (options.size() > 0) {
            return options;
        }
        return Collections.emptyMap();
    }

    public ServiceItem itemByServiceId(int serviceId) {
        for (int i = ((ServiceItem[])this.entries).length - 1; i >= 0; --i) {
            ServiceItem item = ((ServiceItem[])this.entries)[i];
            if (item.serviceId != serviceId) continue;
            return item;
        }
        return null;
    }

    public static ServiceRuntimeList newInstance(List<Service> serviceList) {
        ArrayList<ServiceItem> result = new ArrayList<ServiceItem>();
        for (Service service : serviceList) {
            result.add(new ServiceItem(service.getProductId(), service.getServiceSpecId(), service.getId(), service.getTimeFrom(), service.getTimeTo()));
        }
        return new ServiceRuntimeList(result);
    }

    public ServiceItem[] items() {
        return (ServiceItem[])this.entries;
    }

    public ServiceRuntimeList update(int productId, List<Service> newServiceList) {
        int i;
        ArrayList<ServiceItem> result = new ArrayList<ServiceItem>();
        int size = ((ServiceItem[])this.entries).length;
        for (i = 0; i < size; ++i) {
            ServiceItem item = ((ServiceItem[])this.entries)[i];
            if (item.id != productId) continue;
            result.add(item);
        }
        if (newServiceList != null) {
            size = newServiceList.size();
            for (i = 0; i < size; ++i) {
                Service service = newServiceList.get(i);
                result.add(new ServiceItem(service.getProductId(), service.getServiceSpecId(), service.getId(), service.getTimeFrom(), service.getTimeTo()));
            }
        }
        return new ServiceRuntimeList(result.toArray(new ServiceItem[result.size()]));
    }

    public void updateState(int serviceId, short deviceState) {
        for (int i = ((ServiceItem[])this.entries).length - 1; i >= 0; --i) {
            ServiceItem item = ((ServiceItem[])this.entries)[i];
            if (item.serviceId != serviceId) continue;
            item.deviceState = deviceState;
        }
    }

    public static final class ServiceItem
    extends AbstractPeriodItemSet.PeriodItem
    implements Delayed {
        public final int serviceSpecId;
        public final int serviceId;
        public volatile short deviceState;
        public volatile int version;

        public ServiceItem(int productId, int serviceSpecId, int serviceId, Date timeFrom, Date timeTo) {
            this(productId, serviceSpecId, serviceId, timeFrom != null ? timeFrom.getTime() : 0L, timeTo != null ? timeTo.getTime() : 0L);
        }

        public ServiceItem(int productId, int serviceSpecId, int serviceId, long timeFrom, long timeTo) {
            super(productId, timeFrom / 1000L * 1000L, timeTo != 0L ? timeTo / 1000L * 1000L + 999L : 0L);
            this.serviceSpecId = serviceSpecId;
            this.serviceId = serviceId;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            assert (this.timeTo != 0L);
            return unit.convert(this.timeTo - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            ServiceItem x = (ServiceItem)other;
            long diff = this.timeTo - x.timeTo;
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }

        public Service toService(int contractId, int accountId) {
            Service result = new Service();
            result.setId(this.serviceId);
            result.setContractId(contractId);
            result.setAccountId(accountId);
            result.setProductId(this.id);
            result.setServiceSpecId(this.serviceSpecId);
            result.setTimeFrom(TvUtils.toDate(this.timeFrom));
            result.setTimeTo(TvUtils.toDate(this.timeTo));
            result.setDeviceState(this.deviceState);
            return result;
        }

        public StringBuilder toString(StringBuilder sb) {
            return sb.append(this.id).append(": ").append(this.timeFrom == 0L ? "null" : TimeUtils.format((Date)new Date(this.timeFrom), (String)"dd.MM.yyyy HH:mm:ss.S")).append(" - ").append(this.timeTo == 0L ? "null" : TimeUtils.format((Date)new Date(this.timeTo), (String)"dd.MM.yyyy HH:mm:ss.S"));
        }
    }
}

