/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.common.bean.AlarmErrorMessage;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ChargeType;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ChargeService;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProduct;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOption;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOptionType;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonProduct;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonApiClient;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonKassaApiClient;
import ru.bitel.bgbilling.modules.npay.common.bean.ServiceObject;
import ru.bitel.bgbilling.modules.npay.common.service.NPayService;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class MegafonUtils {
    private static final Logger log = LogManager.getLogger();

    public static void addPaymentForActivateOption(ServerContext context, ModuleSetup moduleSetup, MegafonApiClient apiClient, MegafonOption option, MegafonContractProduct contractProduct) {
        BigDecimal price = option.getOptionType().equals((Object)MegafonOptionType.PROLONGATE) ? MegafonUtils.defineCorrectProductPrice(option.getPrice()) : option.getPrice();
        MegafonUtils.addPaymentForActivate(context, moduleSetup, apiClient, contractProduct, price, option.getProductOfferingId());
    }

    public static void addPaymentForActivateProduct(ServerContext context, ModuleSetup moduleSetup, MegafonApiClient megafonClient, MegafonProduct product, MegafonContractProduct contractProduct) {
        MegafonUtils.addPaymentForActivate(context, moduleSetup, megafonClient, contractProduct, MegafonUtils.defineCorrectProductPrice(BigDecimal.valueOf(product.getPrice())), product.getProductOfferingId());
    }

    public static void addPaymentForActivate(ServerContext context, ModuleSetup moduleSetup, MegafonApiClient megafonClient, MegafonContractProduct contractProduct, BigDecimal price, String productOfferingId) {
        String msisdn = MegafonUtils.defineCorrectMSISDN(contractProduct);
        log.debug("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0431\u0430\u043b\u0430\u043d\u0441\u0430 MSISDN={}", (Object)msisdn);
        BigDecimal currentBalance = new BigDecimal(Utils.maskBlank((String)megafonClient.getCustomersInfo(msisdn).optString("currentBalance"), (String)"0"));
        log.debug("MSISDN={}, \u0411\u0430\u043b\u0430\u043d\u0441 \u0432 \u041c\u0435\u0433\u0430\u0444\u043e\u043d\u0435={}, \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430={}", (Object)msisdn, (Object)currentBalance, (Object)price);
        if (currentBalance.compareTo(price) <= 0) {
            BigDecimal diff = price.subtract(currentBalance);
            log.debug("\u041d\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0435 msisdn={} \u043d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 productOfferingId={} \u0432 \u0440\u0430\u0437\u043c\u0435\u0440\u0435 = {}", (Object)msisdn, (Object)productOfferingId, (Object)diff);
            MegafonKassaApiClient kassaApiClient = new MegafonKassaApiClient(context.getModuleId());
            kassaApiClient.addPayment(contractProduct.getContractId(), msisdn, diff, "");
            MegafonUtils.contractAddCharge(context, moduleSetup, contractProduct.getContractId(), diff, String.format("\u041f\u0435\u0440\u0435\u0432\u043e\u0434 \u0437\u0430 msisdn=%s, productOfferingId=%s, productId=%s", msisdn, productOfferingId, contractProduct.getProductId()));
        }
    }

    public static String defineCorrectMSISDN(MegafonContractProduct contractProduct) {
        return Utils.isBlankString((String)contractProduct.getAdditionalMsisdn()) ? contractProduct.getMsisdn() : contractProduct.getAdditionalMsisdn();
    }

    private static BigDecimal defineCorrectProductPrice(BigDecimal productPrice) {
        LocalDate now = LocalDate.now();
        int dayOfMonth = now.getDayOfMonth();
        if (dayOfMonth == 1) {
            return productPrice;
        }
        int remainingDays = now.lengthOfMonth() - dayOfMonth + 1;
        return productPrice.divide(BigDecimal.valueOf(30L), 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(remainingDays));
    }

    public static void sendAlarm(String header, String msg) {
        long millis = System.currentTimeMillis();
        String key = "Megafon_" + header;
        if (AlarmSender.needAlarmSend((String)key, (long)millis, (long)10000L)) {
            AlarmSender.sendAlarm((AlarmErrorMessage)new AlarmErrorMessage(key, header, msg), (long)millis);
        }
    }

    public static void npayServiceAdd(ModuleSetup moduleSetup, ServerContext context, int npayServiceId, IdTitle productOrOption, MegafonContractProduct megafonContractProduct) throws Exception {
        NPayService npayService = (NPayService)context.getService(NPayService.class, MegafonUtils.getNpayMidOrThrow(moduleSetup));
        Service service = MegafonUtils.getNpayServiceOrThrow(moduleSetup, npayServiceId);
        ServiceObject serviceObject = npayService.serviceObjectList(megafonContractProduct.getContractId(), -1, -1, -1, true, new Date()).stream().filter(so -> so.getServiceId() == service.getId()).findAny().orElse(null);
        if (serviceObject == null) {
            serviceObject = new ServiceObject();
            serviceObject.setServiceId(service.getId());
            serviceObject.setContractId(megafonContractProduct.getContractId());
            serviceObject.setCol(BigDecimal.ONE);
            serviceObject.setDate1(TimeUtils.convertLocalDateTimeToDate((LocalDateTime)megafonContractProduct.getStartTime()));
            serviceObject.setDate2(megafonContractProduct.getEndTime() != null ? TimeUtils.convertLocalDateTimeToDate((LocalDateTime)megafonContractProduct.getEndTime()) : null);
            serviceObject.setComment(String.format("\u041c\u0435\u0433\u0430\u0444\u043e\u043d. \u041f\u0440\u043e\u0434\u0443\u043a\u0442: ID=%s, \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435=%s", productOrOption.getId(), productOrOption.getTitle()));
        }
        log.debug("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0430\u0431\u043e\u043d.\u043f\u043b\u0430\u0442\u044b. cid={}, serviceId={}", (Object)megafonContractProduct.getContractId(), (Object)service.getId());
        npayService.serviceObjectUpdate(megafonContractProduct.getContractId(), serviceObject);
    }

    public static void removeNpayService(ModuleSetup moduleSetup, ServerContext context, int npayServiceId, IdTitle productOrOption, MegafonContractProduct megafonContractProduct) throws Exception {
        int npayMid = MegafonUtils.getNpayMidOrThrow(moduleSetup);
        NPayService npayService = (NPayService)context.getService(NPayService.class, npayMid);
        List serviceObjectList = npayService.serviceObjectList(megafonContractProduct.getContractId(), -1, npayMid, -1, false, null);
        ServiceObject serviceObject = serviceObjectList.stream().filter(so -> so.getServiceId() == npayServiceId).findFirst().orElseThrow(() -> new RuntimeException(String.format("\u041d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 cid=%s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0430 \u0441 serviceId=%s", megafonContractProduct.getContractId(), npayServiceId)));
        log.debug("\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430, \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438 \u041c\u0435\u0433\u0430\u0444\u043e\u043d, \u0441\u043c\u0435\u043d\u0430 \u0442\u0430\u0440\u0438\u0444\u0430 \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430. cid={}, productId={}, serviceId={}", (Object)megafonContractProduct.getContractId(), (Object)productOrOption.getId(), (Object)npayServiceId);
        LocalDateTime now = LocalDateTime.now();
        serviceObject.setDate2(TimeUtils.convertLocalDateTimeToDate((LocalDateTime)now));
        npayService.serviceObjectUpdate(megafonContractProduct.getContractId(), serviceObject);
    }

    private static Service getNpayServiceOrThrow(ModuleSetup setup, int npayServiceId) throws Exception {
        return ModuleCache.getInstance().getModuleServicesList(MegafonUtils.getNpayMidOrThrow(setup)).stream().filter(s -> s.getId() == npayServiceId).findFirst().orElseThrow();
    }

    public static int getNpayMidOrThrow(ModuleSetup moduleSetup) throws BGException {
        int npayMid = moduleSetup.getInt("npay.mid", -1);
        if (npayMid > 0) {
            return npayMid;
        }
        for (BGModule module : ModuleCache.getInstance().getModulesList()) {
            if (!"npay".equals(module.getName())) continue;
            npayMid = module.getId();
        }
        if (npayMid <= 0) {
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043c\u043e\u0434\u0443\u043b\u044c Npay");
        }
        return npayMid;
    }

    public static void contractAddCharge(ServerContext context, ModuleSetup moduleSetup, int contractId, BigDecimal summa, String msg) {
        try {
            ChargeService chargeService = (ChargeService)context.getService(ChargeService.class, 0);
            int chargeTypeId = Utils.parseInt((String)moduleSetup.get("chargeType"), (int)0);
            if (chargeTypeId <= 0) {
                chargeTypeId = MegafonUtils.createMegafonChargeType(chargeService);
                moduleSetup.set("chargeType", String.valueOf(chargeTypeId));
            }
            Charge charge = new Charge();
            charge.setContractId(contractId);
            charge.setSum(summa);
            charge.setUserId(0);
            charge.setTypeId(chargeTypeId);
            charge.setComment(msg);
            charge.setDate(new Date());
            charge.setTimeChange(new Date());
            chargeService.chargeUpdate(charge);
            context.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static int createMegafonChargeType(ChargeService chargeService) throws Exception {
        ChargeType type = new ChargeType();
        type.setTitle("\u041c\u0435\u0433\u0430\u0444\u043e\u043d");
        type.setType(0);
        type.setEditable(true);
        type.setPayback(false);
        return chargeService.chargeTypeUpdate(type);
    }
}

