/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.services;

import bitel.billing.module.common.BGControlPanelStringInput;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.plaf.ListUI;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.IdTitle;

public abstract class ServiceModuleDirectories
extends ServiceConfigTabbedPanel {
    private Directory _selectedDir;
    private int editMode = -1;
    private int currentFindPos = -1;
    JComboBox<Directory> directoriesCombo = new JComboBox();
    BGControlPanelStringInput editor = new BGControlPanelStringInput();
    BGUList<IdTitle> dir = new BGUList();
    JTextField findText_TF = new JTextField(30);

    public ServiceModuleDirectories() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.directoriesCombo.addActionListener(e -> {
            this._selectedDir = (Directory)this.directoriesCombo.getSelectedItem();
            this.loadDirData();
        });
        this.dir.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ServiceModuleDirectories.this.editItem();
                }
            }
        });
        this.editor.setVisible(false);
        this.editor.setActionListener(e -> this.editorAction(e));
        ClientUtils.addShowCodeListener(this.dir);
    }

    private void jbInit() throws Exception {
        this.editor.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.findText_TF.setHorizontalAlignment(0);
        JButton findButton = new JButton();
        findButton.setText("\u041d\u0430\u0439\u0442\u0438");
        findButton.addActionListener(e -> {
            this.currentFindPos = -1;
            this.find();
        });
        JButton findMore = new JButton();
        findMore.setText("\u041d\u0430\u0439\u0442\u0438 \u0434\u0430\u043b\u0435\u0435");
        findMore.addActionListener(e -> this.find());
        JPanel jPanel1 = new JPanel(new GridBagLayout());
        jPanel1.setBorder(new BGTitleBorder(" \u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a "));
        jPanel1.add(this.directoriesCombo, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new BGTitleBorder(" \u041f\u043e\u0438\u0441\u043a "));
        jPanel2.add((Component)this.findText_TF, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        jPanel2.add((Component)findButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        jPanel2.add((Component)findMore, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)jPanel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)jPanel2, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 3, new Insets(0, 5, 5, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)panel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JScrollPane(this.dir), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void deleteItem() {
        IdTitle di = (IdTitle)this.dir.getSelectedValue();
        if (di != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            try {
                this._selectedDir.removeValue(di.getId());
                this.loadDirData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    @Override
    public void editItem() {
        IdTitle di = (IdTitle)this.dir.getSelectedValue();
        if (di != null) {
            this.editMode = 1;
            this.editor.setValue(di.getTitle());
            this.editor.setVisible(true);
        }
    }

    @Override
    public void newItem() {
        this.editMode = 0;
        this.editor.setVisible(true);
    }

    @Override
    public void setData() {
        this.addDirs(this.directoriesCombo);
    }

    private void loadDirData() {
        if (this._selectedDir != null) {
            try {
                this.dir.setData(this._selectedDir.getItems());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    private void editorAction(ActionEvent e) {
        String text = this.editor.getValue();
        IdTitle di = (IdTitle)this.dir.getSelectedValue();
        try {
            if (di != null && this.editMode == 1) {
                this._selectedDir.renameValue(di.getId(), text);
            } else if (this.editMode == 0) {
                this._selectedDir.addValue(text);
            }
            this.loadDirData();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    protected abstract void addDirs(JComboBox<Directory> var1);

    public void find() {
        int size = ((DefaultListModel)this.dir.getModel()).getSize();
        String findStr = this.findText_TF.getText().trim().toLowerCase();
        IdTitle item = null;
        ListUI ui = this.dir.getUI();
        if (findStr.length() > 0 && size > 0) {
            for (int i = this.currentFindPos + 1; i < size; ++i) {
                this.currentFindPos = i;
                item = (IdTitle)((DefaultListModel)this.dir.getModel()).getElementAt(i);
                if (item.getTitle().toLowerCase().indexOf(findStr) < 0) continue;
                this.dir.setSelectedIndex(i);
                this.dir.scrollRectToVisible(ui.getCellBounds(this.dir, i, i));
                break;
            }
        }
    }
}

