/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.vepay.server.action.web;

import bitel.billing.server.contract.bean.Contract;
import java.math.BigDecimal;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.Date;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.ContractAutopaymentManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.vepay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.vepay.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.vepay.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.vepay.server.bean.Constants;
import ru.bitel.bgbilling.modules.vepay.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.vepay.server.event.VepaySumEvent;
import ru.bitel.common.Preferences;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebAction(title="Vepay")
public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("vepay");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        boolean fiscalization = this.moduleSetup.getBoolean("vepay.fiscalization.enable", false);
        String gateUrl = fiscalization ? this.moduleSetup.get("vepay.fiscalization.url.gate", "https://fpay.vepay.ru/v2/") : this.moduleSetup.get("vepay.url.gate", "https://test.vepay.online");
        this.setResultParam("gateUrl", gateUrl + "pay");
        this.paymentForm(this.moduleName, Constants.class, AutopaymentManager.class);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        SearchParam searchParam = SearchParam.builder().setContractId(this.contractId).setStatus(this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL)).build();
        SearchResult searchResult = new SearchResult(this.getPage(), new String[]{"createDate:1", "transactionDate:1"});
        new TransactionManager(this.con, this.moduleId).searchTransaction(searchResult, searchParam);
        this.setResultParam("transactions", searchResult.getList());
        this.requestDispatcher("include", "payment_transactions");
    }

    public void success() throws Exception {
        this.execute();
    }

    public void fail() throws Exception {
        this.execute();
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        VepaySumEvent event = new VepaySumEvent(this.moduleId, this.contractId, this.sum);
        BigDecimal newSum = ((VepaySumEvent)EventProcessor.getInstance().request((QueueEvent)event)).getSum();
        if (newSum != null) {
            this.sum = newSum;
        }
        this.doRedirect(this.sum, 0);
    }

    @WebOperation(title="\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436")
    public void autopayment() throws Exception {
        int mode;
        super.autopayment();
        boolean autopaymentEnable = this.moduleSetup.getBoolean("vepay.autopayment.enable", false);
        if (autopaymentEnable && ContractAutopaymentManager.isContractAutopaymentEnabled((Connection)this.con, (int)this.moduleId, (int)this.contractId) && (mode = this.req.getInt("mode", 0)) > -1 && mode < 4) {
            Preferences modeDataMap;
            ContractUtils.saveCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("customerAddress"));
            AutopaymentManager autopaymentManager = new AutopaymentManager(this.con, this.moduleId);
            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(this.contractId);
            if (autopayment != null) {
                if (autopayment.getMode() != AutopaymentMode.OFF) {
                    autopaymentManager.autopaymentOff(autopayment);
                }
                if (mode != autopayment.getMode().getCode()) {
                    autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                    autopaymentManager.updateAutopayment(autopayment);
                    autopayment = null;
                }
            }
            if (autopayment == null) {
                autopayment = Autopayment.builder().setContractId(this.contractId).setModeData("").build();
            }
            Preferences preferences = modeDataMap = autopayment.getModeData() != null ? new Preferences(autopayment.getModeData(), "\n") : new Preferences();
            if (mode == AutopaymentMode.OFF.getCode()) {
                autopayment.setMode(AutopaymentMode.OFF);
                autopayment.setSum(BigDecimal.ZERO);
                autopayment.setPeriod(new PeriodWithTime(LocalDateTime.now(), null));
                autopayment.setAccessToken(null);
            } else if (mode == AutopaymentMode.WEEK.getCode()) {
                this.autopaymentWeek("VEPAY", modeDataMap, autopayment, Constants.class);
            } else if (mode == AutopaymentMode.MONTH.getCode()) {
                this.autopaymentMonth("VEPAY", modeDataMap, autopayment, Constants.class);
            } else if (mode == AutopaymentMode.AUTO.getCode()) {
                this.autopaymentAuto("VEPAY", modeDataMap, autopayment, Constants.class);
            }
            this.setResultParam("mode", autopayment.getMode().getCode());
            autopaymentManager.updateAutopayment(autopayment);
            if (autopayment.getMode().getCode() != AutopaymentMode.OFF.getCode()) {
                this.doRedirect(autopayment.getSum(), autopayment.getId());
            }
            autopayment.setModeData(modeDataMap.toString());
            autopaymentManager.updateAutopayment(autopayment);
            if (autopayment.getMode().getCode() == AutopaymentMode.OFF.getCode()) {
                this.execute();
            }
        }
    }

    private void doRedirect(BigDecimal sum, int autopaymentId) throws Exception {
        TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
        String description = "";
        Contract contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
        description = this.moduleSetup.get("vepay.comment", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle());
        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setSum(sum)).setContractId(this.contractId)).setCreateDate(new Date())).setParameters(autopaymentId > 0 ? "autopaymentId=" + autopaymentId : null)).build();
        transactionManager.update(transaction);
        String redirectUrl = transactionManager.doPaymentRequest(transaction, sum, description, this.moduleSetup.get("vepay.url.success", ""), this.moduleSetup.get("vepay.url.fail", ""), autopaymentId > 0);
        if (redirectUrl != null) {
            this.context.getResponse().sendRedirect(redirectUrl);
            return;
        }
    }
}

