/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event.publish.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.event.publish.common.bean.MQEvent;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class MQEventDao
extends AbstractIdDao<MQEvent> {
    public MQEventDao(Connection con) {
        super(con, 0, "publish_event");
    }

    public SearchResult<MQEvent> searchMQEventList(Page page) throws SQLException {
        SearchResult<MQEvent> searchResult = new SearchResult<MQEvent>(page);
        searchResult.setList(this.list("", "title", new Object[0]));
        return searchResult;
    }

    @Override
    protected MQEvent getFromRS(ResultSet rs) throws SQLException {
        MQEvent mqEvent = new MQEvent();
        mqEvent.setId(rs.getInt("id"));
        mqEvent.setTitle(rs.getString("title"));
        String data = rs.getString("data");
        if (data == null || data.isEmpty()) {
            data = "{}";
        }
        mqEvent.setData(data);
        return mqEvent;
    }

    @Override
    protected void updateImpl(MQEvent mqEvent) throws SQLException {
        Objects.requireNonNull(mqEvent);
        boolean update = mqEvent.getId() > 0;
        String query = this.sqlCommandAndTable(update) + " SET title=?, data=?" + this.sqlWhereId(update);
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, mqEvent.getTitle());
            ps.setString(index++, mqEvent.toJson().toString());
            this.executeUpdate(mqEvent, index, ps);
        }
    }
}

