/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.ipn.common.CiscoRuleOptions;
import ru.bitel.bgbilling.modules.ipn.server.GateWorker;
import ru.bitel.bgbilling.modules.ipn.server.ManadGateWorker;
import ru.bitel.bgbilling.modules.ipn.server.UserStatus;
import ru.bitel.bgbilling.modules.ipn.server.bean.AclOptions;
import ru.bitel.bgbilling.server.util.ssh.SSHSession;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class CiscoGateWorker
extends GateWorker {
    private int gid;
    private Map<Integer, AclOptions> aclMap;
    private Map<String, AclOptions> aclByNameMap;
    private static final Pattern accessPattern = Pattern.compile("access list\\s+([\\w\\-]+)");
    private static final Pattern rulePattern = Pattern.compile("^(\\d+)\\s+((permit)|(deny))");

    @Override
    protected void doSync() {
        String host = this.gate.getHost();
        int port = this.gate.getPort();
        this.gid = this.gate.getId();
        Preferences gateSetup = new Preferences(this.gate.getConfig(), "\r\n");
        String login = gateSetup.get("login", "root");
        String pswd = this.gate.getKeyword();
        int timeout = gateSetup.getInt("timeout", 0);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.gid + " gate: " + host + ":" + port + " login: " + login + " pswd: " + pswd);
        }
        SSHSession session = null;
        try {
            session = new SSHSession(host, port, login, pswd);
            session.setTimeout(timeout);
            session.connect();
            session.doCommand("terminal length 0");
            StringBuffer result = new StringBuffer();
            String list = session.doCommand("show access-list");
            result.append(list);
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.gid + " AccessList taking..");
                this.log.debug((CharSequence)result);
            }
            this.aclMap = AclOptions.getAclMapById(gateSetup);
            this.aclByNameMap = new HashMap<String, AclOptions>();
            for (AclOptions option : this.aclMap.values()) {
                this.aclByNameMap.put(option.name, option);
            }
            result.append(session.doCommand("configure terminal"));
            this.markOpenFromRules(list);
            this.buildCommandsLists();
            for (AclOptions options : this.aclMap.values()) {
                if (options.commands.size() <= 0) continue;
                result.append(session.doCommand("ip access-list extended " + options.name));
                if (this.log.isDebugEnabled()) {
                    this.log.debug(this.gid + " ACL " + options.name);
                }
                for (String command : options.commands) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(this.gid + " " + command);
                    }
                    result.append(session.doCommand(command));
                }
            }
            result.append(session.doCommand("end"));
            session.doCommandAsync("exit");
            if (this.log.isDebugEnabled()) {
                this.log.debug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                this.log.debug(result.toString());
                this.log.debug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            }
            CiscoGateWorker.sleep(100L);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                try {
                    session.disconnect();
                }
                catch (BGException e) {
                    this.log.error((Object)e);
                }
            }
        }
    }

    private void buildCommandsLists() {
        for (UserStatus status : this.statusList) {
            CiscoRuleOptions ruleOptions = CiscoRuleOptions.extractParams((String)status.rule.getRuleText());
            AclOptions options = this.aclMap.get(ruleOptions.aclId);
            if (options == null) {
                this.gateErrors.append("\u0414\u043e\u0433\u043e\u0432\u043e\u0440(id = " + status.contractId + "):acl \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u043e!!!!!!!!!!");
                continue;
            }
            boolean flag = false;
            if (options.openRulesFrom.containsKey(ruleOptions.fromPos)) {
                Set<Integer> rules;
                if (status.status > 0 && options != null && (rules = options.openRulesFrom.get(ruleOptions.fromPos)) != null) {
                    for (int rule : rules) {
                        options.commands.add("no " + rule);
                    }
                }
                flag = true;
                options.openRulesFrom.remove(ruleOptions.fromPos);
            }
            if (flag || status.status != 0) continue;
            String rule = CiscoRuleOptions.clearFromParams((String)status.rule.getRuleText());
            AclOptions acl = this.aclMap.get(ruleOptions.aclId);
            if (acl == null) continue;
            if (status.ruleType != null) {
                rule = ManadGateWorker.generateRule(rule, this.gateType, status.ruleType);
            }
            int rulePos = ruleOptions.fromPos;
            StringTokenizer st = new StringTokenizer(rule, "\r\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken().trim();
                acl.commands.add(rulePos++ + " " + line);
            }
        }
    }

    private void markOpenFromRules(String result) {
        String line = null;
        AclOptions currentAclOptions = null;
        StringTokenizer st = new StringTokenizer(result, "\r\n");
        while (st.hasMoreTokens()) {
            line = st.nextToken().trim();
            Matcher m = accessPattern.matcher(line);
            if (m.find()) {
                String currentAcl = m.group(1);
                currentAclOptions = this.aclByNameMap.get(currentAcl);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug(this.gid + " ACL " + currentAcl + " not in billing control..");
                continue;
            }
            if (currentAclOptions == null || !(m = rulePattern.matcher(line)).find()) continue;
            int rule = Utils.parseInt((String)m.group(1));
            if (rule < currentAclOptions.fromPos || rule > currentAclOptions.toPos) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug(this.gid + " Skip rule " + line);
                continue;
            }
            int ruleFrom = (rule - currentAclOptions.fromPos) / currentAclOptions.onContact * currentAclOptions.onContact + currentAclOptions.fromPos;
            Set<Integer> rules = currentAclOptions.openRulesFrom.get(ruleFrom);
            if (rules == null) {
                rules = new HashSet<Integer>();
                currentAclOptions.openRulesFrom.put(ruleFrom, rules);
            }
            rules.add(rule);
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug(this.gid + " Contact open from rule: " + ruleFrom);
        }
    }
}

