/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.vlan;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.modules.ipn.common.bean.CiscoRule;
import ru.bitel.bgbilling.modules.ipn.server.UserStatus;
import ru.bitel.bgbilling.modules.ipn.server.bean.VlanManager;
import ru.bitel.bgbilling.modules.ipn.server.dlink.UserPortStatus;
import ru.bitel.bgbilling.modules.ipn.server.vlan.CiscoVlanGateWorker;
import ru.bitel.common.Utils;

public class CiscoVlanParentGateWorker
extends CiscoVlanGateWorker
implements UserPortStatus.UserPortStatusParser {
    @Override
    protected String getRuleText(UserStatus status) {
        CiscoRule ciscoRule = new CiscoRule(status.rule.getRuleText());
        return ciscoRule.getAddresses();
    }

    @Override
    public List<UserPortStatus> getUserList(List<UserStatus> statusList) {
        ArrayList<UserPortStatus> userList = new ArrayList<UserPortStatus>();
        VlanManager vLanManager = new VlanManager(this.mid, this.con);
        for (UserStatus status : statusList) {
            CiscoRule ciscoRule = new CiscoRule(status.rule.getRuleText());
            String rule = ciscoRule.getPorts();
            StringTokenizer st = new StringTokenizer(rule, ";");
            while (st.hasMoreTokens()) {
                UserPortStatus portStatus;
                String token = st.nextToken().trim();
                String[] data = token.split(":");
                if (data.length == 2) {
                    portStatus = new UserPortStatus();
                    portStatus.ipAddr = Utils.bytesToString((byte[])Utils.convertIntToBytes((int)IPUtils.convertStringIPtoInt((String)data[0])));
                    portStatus.port = vLanManager.getVlan(this.gate.getId(), status.contractId);
                    portStatus.status = status;
                    userList.add(portStatus);
                    continue;
                }
                if (data.length != 3) continue;
                portStatus = new UserPortStatus();
                portStatus.ipAddr = Utils.bytesToString((byte[])Utils.convertIntToBytes((int)IPUtils.convertStringIPtoInt((String)data[0])));
                portStatus.port = vLanManager.getVlan(this.gate.getId(), status.contractId);
                portStatus.macAddr = data[2].toUpperCase().replaceAll("\\-", " ");
                portStatus.status = status;
                userList.add(portStatus);
            }
        }
        return userList;
    }
}

