/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.collector;

import bitel.billing.server.netflow.ipn.NetFlowSetup;
import bitel.billing.server.netflow.ipn.SourceSelector;
import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLogger;
import ru.bitel.bgbilling.kernel.network.flow.FlowListener;
import ru.bitel.bgbilling.kernel.network.flow.FlowPacket;
import ru.bitel.bgbilling.kernel.network.flow.NetFlowArray;
import ru.bitel.bgbilling.kernel.network.flow.SFlowArray;
import ru.bitel.bgbilling.modules.ipn.server.collector.FlowListenerWorker;
import ru.bitel.bgbilling.modules.ipn.server.collector.FlowListenerWorkerContext;
import ru.bitel.bgbilling.modules.ipn.server.collector.FlowListenerWorkerNetFlow;
import ru.bitel.bgbilling.modules.ipn.server.collector.FlowListenerWorkerSFlow;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerTask;

public class IPNFlowListener
extends FlowListener {
    protected final NetFlowSetup setup;
    protected final SourceSelector ss;
    protected final ExecutorService executorService;
    private int packetCount = 0;
    final IPHourlyDataLogger dataLog;

    IPNFlowListener(NetFlowSetup setup, int port, int threadCount, int byteBufferCapacity, int socketRCVBUF, SourceSelector ss, IPHourlyDataLogger hourDataLog, ThreadContextFactory<FlowListenerWorkerContext> contextFactory) {
        super(port, byteBufferCapacity, socketRCVBUF, "flowListener");
        this.setup = setup;
        this.ss = ss;
        this.dataLog = hourDataLog;
        this.executorService = WorkerTask.newFixedThreadPool((String)"flow", null, contextFactory, (int)threadCount);
    }

    public void flush(long millis, List<FlowPacket> packetList) {
        assert (packetList instanceof RandomAccess);
        this.packetCount += packetList.size();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        ThreadPoolExecutor pool = (ThreadPoolExecutor)this.executorService;
        if (pool != null) {
            result.append("queue_size: ");
            result.append(pool.getQueue().size());
            result.append("; threads_active: ");
            result.append(pool.getActiveCount());
            result.append("; largest: ");
            result.append(pool.getLargestPoolSize());
            result.append("; core: ");
            result.append(pool.getCorePoolSize());
            result.append("; pool_size: ");
            result.append(pool.getPoolSize());
            result.append("; ");
        }
        result.append(super.toString());
        result.append("; packets: ").append(this.packetCount);
        return result.toString();
    }

    public static IPNFlowListener newInstance(NetFlowSetup setup, int port, int threadCount, int byteBufferCapacity, int socketRCVBUF, final SourceSelector ss, final IPHourlyDataLogger hourDataLog, Integer sourceType, String sources) {
        ThreadContextFactory<FlowListenerWorkerContext> contextFactory = new ThreadContextFactory<FlowListenerWorkerContext>(){

            public FlowListenerWorkerContext newThreadContext() {
                FlowListenerWorkerContext result = new FlowListenerWorkerContext(false, ss, hourDataLog, new NetFlowArray(512), new SFlowArray(512));
                return result;
            }
        };
        if (sourceType == null) {
            return new IPNFlowListener(setup, port, threadCount, byteBufferCapacity, socketRCVBUF, ss, hourDataLog, (ThreadContextFactory)contextFactory){

                @Override
                public void flush(long millis, List<FlowPacket> packetList) {
                    super.flush(millis, packetList);
                    this.executorService.execute((Runnable)((Object)new FlowListenerWorker(packetList)));
                }
            };
        }
        switch (sourceType) {
            case 3: {
                return new IPNFlowListener(setup, port, threadCount, byteBufferCapacity, socketRCVBUF, ss, hourDataLog, (ThreadContextFactory)contextFactory){

                    @Override
                    public void flush(long millis, List<FlowPacket> packetList) {
                        super.flush(millis, packetList);
                        this.executorService.execute((Runnable)((Object)new FlowListenerWorkerNetFlow(packetList)));
                    }
                };
            }
            case 4: {
                return new IPNFlowListener(setup, port, threadCount, byteBufferCapacity, socketRCVBUF, ss, hourDataLog, (ThreadContextFactory)contextFactory){

                    @Override
                    public void flush(long millis, List<FlowPacket> packetList) {
                        super.flush(millis, packetList);
                        this.executorService.execute((Runnable)((Object)new FlowListenerWorkerSFlow(packetList)));
                    }
                };
            }
        }
        throw new IllegalArgumentException(String.valueOf(sourceType));
    }
}

