/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.task;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ReserveService;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProduct;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProductStatus;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonContractService;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonApiClient;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonKassaApiClient;
import ru.bitel.bgbilling.modules.megafon.server.utils.MegafonUtils;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class CheckMNPStatusTask
extends TaskBase {
    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        this.getLogger().info("\u041c\u0435\u0433\u0430\u0444\u043e\u043d. \u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 MNP");
        try {
            ServerContext context = (ServerContext)ServerContext.get();
            MegafonApiClient megafonApiClient = new MegafonApiClient(this.moduleId);
            MegafonContractService megafonContractService = (MegafonContractService)context.getService(MegafonContractService.class, this.moduleId);
            List products = megafonContractService.getContractProductList(null, -1, MegafonContractProductStatus.ACTIVE).getList();
            for (MegafonContractProduct contractProduct : products) {
                if (Utils.isBlankString((String)contractProduct.getMnpProcessNumber())) continue;
                try {
                    this.checkMNPStatus(context, megafonContractService, megafonApiClient, contractProduct);
                }
                catch (Exception e) {
                    this.logError(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 MNP. contractProductId=%s, cid=%s", contractProduct.getId(), contractProduct.getContractId()), e);
                }
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    private void checkMNPStatus(ServerContext context, MegafonContractService megafonContractService, MegafonApiClient megafonApiClient, MegafonContractProduct contractProduct) throws Exception {
        if (Utils.notBlankString((String)contractProduct.getAdditionalMsisdn()) && Utils.isBlankString((String)contractProduct.getMnpProcessNumber())) {
            throw new BGException(String.format("\u041d\u0435\u0442 mnpProcessNumber \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430! contractProductId=%s, cid=%s", contractProduct.getId(), contractProduct.getContractId()));
        }
        if (Utils.notBlankString((String)contractProduct.getMnpProcessNumber()) && Utils.isBlankString((String)contractProduct.getAdditionalMsisdn())) {
            throw new BGException(String.format("\u041d\u0435\u0442 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043d\u043e\u043c\u0435\u0440\u0430 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430! contractProductId=%s, cid=%s", contractProduct.getId(), contractProduct.getContractId()));
        }
        this.getLogger().info("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 MNP \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430: msisdn={}, additionalMsisdn={}, cid={}, mnpProcessNumber={}", new Object[]{contractProduct.getMsisdn(), contractProduct.getAdditionalMsisdn(), contractProduct.getContractId(), contractProduct.getMnpProcessNumber()});
        JSONObject status = megafonApiClient.getInquiries(contractProduct.getMnpProcessNumber());
        JSONObject activity = status.getJSONObject("currentState").getJSONObject("activity");
        int activityId = activity.optInt("activityId");
        String activityCode = activity.optString("activityCode");
        String comment = "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435: " + activity.optString("name") + "\n\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438: " + TimeUtils.format((LocalDateTime)LocalDateTime.now(), (String)"dd.MM.yyyy HH:mm:ss") + "\nactivityCode=" + activityCode + "\nactivityId=" + activityId;
        contractProduct.setMnpOrderComment(comment);
        if ("MNP_FINISHED".equals(activityCode) || "MNP_REJECT_TRANSFER".equals(activityCode)) {
            this.closeContractReserve(context, contractProduct);
            if ("MNP_FINISHED".equals(activityCode)) {
                this.getLogger().info("MNP \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d. msisdn={}, cid={}", (Object)contractProduct.getMsisdn(), (Object)contractProduct.getContractId());
                this.addMNPPayment(context, contractProduct);
            } else {
                this.getLogger().info("\u041e\u0442\u043c\u0435\u043d\u0451\u043d MNP \u043f\u0440\u043e\u0446\u0435\u0441\u0441. msisdn={}, cid={}", (Object)contractProduct.getMsisdn(), (Object)contractProduct.getContractId());
            }
            contractProduct.setAdditionalMsisdn("");
            contractProduct.setMnpProcessNumber("");
            contractProduct.setReserveId(0);
        }
        megafonContractService.contractProductUpdate(contractProduct);
    }

    private void addMNPPayment(ServerContext context, MegafonContractProduct contractProduct) {
        String msisdn = contractProduct.getMsisdn();
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        BigDecimal mnpProcessPrice = Utils.parseBigDecimal((String)moduleSetup.get("megafon.mnp.price"), (BigDecimal)BigDecimal.valueOf(100L));
        String comment = String.format("\u0417\u0430 \u043f\u0435\u0440\u0435\u043d\u043e\u0441 \u043d\u043e\u043c\u0435\u0440\u0430 = %s", contractProduct.getMsisdn());
        MegafonKassaApiClient kassaApiClient = new MegafonKassaApiClient(context.getModuleId());
        kassaApiClient.addPayment(contractProduct.getContractId(), msisdn, mnpProcessPrice, comment);
        MegafonUtils.contractAddCharge(context, moduleSetup, contractProduct.getContractId(), mnpProcessPrice, comment);
    }

    private void closeContractReserve(ServerContext context, MegafonContractProduct contractProduct) throws Exception {
        this.getLogger().info("\u0421\u043d\u044f\u0442\u0438\u0435 \u0440\u0435\u0437\u0435\u0440\u0432\u0430 \u043d\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430. cid={}, reserveId={}", (Object)contractProduct.getContractId(), (Object)contractProduct.getReserveId());
        ReserveService reserveService = (ReserveService)context.getService(ReserveService.class, 0);
        reserveService.closeReserve(contractProduct.getReserveId());
    }

    public String getDescription() {
        return "\u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 MNP";
    }
}

