/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import ru.bitel.bgbilling.modules.ipn.server.bean.RangeIface;

public class RangeIfaceManager {
    private Connection con;
    private int mid = -1;

    public RangeIfaceManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    public Set<RangeIface> getAdressRangeIfaces(int aid) {
        HashSet<RangeIface> result = new HashSet<RangeIface>();
        try {
            String query = "SELECT * FROM ipn_user_source_" + this.mid + " WHERE aid=?";
            PreparedStatement getAdressRangeIfacesPS = this.con.prepareStatement(query);
            getAdressRangeIfacesPS.setInt(1, aid);
            ResultSet rs = getAdressRangeIfacesPS.executeQuery();
            while (rs.next()) {
                result.add(this.getRangeIfaceFromRs(rs));
            }
            getAdressRangeIfacesPS.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void updateAddressRangeIfaces(int aid, Collection<RangeIface> ifaceList) {
        try {
            String query = "DELETE FROM ipn_user_source_" + this.mid + " WHERE aid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, aid);
            ps.executeUpdate();
            ps.close();
            query = "INSERT INTO ipn_user_source_" + this.mid + " ( aid, source_id, iface ) values ( ?, ?, ? )";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, aid);
            for (RangeIface iface : ifaceList) {
                ps.setInt(2, iface.getSourceId());
                ps.setInt(3, iface.getIfaceId());
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteWrongRangeIfaces() {
        try {
            String query = "SELECT user_source.aid, user_range.id FROM ipn_user_source_" + this.mid + " AS user_source LEFT JOIN ipn_user_range_" + this.mid + " AS user_range ON user_source.aid=user_range.id HAVING user_range.id IS NULL";
            PreparedStatement ps = this.con.prepareStatement(query);
            StringBuilder aidList = new StringBuilder(200);
            aidList.append("-1");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                aidList.append(",");
                aidList.append(rs.getInt(1));
            }
            rs.close();
            ps.close();
            query = "DELETE FROM ipn_user_source_" + this.mid + " WHERE aid IN ( " + aidList.toString() + " )";
            Statement st = this.con.createStatement();
            st.executeUpdate(query);
            st.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private RangeIface getRangeIfaceFromRs(ResultSet rs) throws SQLException {
        RangeIface rangeIface = new RangeIface();
        rangeIface.setRangeId(rs.getInt("aid"));
        rangeIface.setSourceId(rs.getInt("source_id"));
        rangeIface.setIfaceId(rs.getInt("iface"));
        return rangeIface;
    }
}

