/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateType;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class GateTypeManager {
    private Connection con;
    private String tableName;

    public GateTypeManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "ipn_gate_type_" + mid;
    }

    public Map<Integer, GateType> getTypeMap() {
        HashMap<Integer, GateType> result = new HashMap<Integer, GateType>();
        try {
            String query = "SELECT * FROM " + this.tableName + " ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                GateType type = this.getTypeFromRS(rs);
                result.put(type.getId(), type);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<GateType> getTypeList() {
        ArrayList<GateType> result = new ArrayList<GateType>();
        try {
            String query = "SELECT * FROM " + this.tableName + " ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getTypeFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateType(GateType type) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (type.getId() <= 0) {
                query = "INSERT INTO " + this.tableName + " ( title, comment, config, rule, script) VALUES (?, ?, ?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE " + this.tableName + " SET title=?, comment=?, config=?, rule=?, script=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(6, type.getId());
            }
            ps.setString(1, type.getTitle());
            ps.setString(2, type.getComment());
            ps.setString(3, type.getConfig());
            ps.setString(4, type.getRule());
            ps.setString(5, type.getScript());
            ps.executeUpdate();
            if (type.getId() <= 0) {
                type.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteType(int id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public GateType getType(int id) {
        GateType result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getTypeFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private GateType getTypeFromRS(ResultSet rs) throws SQLException {
        GateType result = new GateType();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setComment(rs.getString("comment"));
        result.setConfig(rs.getString("config"));
        result.setRule(rs.getString("rule"));
        result.setScript(rs.getString("script"));
        return result;
    }
}

