/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.bean;

import bitel.billing.server.util.Iter;
import bitel.billing.server.util.PagedList;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItem;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItemManager;
import ru.bitel.bgbilling.modules.phone.server.bean.DataLog;
import ru.bitel.bgbilling.modules.phone.server.bean.Report;
import ru.bitel.bgbilling.modules.phone.server.bean.Session;
import ru.bitel.bgbilling.modules.phone.server.bean.SessionDetail;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

public final class ReportManager {
    public static final int OUT_CALL = 1;
    public static final int IN_CALL = 2;
    private Connection con;
    private int moduleId;
    private HashMap<Integer, String> itemTitles = new HashMap();
    private HashMap<Integer, List<String>> itemPorts = new HashMap();
    private HashMap<Integer, List<String>> itemNumbers = new HashMap();
    private HashMap<Integer, String> destinationTitles = new HashMap();
    private HashMap<Integer, String> serviceTitles = new HashMap();

    public ReportManager(Connection con, int moduleId) {
        this.con = con;
        this.moduleId = moduleId;
    }

    public PagedList<Report> getPointDestinationList(int cid, String items, Calendar date1, Calendar date2, boolean noFree, Page page) {
        int records = 0;
        ArrayList<Report> result = new ArrayList<Report>();
        Report total = new Report();
        String table = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)date1.getTime(), (int)this.moduleId);
        if (ServerUtils.tableExists((Connection)this.con, (String)table) && !Utils.isEmptyString((String)items) && !items.contains(";")) {
            try {
                StringBuilder where = new StringBuilder(" WHERE session.cid=?");
                if (date1 != null && date1.get(5) != date1.getActualMinimum(5)) {
                    where.append(" AND session.session_start>='");
                    where.append(TimeUtils.formatSQLDate((Date)date1.getTime()));
                    where.append("'");
                }
                if (date2 != null && date2.get(5) != date2.getActualMaximum(5)) {
                    date2.add(5, 1);
                    where.append(" AND session.session_start<'");
                    where.append(TimeUtils.formatSQLDate((Date)date2.getTime()));
                    where.append("'");
                }
                where.append(" AND session.item_id IN (");
                where.append(items);
                where.append(")");
                if (noFree) {
                    where.append(" AND session.cost!=0");
                }
                StringBuilder query = new StringBuilder("SELECT COUNT(DISTINCT session.item_id, session.dest_id), COUNT(session.id), SUM(session.session_time), SUM(session.round_session_time), SUM(session.cost) FROM " + table + " as session");
                query.append((CharSequence)where);
                PreparedStatement ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, cid);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    records = rs.getInt(1);
                    total.setNumber(rs.getInt(2));
                    total.setTime(rs.getInt(3));
                    total.setTimeRound(rs.getInt(4));
                    total.setCost(rs.getBigDecimal(5));
                }
                rs.close();
                ps.close();
                if (page.getPageSize() > 0) {
                    page.setRecordCount(records);
                    if (page.getPageIndex() > page.getPageCount()) {
                        page.setPageIndex(page.getPageCount());
                    }
                }
                query = new StringBuilder();
                query.append("SELECT session.item_id, session.dest_id,");
                query.append(" COUNT(session.id) as number, SUM(session.session_time) as time, SUM(session.round_session_time) as round_time, SUM(session.cost) AS cost FROM ");
                query.append(table);
                query.append(" AS session");
                query.append((CharSequence)where);
                query.append(" GROUP BY session.item_id, session.dest_id");
                if (page.getPageSize() > 0) {
                    query.append(page.sqlLimit());
                }
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, cid);
                rs = ps.executeQuery();
                PreparedStatement getSimpleItemPS = ClientItemManager.getSimpleItemPS(this.con, this.moduleId);
                PreparedStatement getNumbersPS = ClientItemManager.getNumbersPS(this.con, this.moduleId);
                PreparedStatement getPortsPS = ClientItemManager.getPortsPS(this.con, this.moduleId);
                PreparedStatement getDestinationPS = this.con.prepareStatement("SELECT title FROM phone_dest_" + this.moduleId + " WHERE id=?");
                while (rs.next()) {
                    result.add(this.getDestinationReportFromRS(rs, getSimpleItemPS, getNumbersPS, getPortsPS, getDestinationPS));
                }
                rs.close();
                ps.close();
                getSimpleItemPS.close();
                getNumbersPS.close();
                getPortsPS.close();
                getDestinationPS.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return new PagedList(result, page, records, (Object)total);
    }

    public PagedList<Report> getCostList(int cid, String items, Calendar date1, Calendar date2, int type, boolean noFree, Page page) {
        int records = 0;
        ArrayList<Report> result = new ArrayList<Report>();
        Report total = new Report();
        String table = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)date1.getTime(), (int)this.moduleId);
        if (ServerUtils.tableExists((Connection)this.con, (String)table) && !Utils.isEmptyString((String)items) && !items.contains(";")) {
            try {
                StringBuilder where = new StringBuilder(" WHERE session.cid=?");
                if (date1 != null && date1.get(5) != date1.getActualMinimum(5)) {
                    where.append(" AND session.session_start>='");
                    where.append(TimeUtils.formatSQLDate((Date)date1.getTime()));
                    where.append("'");
                }
                if (date2 != null && date2.get(5) != date2.getActualMaximum(5)) {
                    date2.add(5, 1);
                    where.append(" AND session.session_start<'");
                    where.append(TimeUtils.formatSQLDate((Date)date2.getTime()));
                    where.append("'");
                }
                where.append(" AND item_id IN (");
                where.append(items);
                where.append(")");
                if (noFree) {
                    where.append(" AND session.cost!=0");
                }
                StringBuilder query = new StringBuilder("SELECT COUNT(DISTINCT session.item_id), COUNT(session.id), SUM(session.session_time), SUM(session.round_session_time), SUM(session.cost) FROM " + table + " as session");
                query.append((CharSequence)where);
                PreparedStatement ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, cid);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    records = rs.getInt(1);
                    total.setNumber(rs.getInt(2));
                    total.setTime(rs.getInt(3));
                    total.setTimeRound(rs.getInt(4));
                    total.setCost(rs.getBigDecimal(5));
                }
                rs.close();
                ps.close();
                if (page.getPageSize() > 0) {
                    page.setRecordCount(records);
                }
                query = new StringBuilder("SELECT session.item_id, session.dest_id, COUNT(session.id) as number, SUM(session.session_time) as time, SUM(session.round_session_time) as round_time, SUM(session.cost) as cost FROM " + table + " as session");
                query.append((CharSequence)where);
                query.append(" GROUP BY session.item_id");
                if (page.getPageSize() > 0) {
                    query.append(page.sqlLimit());
                }
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, cid);
                rs = ps.executeQuery();
                PreparedStatement getSimpleItemPS = ClientItemManager.getSimpleItemPS(this.con, this.moduleId);
                PreparedStatement getNumbersPS = ClientItemManager.getNumbersPS(this.con, this.moduleId);
                PreparedStatement getPortsPS = ClientItemManager.getPortsPS(this.con, this.moduleId);
                while (rs.next()) {
                    result.add(this.getCostReportFromRS(rs, getSimpleItemPS, getNumbersPS, getPortsPS));
                }
                rs.close();
                ps.close();
                getSimpleItemPS.close();
                getNumbersPS.close();
                getPortsPS.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return new PagedList(result, page, records, (Object)total);
    }

    private Report getDestinationReportFromRS(ResultSet rs, PreparedStatement getSimpleItemPS, PreparedStatement getNumbersPS, PreparedStatement getPortsPS, PreparedStatement getDestinationPS) throws SQLException {
        Report result = new Report();
        int itemId = rs.getInt("item_id");
        this.setItemTitle(getSimpleItemPS, getNumbersPS, getPortsPS, result, itemId);
        int destId = rs.getInt("dest_id");
        result.setDestCode(destId);
        String destTitle = this.destinationTitles.get(destId);
        if (destTitle == null) {
            getDestinationPS.setInt(1, destId);
            ResultSet destRS = getDestinationPS.executeQuery();
            if (destRS.next()) {
                destTitle = destRS.getString(1);
                this.destinationTitles.put(destId, destTitle);
            }
            destRS.close();
        }
        result.setDestination(destTitle);
        result.setNumber(rs.getInt("number"));
        result.setTime(rs.getInt("time"));
        result.setTimeRound(rs.getInt("round_time"));
        result.setCost(rs.getBigDecimal("cost"));
        return result;
    }

    private Report getCostReportFromRS(ResultSet rs, PreparedStatement getSimpleItemPS, PreparedStatement getNumbersPS, PreparedStatement getPortsPS) throws SQLException {
        Report result = new Report();
        int itemId = rs.getInt("item_id");
        result.setClientItemId(itemId);
        this.setItemTitle(getSimpleItemPS, getNumbersPS, getPortsPS, result, itemId);
        result.setNumber(rs.getInt("number"));
        result.setTime(rs.getInt("time"));
        result.setTimeRound(rs.getInt("round_time"));
        result.setCost(rs.getBigDecimal("cost"));
        return result;
    }

    public final boolean getSessionListQuery(StringBuilder query, StringBuilder total, int cid, String items, Calendar gotdate1, Calendar gotdate2, int type, boolean noFree, Page page, int destId, int serviceId, boolean orderBySidItem) {
        Calendar date1 = (Calendar)gotdate1.clone();
        Calendar date2 = (Calendar)gotdate2.clone();
        String table = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)date1.getTime(), (int)this.moduleId);
        if (ServerUtils.tableExists((Connection)this.con, (String)table) && !Utils.isEmptyString((String)items)) {
            StringBuilder where = new StringBuilder(120);
            where.append(" WHERE session.cid=?");
            if (date1 != null && date1.get(5) != date1.getActualMinimum(5)) {
                where.append(" AND session.session_start>='");
                where.append(TimeUtils.formatSQLDate((Date)date1.getTime()));
                where.append("'");
            }
            if (date2 != null && date2.get(5) != date2.getActualMaximum(5)) {
                date2.add(5, 1);
                where.append(" AND session.session_start<'");
                where.append(TimeUtils.formatSQLDate((Date)date2.getTime()));
                where.append("'");
            }
            if (items != null) {
                where.append(" AND item_id IN (");
                where.append(items);
                where.append(")");
            }
            if (destId > 0) {
                where.append(" AND session.dest_id=");
                where.append(destId);
            }
            if (serviceId > 0) {
                where.append(" AND session.sid=");
                where.append(serviceId);
            }
            if (noFree) {
                where.append(" AND session.cost!=0");
            }
            total.append("SELECT COUNT(session.id), SUM(session.session_time), SUM(session.round_session_time), SUM(session.cost) FROM ");
            total.append(table);
            total.append(" AS session");
            total.append((CharSequence)where);
            query.append("SELECT session.* FROM ");
            query.append(table);
            query.append(" AS session");
            query.append((CharSequence)where);
            if (orderBySidItem) {
                query.append(" ORDER BY sid, item_id, from_number_164, session_start");
            } else {
                query.append(" ORDER BY session_start");
            }
            if (page.getPageSize() > 0) {
                query.append(page.sqlLimit());
            }
            return true;
        }
        return false;
    }

    public PagedList<SessionDetail<SessionDetail<Session>>> getSessionDetailList(int cid, String items, Calendar date1, Calendar date2, int type, boolean noFree, Page page, int destId, int serviceId) {
        if (page.getPageSize() <= 0) {
            return this.getSessionDetailList(cid, items, date1, date2, type, noFree, destId, serviceId);
        }
        int records = 0;
        SessionDetail total = new SessionDetail();
        ArrayList result = new ArrayList();
        StringBuilder query = new StringBuilder(220);
        StringBuilder totalQuery = new StringBuilder(220);
        if (this.getSessionListQuery(query, totalQuery, cid, items, date1, date2, type, noFree, page, destId, serviceId, true)) {
            try {
                PreparedStatement ps = this.con.prepareStatement(totalQuery.toString());
                ps.setInt(1, cid);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    records = rs.getInt(1);
                    total.setTotalTime(rs.getInt(2));
                    total.setTotalTimeRound(rs.getInt(3));
                    total.setTotalCost(rs.getBigDecimal(4));
                }
                rs.close();
                ps.close();
                if (page.getPageSize() > 0) {
                    page.setRecordCount(records);
                }
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, cid);
                rs = ps.executeQuery();
                PreparedStatement getSimpleItemPS = ClientItemManager.getSimpleItemPS(this.con, this.moduleId);
                PreparedStatement getNumbersPS = ClientItemManager.getNumbersPS(this.con, this.moduleId);
                PreparedStatement getPortsPS = ClientItemManager.getPortsPS(this.con, this.moduleId);
                PreparedStatement getDestinationPS = this.con.prepareStatement("SELECT title FROM phone_dest_" + this.moduleId + " WHERE id=?");
                PreparedStatement getServicePS = this.con.prepareStatement("SELECT title FROM service WHERE id=?");
                SessionDetail service = new SessionDetail();
                SessionDetail aon = null;
                byte[] lastNumberBytes = new byte[]{};
                int lastServiceId = 0;
                while (rs.next()) {
                    boolean serviceChanged;
                    Session session = this.getSessionDetailFromRS(rs, getSimpleItemPS, getNumbersPS, getPortsPS, getDestinationPS);
                    int sid = rs.getInt("sid");
                    if (sid != lastServiceId) {
                        lastServiceId = sid;
                        Report tot = this.getTotal(cid, date1, date2, type, noFree, sid, 0, null, items);
                        service = new SessionDetail();
                        service.setTotalCost(tot.getCost());
                        service.setTotalNumber(tot.getNumber());
                        service.setTotalTime(tot.getTime());
                        service.setTotalTimeRound(tot.getTimeRound());
                        if (page.getPageSize() > 0) {
                            service.list = new ArrayList();
                        } else {
                            service.list = new ArrayList(tot.getNumber());
                            service.setSize(new Iter.BeanNodeList(tot.getNumber()));
                        }
                        service.setId(sid);
                        getServicePS.setInt(1, sid);
                        ResultSet getServiceRS = getServicePS.executeQuery();
                        if (getServiceRS.next()) {
                            service.setTitle(getServiceRS.getString(1));
                        } else {
                            service.setTitle("");
                        }
                        getServiceRS.close();
                        result.add(service);
                        serviceChanged = true;
                    } else {
                        serviceChanged = false;
                    }
                    byte[] fromNumber = rs.getBytes("from_number_164");
                    if (serviceChanged || !this.equalsNumber(fromNumber, lastNumberBytes)) {
                        lastNumberBytes = fromNumber;
                        String num = rs.getString("from_number_164");
                        Report tot = this.getTotal(cid, date1, date2, type, noFree, sid, session.getClientItemId(), num, null);
                        aon = new SessionDetail();
                        aon.setTotalCost(tot.getCost());
                        aon.setTotalNumber(tot.getNumber());
                        aon.setTotalTime(tot.getTime());
                        aon.setTotalTimeRound(tot.getTimeRound());
                        if (page.getPageSize() > 0) {
                            aon.list = new ArrayList();
                        } else {
                            aon.list = new ArrayList(tot.getNumber());
                            aon.setSize(new Iter.BeanNodeList(tot.getNumber()));
                        }
                        aon.setTitle(rs.getString("from_number_164"));
                        service.list.add(aon);
                    }
                    aon.list.add(session);
                }
                rs.close();
                ps.close();
                getSimpleItemPS.close();
                getNumbersPS.close();
                getPortsPS.close();
                getDestinationPS.close();
                getServicePS.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return new PagedList(result, page, records, total);
    }

    public PagedList<SessionDetail<SessionDetail<Session>>> getSessionDetailList(int cid, String items, Calendar date1, Calendar date2, int type, boolean noFree, int destId, int serviceId) {
        int records = 0;
        Page page = new Page();
        SessionDetail total = new SessionDetail();
        ArrayList result = new ArrayList();
        StringBuilder query = new StringBuilder(220);
        StringBuilder totalQuery = new StringBuilder(220);
        page.setPageIndex(0);
        page.setPageSize(-1);
        if (this.getSessionListQuery(query, totalQuery, cid, items, date1, date2, type, noFree, page, destId, serviceId, true)) {
            try {
                PreparedStatement ps = this.con.prepareStatement(totalQuery.toString());
                ps.setInt(1, cid);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    records = rs.getInt(1);
                    total.setTotalTime(rs.getInt(2));
                    total.setTotalTimeRound(rs.getInt(3));
                    total.setTotalCost(rs.getBigDecimal(4));
                }
                rs.close();
                ps.close();
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, cid);
                rs = ps.executeQuery();
                PreparedStatement getSimpleItemPS = ClientItemManager.getSimpleItemPS(this.con, this.moduleId);
                PreparedStatement getNumbersPS = ClientItemManager.getNumbersPS(this.con, this.moduleId);
                PreparedStatement getPortsPS = ClientItemManager.getPortsPS(this.con, this.moduleId);
                PreparedStatement getDestinationPS = this.con.prepareStatement("SELECT title FROM phone_dest_" + this.moduleId + " WHERE id=?");
                PreparedStatement getServicePS = this.con.prepareStatement("SELECT title FROM service WHERE id=?");
                SessionDetail service = new SessionDetail();
                service.list = new ArrayList(0);
                SessionDetail aon = new SessionDetail();
                aon.list = new ArrayList(0);
                byte[] lastNumberBytes = new byte[]{};
                int lastServiceId = 0;
                BigDecimal serviceCost = BigDecimal.ZERO;
                int serviceNumber = 0;
                int serviceTime = 0;
                int serviceTimeRound = 0;
                BigDecimal aonCost = BigDecimal.ZERO;
                int aonNumber = 0;
                int aonTime = 0;
                int aonTimeRound = 0;
                while (rs.next()) {
                    boolean serviceChanged;
                    Session session = this.getSessionDetailFromRS(rs, getSimpleItemPS, getNumbersPS, getPortsPS, getDestinationPS);
                    int sid = rs.getInt("sid");
                    if (sid != lastServiceId) {
                        lastServiceId = sid;
                        service.setTotalCost(serviceCost);
                        service.setTotalNumber(serviceNumber);
                        service.setTotalTime(serviceTime);
                        service.setTotalTimeRound(serviceTimeRound);
                        service.setSize(new Iter.BeanNodeList(service.list.size()));
                        service = new SessionDetail();
                        service.list = new ArrayList();
                        serviceCost = BigDecimal.ZERO;
                        serviceNumber = 0;
                        serviceTime = 0;
                        serviceTimeRound = 0;
                        service.setId(sid);
                        getServicePS.setInt(1, sid);
                        ResultSet getServiceRS = getServicePS.executeQuery();
                        if (getServiceRS.next()) {
                            service.setTitle(getServiceRS.getString(1));
                        } else {
                            service.setTitle("");
                        }
                        getServiceRS.close();
                        result.add(service);
                        serviceChanged = true;
                    } else {
                        serviceChanged = false;
                    }
                    byte[] fromNumber = rs.getBytes("from_number_164");
                    if (serviceChanged || !this.equalsNumber(fromNumber, lastNumberBytes)) {
                        lastNumberBytes = fromNumber;
                        String num = rs.getString("from_number_164");
                        aon.setTotalCost(aonCost);
                        aon.setTotalNumber(aonNumber);
                        aon.setTotalTime(aonTime);
                        aon.setTotalTimeRound(aonTimeRound);
                        aon.setSize(new Iter.BeanNodeList(aon.list.size()));
                        aon = new SessionDetail();
                        aon.list = new ArrayList();
                        aonCost = BigDecimal.ZERO;
                        aonNumber = 0;
                        aonTime = 0;
                        aonTimeRound = 0;
                        aon.setTitle(num);
                        service.list.add(aon);
                    }
                    BigDecimal cost = session.getSessionCost();
                    int time = session.getSessionTime();
                    int timeRound = session.getSessionTimeRound();
                    serviceCost = serviceCost.add(cost);
                    ++serviceNumber;
                    serviceTime += time;
                    serviceTimeRound += timeRound;
                    aonCost = aonCost.add(cost);
                    ++aonNumber;
                    aonTime += time;
                    aonTimeRound += timeRound;
                    aon.list.add(session);
                }
                service.setTotalCost(serviceCost);
                service.setTotalNumber(serviceNumber);
                service.setTotalTime(serviceTime);
                service.setTotalTimeRound(serviceTimeRound);
                service.setSize(new Iter.BeanNodeList(service.list.size()));
                aon.setTotalCost(aonCost);
                aon.setTotalNumber(aonNumber);
                aon.setTotalTime(aonTime);
                aon.setTotalTimeRound(aonTimeRound);
                aon.setSize(new Iter.BeanNodeList(aon.list.size()));
                rs.close();
                ps.close();
                getSimpleItemPS.close();
                getNumbersPS.close();
                getPortsPS.close();
                getDestinationPS.close();
                getServicePS.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        page = new Page();
        page.setPageIndex(0);
        page.setPageSize(0);
        return new PagedList(result, page, records, total);
    }

    private boolean equalsNumber(byte[] number, byte[] lastNumberBytes) {
        if (number.length != lastNumberBytes.length) {
            return false;
        }
        for (int i = number.length - 1; i > 0; --i) {
            if (number[i] == lastNumberBytes[i]) continue;
            return false;
        }
        return true;
    }

    public PagedList<Session> getSessionList(int cid, String items, Calendar date1, Calendar date2, int type, boolean noFree, Page page, int destId, int serviceId, boolean orderBySidItem) {
        int records = 0;
        Session total = new Session();
        ArrayList<Session> result = new ArrayList<Session>();
        StringBuilder query = new StringBuilder(220);
        StringBuilder totalQuery = new StringBuilder(220);
        if (this.getSessionListQuery(query, totalQuery, cid, items, date1, date2, type, noFree, page, destId, serviceId, orderBySidItem)) {
            try {
                PreparedStatement ps = this.con.prepareStatement(totalQuery.toString());
                ps.setInt(1, cid);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    records = rs.getInt(1);
                    total.setSessionTime(rs.getInt(2));
                    total.setSessionTimeRound(rs.getInt(3));
                    total.setSessionCost(rs.getBigDecimal(4));
                }
                rs.close();
                ps.close();
                if (page.getPageSize() > 0) {
                    page.setRecordCount(records);
                }
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, cid);
                rs = ps.executeQuery();
                PreparedStatement getSimpleItemPS = ClientItemManager.getSimpleItemPS(this.con, this.moduleId);
                PreparedStatement getNumbersPS = ClientItemManager.getNumbersPS(this.con, this.moduleId);
                PreparedStatement getPortsPS = ClientItemManager.getPortsPS(this.con, this.moduleId);
                PreparedStatement getDestinationPS = this.con.prepareStatement("SELECT title FROM phone_dest_" + this.moduleId + " WHERE id=?");
                PreparedStatement getServicePS = this.con.prepareStatement("SELECT title FROM service WHERE id=?");
                while (rs.next()) {
                    result.add(this.getSessionFromRS(rs, getSimpleItemPS, getNumbersPS, getPortsPS, getDestinationPS, getServicePS));
                }
                rs.close();
                ps.close();
                getSimpleItemPS.close();
                getNumbersPS.close();
                getPortsPS.close();
                getDestinationPS.close();
                getServicePS.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return new PagedList(result, page, records, (Object)total);
    }

    private Session getSessionDetailFromRS(ResultSet rs, PreparedStatement getSimpleItemPS, PreparedStatement getNumbersPS, PreparedStatement getPortsPS, PreparedStatement getDestinationPS) throws SQLException {
        Session result = new Session();
        int itemId = rs.getInt("item_id");
        result.setId(rs.getInt("id"));
        result.setCid(rs.getInt("cid"));
        result.setCdrId(rs.getInt("cdr_id"));
        result.setHour(rs.getTimestamp("hour"));
        result.setClientItemId(itemId);
        result.setSourceId(rs.getInt("source_id"));
        result.setToNumber164(rs.getString("to_number_164"));
        result.setFromNumber(rs.getString("from_number"));
        result.setToNumber(rs.getString("to_number"));
        result.setSessionTime(rs.getInt("session_time"));
        result.setSessionTimeRound(rs.getInt("round_session_time"));
        result.setSessionStart(rs.getTimestamp("session_start"));
        result.setSessionCost(rs.getBigDecimal("cost"));
        result.setMinCost(rs.getFloat("min_cost"));
        String itemTitle = this.itemTitles.get(result.getClientItemId());
        if (itemTitle == null) {
            itemTitle = ClientItem.toString(result.getClientItemId(), getSimpleItemPS, getNumbersPS, getPortsPS);
            this.itemTitles.put(itemId, itemTitle);
        }
        result.setClientItem(itemTitle);
        int destId = rs.getInt("dest_id");
        result.setDestCode(destId);
        String destTitle = this.destinationTitles.get(destId);
        if (destTitle == null) {
            getDestinationPS.setInt(1, destId);
            ResultSet destRS = getDestinationPS.executeQuery();
            if (destRS.next()) {
                destTitle = destRS.getString(1);
                this.destinationTitles.put(destId, destTitle);
            }
            destRS.close();
        }
        result.setDestination(destTitle);
        return result;
    }

    private Session getSessionFromRS(ResultSet rs, PreparedStatement getSimpleItemPS, PreparedStatement getNumbersPS, PreparedStatement getPortsPS, PreparedStatement getDestinationPS, PreparedStatement getServicePS) throws SQLException {
        Session result = new Session();
        int itemId = rs.getInt("item_id");
        result.setId(rs.getInt("id"));
        result.setCid(rs.getInt("cid"));
        result.setCdrId(rs.getInt("cdr_id"));
        result.setHour(rs.getTimestamp("hour"));
        result.setClientItemId(itemId);
        result.setSourceId(rs.getInt("source_id"));
        result.setFromNumber164(rs.getString("from_number_164"));
        result.setToNumber164(rs.getString("to_number_164"));
        result.setFromNumber(rs.getString("from_number"));
        result.setToNumber(rs.getString("to_number"));
        result.setSessionTime(rs.getInt("session_time"));
        result.setSessionTimeRound(rs.getInt("round_session_time"));
        result.setSessionStart(rs.getTimestamp("session_start"));
        result.setSessionCost(rs.getBigDecimal("cost"));
        result.setMinCost(rs.getFloat("min_cost"));
        String itemTitle = this.itemTitles.get(result.getClientItemId());
        if (itemTitle == null) {
            itemTitle = ClientItem.toString(result.getClientItemId(), getSimpleItemPS, getNumbersPS, getPortsPS);
            this.itemTitles.put(itemId, itemTitle);
        }
        result.setClientItem(itemTitle);
        int destId = rs.getInt("dest_id");
        result.setDestCode(destId);
        String destTitle = this.destinationTitles.get(destId);
        if (destTitle == null) {
            getDestinationPS.setInt(1, destId);
            ResultSet destRS = getDestinationPS.executeQuery();
            if (destRS.next()) {
                destTitle = destRS.getString(1);
                this.destinationTitles.put(destId, destTitle);
            }
            destRS.close();
        }
        result.setDestination(destTitle);
        int serviceId = rs.getInt("sid");
        result.setServiceId(serviceId);
        String serviceTitle = this.serviceTitles.get(serviceId);
        if (serviceTitle == null) {
            getServicePS.setInt(1, serviceId);
            ResultSet serviceRS = getServicePS.executeQuery();
            if (serviceRS.next()) {
                serviceTitle = serviceRS.getString(1);
                this.serviceTitles.put(serviceId, serviceTitle);
            }
            serviceRS.close();
        }
        result.setService(serviceTitle);
        return result;
    }

    public DataLog getDataLog(int id, Calendar month) {
        DataLog result = null;
        String table = "data_log_" + this.moduleId + TimeUtils.format((Calendar)month, (String)"_yyyyMMdd");
        if (ServerUtils.tableExists((Connection)this.con, (String)table)) {
            try {
                Statement st = this.con.createStatement();
                ResultSet rs = st.executeQuery("SELECT data.*, source.title as source_title FROM " + table + " as data LEFT JOIN source ON source.id=data.source_id WHERE data.id=" + id);
                if (rs.next()) {
                    result = new DataLog();
                    result.setId(rs.getInt("id"));
                    result.setCategory(rs.getInt("cat"));
                    result.setFromNumber(rs.getString("from_number"));
                    result.setFromNumber164(rs.getString("from_number_164"));
                    result.setToNumber(rs.getString("to_number"));
                    result.setToNumber164(rs.getString("to_number_164"));
                    result.setFromPort(rs.getString("from_port"));
                    result.setToPort(rs.getString("to_port"));
                    result.setSource(rs.getString("source_title"));
                    result.setSessionStart(TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp("session_start")));
                    result.setSessionTime(rs.getInt("session_time"));
                }
                rs.close();
                st.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public PagedList<Report> getServiceReportList(int cid, String items, Calendar date1, Calendar date2, boolean noFree, Page page) {
        int records = 0;
        ArrayList<Report> result = new ArrayList<Report>();
        Report total = new Report();
        String table = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)date1.getTime(), (int)this.moduleId);
        if (ServerUtils.tableExists((Connection)this.con, (String)table) && !Utils.isEmptyString((String)items) && !items.contains(";")) {
            try {
                StringBuilder where = new StringBuilder(" WHERE session.cid=?");
                if (date1 != null && date1.get(5) != date1.getActualMinimum(5)) {
                    where.append(" AND session.session_start>='");
                    where.append(TimeUtils.formatSQLDate((Date)date1.getTime()));
                    where.append("'");
                }
                if (date2 != null && date2.get(5) != date2.getActualMaximum(5)) {
                    date2.add(5, 1);
                    where.append(" AND session.session_start<'");
                    where.append(TimeUtils.formatSQLDate((Date)date2.getTime()));
                    where.append("'");
                }
                where.append(" AND session.item_id IN (");
                where.append(items);
                where.append(")");
                if (noFree) {
                    where.append(" AND session.cost!=0");
                }
                StringBuilder query = new StringBuilder("SELECT COUNT(DISTINCT session.item_id, session.sid), COUNT(session.id), SUM(session.session_time), SUM(session.round_session_time), SUM(session.cost) FROM " + table + " as session");
                query.append((CharSequence)where);
                PreparedStatement ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, cid);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    records = rs.getInt(1);
                    total.setNumber(rs.getInt(2));
                    total.setTime(rs.getInt(3));
                    total.setTimeRound(rs.getInt(4));
                    total.setCost(rs.getBigDecimal(5));
                }
                rs.close();
                ps.close();
                if (page.getPageSize() > 0) {
                    page.setRecordCount(records);
                    if (page.getPageIndex() > page.getPageCount()) {
                        page.setPageIndex(page.getPageCount());
                    }
                }
                query = new StringBuilder(300);
                query.append("SELECT session.item_id, session.sid,");
                query.append(" COUNT(session.id) as number, SUM(session.session_time) as time, SUM(session.round_session_time) as round_time, SUM(session.cost) AS cost FROM ");
                query.append(table);
                query.append(" AS session");
                query.append((CharSequence)where);
                query.append(" GROUP BY session.item_id, session.sid");
                if (page.getPageSize() > 0) {
                    query.append(page.sqlLimit());
                }
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, cid);
                rs = ps.executeQuery();
                PreparedStatement getSimpleItemPS = ClientItemManager.getSimpleItemPS(this.con, this.moduleId);
                PreparedStatement getNumbersPS = ClientItemManager.getNumbersPS(this.con, this.moduleId);
                PreparedStatement getPortsPS = ClientItemManager.getPortsPS(this.con, this.moduleId);
                PreparedStatement getServicePS = this.con.prepareStatement("SELECT title FROM service WHERE id=?");
                while (rs.next()) {
                    result.add(this.getServiceReportFromRS(rs, getSimpleItemPS, getNumbersPS, getPortsPS, getServicePS));
                }
                rs.close();
                ps.close();
                getSimpleItemPS.close();
                getNumbersPS.close();
                getPortsPS.close();
                getServicePS.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return new PagedList(result, page, records, (Object)total);
    }

    public Report getTotal(int cid, Calendar gotdate1, Calendar gotdate2, int type, boolean noFree, int serviceId, int clientItem, String from164, String items) {
        Calendar date1 = (Calendar)gotdate1.clone();
        Calendar date2 = (Calendar)gotdate2.clone();
        Report total = new Report();
        String table = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)date1.getTime(), (int)this.moduleId);
        if (ServerUtils.tableExists((Connection)this.con, (String)table)) {
            StringBuilder query = new StringBuilder(150);
            query.append("SELECT COUNT(session.id), SUM(session.session_time), SUM(session.round_session_time), SUM(session.cost) FROM " + table + " as session");
            query.append(" WHERE session.cid=?");
            if (date1 != null && date1.get(5) != date1.getActualMinimum(5)) {
                query.append(" AND session.session_start>='");
                query.append(TimeUtils.formatSQLDate((Date)date1.getTime()));
                query.append("'");
            }
            if (date2 != null && date2.get(5) != date2.getActualMaximum(5)) {
                date2.add(5, 1);
                query.append(" AND session.session_start<'");
                query.append(TimeUtils.formatSQLDate((Date)date2.getTime()));
                query.append("'");
            }
            if (serviceId > 0) {
                query.append(" AND session.sid=");
                query.append(serviceId);
            }
            if (items != null) {
                query.append(" AND session.item_id IN (");
                query.append(items);
                query.append(")");
            }
            if (clientItem > 0) {
                query.append(" AND session.item_id=");
                query.append(clientItem);
            }
            if (from164 != null) {
                query.append(" AND session.from_number_164=?");
            }
            if (noFree) {
                query.append(" AND session.cost!=0");
            }
            try {
                PreparedStatement ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, cid);
                if (from164 != null) {
                    ps.setString(2, from164);
                }
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    total.setNumber(rs.getInt(1));
                    total.setTime(rs.getInt(2));
                    total.setTimeRound(rs.getInt(3));
                    total.setCost(rs.getBigDecimal(4));
                }
                rs.close();
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return total;
    }

    private Report getServiceReportFromRS(ResultSet rs, PreparedStatement getSimpleItemPS, PreparedStatement getNumbersPS, PreparedStatement getPortsPS, PreparedStatement getServicePS) throws SQLException {
        Report result = new Report();
        int itemId = rs.getInt("item_id");
        this.setItemTitle(getSimpleItemPS, getNumbersPS, getPortsPS, result, itemId);
        int sid = rs.getInt("sid");
        result.setDestCode(sid);
        String serviceTitle = this.serviceTitles.get(sid);
        if (serviceTitle == null) {
            getServicePS.setInt(1, sid);
            ResultSet destRS = getServicePS.executeQuery();
            if (destRS.next()) {
                serviceTitle = destRS.getString(1);
                this.serviceTitles.put(sid, serviceTitle);
            }
            destRS.close();
        }
        result.setDestination(serviceTitle);
        result.setNumber(rs.getInt("number"));
        result.setTime(rs.getInt("time"));
        result.setTimeRound(rs.getInt("round_time"));
        result.setCost(rs.getBigDecimal("cost"));
        return result;
    }

    private void setItemTitle(PreparedStatement getSimpleItemPS, PreparedStatement getNumbersPS, PreparedStatement getPortsPS, Report result, int itemId) throws SQLException {
        result.setClientItemId(itemId);
        String itemTitle = this.itemTitles.get(result.getClientItemId());
        if (itemTitle == null) {
            itemTitle = ClientItem.toString(result.getClientItemId(), getSimpleItemPS, getNumbersPS, getPortsPS);
            this.itemTitles.put(itemId, itemTitle);
            ArrayList<String> numberList = new ArrayList<String>();
            ArrayList<String> portList = new ArrayList<String>();
            getNumbersPS.setInt(1, itemId);
            ResultSet rs = getNumbersPS.executeQuery();
            while (rs.next()) {
                numberList.add(rs.getString(1));
            }
            rs.close();
            getPortsPS.setInt(1, itemId);
            rs = getPortsPS.executeQuery();
            while (rs.next()) {
                portList.add(rs.getString(1));
            }
            rs.close();
            this.itemNumbers.put(itemId, numberList);
            this.itemPorts.put(itemId, portList);
        }
        result.setPortList(this.itemPorts.get(itemId));
        result.setNumberList(this.itemNumbers.get(itemId));
        result.setClientItem(itemTitle);
    }

    public PagedList<Session> getSessionIncomingList(int cid, String items, Calendar date1, Calendar date2, Page page) {
        int records = 0;
        Session total = new Session();
        ArrayList<Session> result = new ArrayList<Session>();
        StringBuilder query = new StringBuilder(220);
        StringBuilder totalQuery = new StringBuilder(220);
        String table = ServerUtils.getModuleMonthTableName((String)"log_incoming_session", (Date)date1.getTime(), (int)this.moduleId);
        if (ServerUtils.tableExists((Connection)this.con, (String)table) && !Utils.isEmptyString((String)items)) {
            StringBuilder where = new StringBuilder(120);
            where.append(" WHERE session.cid=?");
            if (date1 != null && date1.get(5) != date1.getActualMinimum(5)) {
                where.append(" AND session.session_start>='");
                where.append(TimeUtils.formatSQLDate((Date)date1.getTime()));
                where.append("'");
            }
            if (date2 != null && date2.get(5) != date2.getActualMaximum(5)) {
                date2.add(5, 1);
                where.append(" AND session.session_start<'");
                where.append(TimeUtils.formatSQLDate((Date)date2.getTime()));
                where.append("'");
            }
            if (items != null) {
                where.append(" AND item_id IN (");
                where.append(items);
                where.append(")");
            }
            totalQuery.append("SELECT COUNT(*), SUM(session.session_time) FROM ");
            totalQuery.append(table);
            totalQuery.append(" AS session");
            totalQuery.append((CharSequence)where);
            query.append("SELECT session.* FROM ");
            query.append(table);
            query.append(" AS session");
            query.append((CharSequence)where);
            query.append(" ORDER BY session_start");
            if (page.getPageSize() > 0) {
                query.append(page.sqlLimit());
            }
            try {
                PreparedStatement ps = this.con.prepareStatement(totalQuery.toString());
                ps.setInt(1, cid);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    records = rs.getInt(1);
                    total.setSessionTime(rs.getInt(2));
                }
                rs.close();
                ps.close();
                if (page.getPageSize() > 0) {
                    page.setRecordCount(records);
                }
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, cid);
                rs = ps.executeQuery();
                PreparedStatement getSimpleItemPS = ClientItemManager.getSimpleItemPS(this.con, this.moduleId);
                PreparedStatement getNumbersPS = ClientItemManager.getNumbersPS(this.con, this.moduleId);
                PreparedStatement getPortsPS = ClientItemManager.getPortsPS(this.con, this.moduleId);
                while (rs.next()) {
                    result.add(this.getSessionIncomingFromRS(rs, getSimpleItemPS, getNumbersPS, getPortsPS));
                }
                rs.close();
                ps.close();
                getSimpleItemPS.close();
                getNumbersPS.close();
                getPortsPS.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return new PagedList(result, page, records, (Object)total);
    }

    private Session getSessionIncomingFromRS(ResultSet rs, PreparedStatement getSimpleItemPS, PreparedStatement getNumbersPS, PreparedStatement getPortsPS) throws SQLException {
        Session result = new Session();
        int itemId = rs.getInt("item_id");
        result.setCid(rs.getInt("cid"));
        result.setCdrId(rs.getInt("cdr_id"));
        result.setHour(rs.getTimestamp("hour"));
        result.setClientItemId(itemId);
        result.setSourceId(rs.getInt("source_id"));
        result.setFromNumber164(rs.getString("from_number_164"));
        result.setToNumber164(rs.getString("to_number_164"));
        result.setFromNumber(rs.getString("from_number"));
        result.setToNumber(rs.getString("to_number"));
        result.setSessionTime(rs.getInt("session_time"));
        result.setSessionStart(rs.getTimestamp("session_start"));
        String itemTitle = this.itemTitles.get(result.getClientItemId());
        if (itemTitle == null) {
            itemTitle = ClientItem.toString(result.getClientItemId(), getSimpleItemPS, getNumbersPS, getPortsPS);
            this.itemTitles.put(itemId, itemTitle);
        }
        result.setClientItem(itemTitle);
        return result;
    }
}

