/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class VlanManager {
    protected int mid = -1;
    protected Connection con;

    public VlanManager(int mid, Connection con) {
        this.mid = mid;
        this.con = con;
    }

    public int getVlan(int gateId, int cid) {
        int result = -1;
        String sql = " SELECT vid  FROM ipn_gate_vlan_" + this.mid + " WHERE gid = ? AND cid = ?";
        try {
            PreparedStatement ps = this.con.prepareStatement(sql);
            ps.setInt(1, gateId);
            ps.setInt(2, cid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public boolean getVlan(int gateId) {
        String sql = " SELECT vid  FROM ipn_gate_vlan_" + this.mid + " WHERE gid = ?";
        try {
            PreparedStatement ps = this.con.prepareStatement(sql);
            ps.setInt(1, gateId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                rs.close();
                ps.close();
                return true;
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public int getUsedVlan(int gateId, int vlanId) {
        int result = -1;
        String sql = " SELECT * FROM ipn_gate_vlan_" + this.mid + " WHERE gid = ? AND vid=?";
        try {
            PreparedStatement ps = this.con.prepareStatement(sql);
            ps.setInt(1, gateId);
            ps.setInt(2, vlanId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<List<Integer>> getVlanList(int cid) {
        ArrayList<List<Integer>> result = new ArrayList<List<Integer>>();
        try {
            PreparedStatement ps = null;
            ps = this.con.prepareStatement("SELECT gid, vid  FROM ipn_gate_vlan_" + this.mid + " WHERE cid = ?");
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ArrayList<Integer> rec = new ArrayList<Integer>();
                rec.add(rs.getInt(1));
                rec.add(rs.getInt(2));
                result.add(rec);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public Integer getFreeVlan(int gateId, List<List<Integer>> rangeList) {
        Integer result = null;
        String sql = " SELECT vid  FROM ipn_gate_vlan_" + this.mid + " WHERE gid = ? AND vid >= ?  ORDER BY vid ASC";
        if (rangeList.size() == 0) {
            return result;
        }
        int limit = rangeList.get(0).get(0);
        try {
            int vid;
            PreparedStatement ps = this.con.prepareStatement(sql);
            ps.setInt(1, gateId);
            ps.setInt(2, limit);
            ResultSet rs = ps.executeQuery();
            int value = limit;
            int idx = 0;
            boolean flag = false;
            while (rs.next() && (vid = rs.getInt(1)) == value) {
                List<Integer> list = rangeList.get(idx);
                int r2 = list.get(1);
                if (++value <= r2) continue;
                if (++idx > rangeList.size()) {
                    flag = true;
                    break;
                }
                list = rangeList.get(idx);
                value = list.get(0);
            }
            rs.close();
            ps.close();
            if (!flag) {
                result = value;
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public int createVlan(int vid, int gateId, int cid) {
        int n;
        block8: {
            int result = -1;
            String sql = " INSERT INTO  ipn_gate_vlan_" + this.mid + " (vid, gid, cid)  VALUES(?, ?, ?)";
            PreparedStatement ps = this.con.prepareStatement(sql, 1);
            try {
                ps.setInt(1, vid);
                ps.setInt(2, gateId);
                ps.setInt(3, cid);
                ps.executeUpdate();
                n = ServerUtils.lastInsertId((PreparedStatement)ps);
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return result;
                }
            }
            ps.close();
        }
        return n;
    }

    public void removeVlan(int vid, int gateId, int cid) {
        String sql = " DELETE FROM ipn_gate_vlan_" + this.mid + " WHERE vid = ? AND  gid = ? AND cid = ? ";
        try {
            PreparedStatement ps = this.con.prepareStatement(sql);
            ps.setInt(1, vid);
            ps.setInt(2, gateId);
            ps.setInt(3, cid);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

