/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.server.service;

import bitel.billing.server.contract.bean.CommentPatternManager;
import bitel.billing.server.script.bean.ScriptManager;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPattern;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPatternNamedNumber;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractParameterGroupNameDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractPatternNamedNumberDao;
import ru.bitel.bgbilling.kernel.contract.pattern.common.dto.ContractParameterData;
import ru.bitel.bgbilling.kernel.contract.pattern.common.dto.ContractPatternInfo;
import ru.bitel.bgbilling.kernel.contract.pattern.common.dto.ContractTariffData;
import ru.bitel.bgbilling.kernel.contract.pattern.common.dto.PatternData;
import ru.bitel.bgbilling.kernel.contract.pattern.common.service.ContractPatternService;
import ru.bitel.bgbilling.kernel.contract.pattern.server.bean.ContractPatternDao;
import ru.bitel.bgbilling.kernel.generator.common.bean.BGGenerator;
import ru.bitel.bgbilling.kernel.generator.common.bean.enums.BGGeneratorType;
import ru.bitel.bgbilling.kernel.generator.server.bean.BGGeneratorDao;
import ru.bitel.bgbilling.kernel.module.common.bean.PermissionKit;
import ru.bitel.bgbilling.kernel.module.common.bean.Role;
import ru.bitel.bgbilling.kernel.sequence.common.bean.BGSequence;
import ru.bitel.bgbilling.kernel.sequence.common.bean.enums.BGSequenceType;
import ru.bitel.bgbilling.kernel.sequence.server.bean.BGSequenceDao;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroup;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffGroupDao;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.directories.domain.server.DomainRuntimeMap;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.pattern.common.service.ContractPatternService")
public class ContractPatternServiceImpl
extends AbstractService
implements ContractPatternService {
    @Override
    public List<ContractPatternNamedNumber> numedNumberPatternList() throws Exception {
        return new ContractPatternNamedNumberDao(this.getConnection()).list();
    }

    @Override
    public void updateNamedNumber(ContractPatternNamedNumber namedNumber) throws Exception {
        new ContractPatternNamedNumberDao(this.getConnection()).update((Object)namedNumber);
    }

    @Override
    public int getNextNamedNumberIndex(String title) throws Exception {
        return new ContractPatternNamedNumberDao(this.getConnection()).getNextNamedNumberIndex(title);
    }

    @Override
    public void deleteNamedNumber(int id) throws Exception {
        new ContractPatternNamedNumberDao(this.getConnection()).delete(id);
    }

    @Override
    public List<ContractPatternInfo> contractPatternlist(String nondef) throws Exception {
        ArrayList<ContractPatternInfo> patterns = new ArrayList<ContractPatternInfo>();
        Set<Integer> domainIds = null;
        if (!PermissionOfRoles.isAdmin(this.userId)) {
            Optional<Role> role = PermissionOfRoles.getRoleByUserId(this.userId);
            if (role.isEmpty()) {
                return patterns;
            }
            List<PermissionKit> kits = role.get().getPermissionKits();
            if (Utils.isEmptyCollection(kits)) {
                return patterns;
            }
            HashSet<Integer> domainsInKits = new HashSet<Integer>();
            for (PermissionKit kit : kits) {
                domainsInKits.addAll(kit.getDomenIds());
            }
            domainIds = DomainRuntimeMap.getInstance().getAllDescendantDomainIds(domainsInKits);
        }
        if (nondef == null && Setup.getSetup().getBoolean("contract.template.default.enable", true)) {
            patterns.add(ContractPatternInfo.builder().setId(0).setTitle("\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e").setPatternMode("").setTitlePattern("").build());
        }
        patterns.addAll(new ContractPatternDao(this.getConnection()).getContractPatternList(domainIds));
        return patterns;
    }

    @Override
    public List<ContractParameterData> contractPatternContractParameterList(int contractPatternId) throws Exception {
        return new ContractPatternDao(this.getConnection()).contractParameterDataList(contractPatternId);
    }

    @Override
    public List<KeyValue> contractParameterGroupList() throws Exception {
        ArrayList<KeyValue> values = new ArrayList<KeyValue>();
        ContractParameterGroupNameDao contractParameterGroupNameDao = new ContractParameterGroupNameDao(this.getConnection());
        values.add(new KeyValue("0", "\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e (\u0432\u0441\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b)"));
        values.addAll(contractParameterGroupNameDao.list().stream().map(a -> new KeyValue(String.valueOf(a.getId()), a.getTitle())).toList());
        return values;
    }

    @Override
    public List<KeyValue> contractCommentPatternList() throws Exception {
        ArrayList<KeyValue> values = new ArrayList<KeyValue>();
        values.add(new KeyValue("0", KeyValue.NO_SELECT.getValue()));
        values.addAll(new CommentPatternManager(this.getConnection()).getContractCommentPatternList().stream().map(a -> new KeyValue(String.valueOf(a.getId()), a.getTitle())).toList());
        return values;
    }

    @Override
    public List<ContractTariffData> contractPatternTariffList(int contractPatternId) throws Exception {
        ContractPattern contractPattern = new ContractPatternDao(this.getConnection()).getPattern(contractPatternId);
        if (contractPattern != null) {
            String tariffMode;
            switch (tariffMode = contractPattern.getMasterTariffMode()) {
                case "selectTariffFromGroup": {
                    List<Integer> tariffGroupIds = contractPattern.getTariffGroupList();
                    if (tariffGroupIds == null || tariffGroupIds.isEmpty()) {
                        return null;
                    }
                    Integer tariffGroupId = tariffGroupIds.get(0);
                    TariffGroup tariffGroup = this.context.getDirectory(TariffGroup.class, 0).get(tariffGroupId);
                    return tariffGroup == null ? null : tariffGroup.getPlanList().stream().filter(a -> TimeUtils.dateInRange((Date)new Date(), (Date)a.getDate1(), (Date)a.getDate2())).map(a -> ContractTariffData.builder().setId(a.getId()).setTitle(a.getTitle()).setTariffGroupId(0).build()).toList();
                }
            }
        }
        return null;
    }

    @Override
    public List<IdTitle> contractPatterns(boolean showHidden) throws Exception {
        return new ContractPatternDao(this.getConnection()).contractPatternTitles(showHidden);
    }

    @Override
    public PatternData patternDataGet() throws Exception {
        PatternData patternData = new PatternData();
        try (TariffGroupDao tariffGroupManager = new TariffGroupDao(this.getConnection());){
            patternData.getTariffGroupList().add(new IdTitle(0, "<\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430>"));
            patternData.getTariffGroupList().addAll(tariffGroupManager.list().stream().map(IdTitle::toIdTitle).toList());
        }
        patternData.setScriptList(new ScriptManager(this.getConnection()).getScriptList().stream().map(IdTitle::toIdTitle).toList());
        return patternData;
    }

    @Override
    public List<BGSequence> patternSequenceList() throws Exception {
        return new BGSequenceDao(this.getConnection()).list(BGSequenceType.CONTRACT);
    }

    @Override
    public List<IdTitle> patternSequenceTitles() throws Exception {
        return new BGSequenceDao(this.getConnection()).list(BGSequenceType.CONTRACT).stream().map(IdTitle::toIdTitle).toList();
    }

    @Override
    public BGSequence patternSequenceGet(int sequenceId) throws Exception {
        return (BGSequence)new BGSequenceDao(this.getConnection()).get(sequenceId);
    }

    @Override
    public int patternSequenceUpdate(BGSequence sequence) throws Exception {
        if (sequence.getSequenceType() != BGSequenceType.CONTRACT) {
            throw new BGMessageException("BGSequenceType != CONTRACT");
        }
        new BGSequenceDao(this.getConnection()).update((Object)sequence);
        return sequence.getId();
    }

    @Override
    public boolean patternSequenceDelete(int sequenceId) throws Exception {
        return new BGSequenceDao(this.getConnection()).delete(sequenceId) > 0;
    }

    @Override
    public List<BGGenerator> patternGeneratorList() throws Exception {
        return new BGGeneratorDao(this.getConnection()).list(BGGeneratorType.CONTRACT);
    }

    @Override
    public List<IdTitle> patternGeneratorTitles() throws Exception {
        return new BGGeneratorDao(this.getConnection()).list(BGGeneratorType.CONTRACT).stream().map(a -> new IdTitle(a.getId(), a.getTitle() + " => " + a.getPattern())).toList();
    }

    @Override
    public BGGenerator patternGeneratorGet(int generatorId) throws Exception {
        return (BGGenerator)new BGGeneratorDao(this.getConnection()).get(generatorId);
    }

    @Override
    public int patternGeneratorUpdate(BGGenerator generator) throws Exception {
        if (generator.getGeneratorType() != BGGeneratorType.CONTRACT) {
            throw new BGMessageException("BGGeneratorType != CONTRACT");
        }
        new BGGeneratorDao(this.getConnection()).update((Object)generator);
        return generator.getId();
    }

    @Override
    public boolean patternGeneratorDelete(int generatorId) throws Exception {
        return new BGGeneratorDao(this.getConnection()).delete(generatorId) > 0;
    }
}

