/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common.pattern.editors;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import javax.swing.DefaultComboBoxModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigBaseEditor;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigTitle;
import ru.bitel.common.XMLUtils;

public class ConfigListEditor
extends ConfigBaseEditor {
    private BGComboBox<ComboBoxItem> comboBox = new BGComboBox();

    public ConfigListEditor() {
        this.addComp(this.comboBox);
    }

    public String showDialog(ConfigTitle selectTitle) {
        this.originalValue = selectTitle.getValue();
        this.comboBox.setModel(this.buildComboBox(selectTitle.getEl(), this.originalValue, "value"));
        this.moveWindowToCenterScreen();
        this.result = "cancel";
        this.defaultValue = selectTitle.getDefaultValue();
        if (!selectTitle.isBold()) {
            this.comboBox.setEnabled(false);
            this.checkBox.setSelected(true);
        } else {
            this.checkBox.setSelected(false);
            this.comboBox.setEnabled(true);
        }
        return super.showDialog();
    }

    public DefaultComboBoxModel<ComboBoxItem> buildComboBox(Node node, String selected, String titleName) {
        DefaultComboBoxModel<ComboBoxItem> model = new DefaultComboBoxModel<ComboBoxItem>();
        if (node == null || !node.hasChildNodes()) {
            return model;
        }
        for (Element item : XMLUtils.elements(node.getChildNodes())) {
            String item_title = XMLUtils.getAttribute(item, titleName, null);
            if (item_title == null) continue;
            try {
                String description = XMLUtils.selectText(item, "text()");
                String title = description != null ? item_title + " - " + description : item_title;
                ComboBoxItem comboBoxItem = new ComboBoxItem(item_title, title);
                model.addElement(comboBoxItem);
                if (selected == null || !selected.equals(item_title)) continue;
                model.setSelectedItem(comboBoxItem);
            }
            catch (Exception exception) {}
        }
        return model;
    }

    public static boolean checkValue(String valueStr, Element el) {
        if (el == null || !el.hasChildNodes()) {
            return false;
        }
        for (Element item : XMLUtils.elements(el.getChildNodes())) {
            String item_title = XMLUtils.getAttribute(item, "value", null);
            if (item_title == null || !item_title.equals(valueStr)) continue;
            return true;
        }
        return false;
    }
}

