/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.gar.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.plugins.gar.common.service.GarService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class GarPluginSettingsPanel
extends BGUPanel {
    private LoadRegionPanel loadRegionPanel;
    private GarService garService;

    public GarPluginSettingsPanel() {
        this.setLayout(new GridBagLayout());
    }

    public GarService getGarService() {
        if (this.garService == null) {
            this.garService = (GarService)((ClientContext)this.getContext()).getPort(GarService.class);
        }
        return this.garService;
    }

    protected void jbInit() throws Exception {
        this.loadRegionPanel = new LoadRegionPanel();
        this.add(this.loadRegionPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                GarPluginSettingsPanel.this.loadRegionPanel.loadData();
            }
        };
    }

    private final class LoadRegionPanel
    extends JPanel {
        private final BGUComboBox<IdTitle> regions = new BGUComboBox();
        private final BGButton loadSelectedRegion = new BGButton("\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0440\u0435\u0433\u0438\u043e\u043d");

        public LoadRegionPanel() {
            this.setLayout(new GridBagLayout());
            this.loadSelectedRegion.setVisible(false);
            this.regions.addItemListener(e -> {
                IdTitle selectedRegion = (IdTitle)this.regions.getSelectedItem();
                if (e.getStateChange() == 1 && selectedRegion != null && selectedRegion.getId() > 0) {
                    try {
                        this.loadSelectedRegion.setVisible(!GarPluginSettingsPanel.this.getGarService().checkLoadedRegion(selectedRegion.getId()));
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                } else {
                    this.loadSelectedRegion.setVisible(false);
                }
            });
            this.loadSelectedRegion.addActionListener(e -> {
                IdTitle selectedRegion = (IdTitle)this.regions.getSelectedItem();
                if (selectedRegion != null && selectedRegion.getId() > 0) {
                    try {
                        JSONObject response = new JSONObject(GarPluginSettingsPanel.this.getGarService().loadRegion(selectedRegion.getId()));
                        ClientUtils.showMessageDialog((Object)response.optString("comment"));
                        this.loadSelectedRegion.setVisible(false);
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            });
            BGSwingUtilites.wrapBorder((JPanel)this, (String)"\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0440\u0435\u0433\u0438\u043e\u043d\u043e\u0432");
            this.add((Component)new JLabel("\u0420\u0435\u0433\u0438\u043e\u043d"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 3), 0, 0));
            this.add((Component)this.regions, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 3), 0, 0));
            this.add((Component)this.loadSelectedRegion, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 3), 0, 0));
        }

        private void loadData() throws Exception {
            ArrayList<IdTitle> data = new ArrayList<IdTitle>();
            data.add(new IdTitle(-1, "-----------"));
            List l = GarPluginSettingsPanel.this.getGarService().regionList();
            l.forEach(r -> r.setTitle(String.format("[%s] %s", r.getId(), r.getTitle())));
            data.addAll(l);
            this.regions.setData(data);
        }
    }
}

