/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.client;

import bitel.billing.module.common.BGTextArea;
import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamAddressEditorDialog;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.directories.address.common.bean.Area;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.bean.Quarter;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;

public class AddressHouseAddNewDialog
extends BGEditorDialog<House> {
    private final ClientContext context;
    private final BGUComboBox<IdTitle> city = new BGUComboBox();
    private final BGUComboBox<IdTitle> street = new BGUComboBox();
    private final BGUComboBox<IdTitle> area = new BGUComboBox();
    private final BGUComboBox<IdTitle> quarter = new BGUComboBox();
    private final JTextField house = new JTextField(20);
    private final IntTextField postIndex = new IntTextField();
    private final IntTextField flatAmount = new IntTextField();
    private final BGTextArea comment = new BGTextArea(3, 20);
    private final ContractParamAddressEditorDialog addressEditorDialog;

    public AddressHouseAddNewDialog(String title, ContractParamAddressEditorDialog addressEditorDialog, ClientContext context) {
        super(title, new House());
        this.context = context;
        this.addressEditorDialog = addressEditorDialog;
    }

    @Override
    public void doDialogPanel() {
        this.panel.add((Component)BGSwingUtilites.setDimension(this.getLeftPanel(), 500, 200), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.panel.add((Component)this.getRightPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        try {
            ArrayList<IdTitle> cityList = new ArrayList<IdTitle>();
            cityList.add(new IdTitle(0, "=== \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d ==="));
            cityList.addAll(this.context.getDirectory(City.class, 0).list().stream().map(IdTitle::toIdTitle).toList());
            this.city.setData(cityList);
            this.city.addActionListener(e -> this.setAddressToEditor());
            this.city.setSelectedItem(cityList.stream().filter(a -> ((House)this.data).getCity() != null && a.getId() == ((House)this.data).getCity().getId()).findFirst().orElse((IdTitle)cityList.get(0)));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.flatAmount.setText(String.valueOf(((House)this.data).getAmount()));
        this.street.addActionListener(e -> this.setIndex());
    }

    private JPanel getLeftPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0413\u043e\u0440\u043e\u0434"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add(this.city, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0423\u043b\u0438\u0446\u0430"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add(this.street, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0420\u0430\u0439\u043e\u043d (\u043e\u043f\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e)"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add(this.area, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041a\u0432\u0430\u0440\u0442\u0430\u043b (\u043e\u043f\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e)"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add(this.quarter, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getRightPanel() {
        this.comment.setOpaque(true);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getSubRightPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getSubRightPanel() {
        this.house.setHorizontalAlignment(0);
        this.postIndex.setColumns(6);
        this.postIndex.setHorizontalAlignment(0);
        this.flatAmount.setColumns(3);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0414\u043e\u043c/\u0414\u0440\u043e\u0431\u044c"), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.house, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041f\u043e\u0447\u0442\u043e\u0432\u044b\u0439 \u0438\u043d\u0434\u0435\u043a\u0441"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.postIndex, new GridBagConstraints(0, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u0432\u0430\u0440\u0442\u0438\u0440"), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        panel.add((Component)this.flatAmount, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 10, 0, 0), 0, 0));
        return panel;
    }

    @Override
    public boolean doApply() throws Exception {
        if (!this.checkAddress()) {
            return false;
        }
        Object[] houseAndFrac = House.getHouseAndFrac((String)this.house.getText());
        ((House)this.data).setCityId(((IdTitle)this.city.getSelectedItem()).getId());
        ((House)this.data).setStreetId(((IdTitle)this.street.getSelectedItem()).getId());
        ((House)this.data).setAreaId(((IdTitle)this.area.getSelectedItem()).getId());
        ((House)this.data).setQuarterId(((IdTitle)this.quarter.getSelectedItem()).getId());
        ((House)this.data).setHouse(((Integer)houseAndFrac[0]).intValue());
        ((House)this.data).setFrac((String)houseAndFrac[1]);
        ((House)this.data).setPostIndex(this.postIndex.getText());
        ((House)this.data).setAmount(Utils.parseInt(this.flatAmount.getText().trim()));
        ((House)this.data).setComment(this.comment.getText().trim());
        ((House)this.data).setId(this.context.getWebService(AddressService.class, 0).houseUpdate((House)this.data));
        if (((House)this.data).getId() > 0) {
            this.addressEditorDialog.setSelectedHouse(((House)this.data).getId());
        }
        return true;
    }

    @Override
    public void doCancel() {
        this.data = null;
    }

    private void setAddressToEditor() {
        int cityId = ((IdTitle)this.city.getSelectedItem()).getId();
        try {
            IdTitle noSelectItem = new IdTitle(0, "=== \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d ===");
            ArrayList<IdTitle> items = new ArrayList<IdTitle>();
            List<Street> streets = this.context.getDirectory(Street.class, 0).list();
            items.add(noSelectItem);
            items.addAll(streets.stream().filter(a -> a.getCity().getId() == cityId).map(IdTitle::toIdTitle).toList());
            this.street.setData(items);
            items = new ArrayList();
            List<Area> areas = this.context.getDirectory(Area.class, 0).list();
            items.add(noSelectItem);
            items.addAll(areas.stream().filter(a -> a.getCity().getId() == cityId).map(IdTitle::toIdTitle).toList());
            this.area.setData(items);
            items = new ArrayList();
            List<Quarter> quarters = this.context.getDirectory(Quarter.class, 0).list();
            items.add(noSelectItem);
            items.addAll(quarters.stream().filter(a -> a.getCity().getId() == cityId).map(IdTitle::toIdTitle).toList());
            this.quarter.setData(items);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void setIndex() {
        try {
            Object item = this.street.getSelectedItem();
            if (item instanceof IdTitle) {
                int streetId = item != null ? ((IdTitle)item).getId() : -1;
                this.postIndex.setText(this.context.getWebService(AddressService.class, 0).houseIndexGet(streetId, this.house.getText().trim(), 0, null));
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    public boolean checkAddress() {
        if (((IdTitle)this.city.getSelectedItem()).getId() == 0) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0433\u043e\u0440\u043e\u0434");
            return false;
        }
        if (((IdTitle)this.street.getSelectedItem()).getId() == 0) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u0443\u043b\u0438\u0446\u0430");
            return false;
        }
        if ("".equals(this.house.getText().trim())) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u0432\u0435\u0434\u0435\u043d\u043e \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435: \u0434\u043e\u043c");
            return false;
        }
        if ("".equals(this.flatAmount.getText().trim())) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u0432\u0435\u0434\u0435\u043d\u043e \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435: \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e");
            return false;
        }
        return true;
    }
}

